unit jp5_about;

interface

uses
    windows, messages, jp5_kern, tn_utils, jp5_serv, tn_stdctl, tn_fw
        , jp5_regist, commctrl;

type
    TAboutDlg       =   class(WModalDialog)
        public
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

const
    COPYRIGHT_MSG   =   2101;

//\[X
const
    OK_MSG          =   3301;
    ERR_MSG         =   3302;
    STOP_MSG        =   3303;

//procedure
	procedure ShowAboutDlg;

implementation

//******************************************************************************
// TAboutDlg

procedure TAboutDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    //POPT[ȍ
    if Server.Pop = nil then
    begin
        Ctl_SetText(GetDlgItem(Handle, 1003), LoadResourceString(STOP_MSG));
    end
    else
    begin
        if Server.Pop.Error then
        begin
            Ctl_SetText(GetDlgItem(Handle, 1003)
                            , Format(LoadResourceString(ERR_MSG)
                                        , [Server.Pop.Port]));
        end
        else
        begin
            Ctl_SetText(GetDlgItem(Handle, 1003)
                            , Format(LoadResourceString(OK_MSG)
                            , [Server.Pop.Port]));
        end;
    end;

    //SMTPT[ȍ
    if Server.Smtp = nil then
    begin
        Ctl_SetText(GetDlgItem(Handle, 1004), LoadResourceString(STOP_MSG));
    end
    else
    begin
        if Server.Smtp.Error then
        begin
            Ctl_SetText(GetDlgItem(Handle, 1004)
                            , Format(LoadResourceString(ERR_MSG)
                            , [Server.Smtp.Port]));
        end
        else
        begin
            Ctl_SetText(GetDlgItem(Handle, 1004)
                            , Format(LoadResourceString(OK_MSG)
                            , [Server.Smtp.Port]));
        end;
    end;

    //\tgEFA\
    Ctl_SetText(GetHandle(1101), GetProductName);

    //o[W\
    Ctl_SetText(GetHandle(1102), 'Version ' + GetVersion);

    //v_Ng[U\
    if Settings.ProductUser <> '' then
    begin
        Ctl_SetText(GetHandle(1005), Settings.ProductUser);
        Ctl_SetEnabled(GetHandle(1001), False);
    end
    else
        Ctl_SetText(GetDlgItem(Handle, 1005), LoadResourceString(4105));

    //bZ[W̕\
    Ctl_SetText(GetDlgItem(Handle, 1002), LoadResourceString(COPYRIGHT_MSG));

    //AVĨ[h&Đ
    Animate_Open(GetHandle(1006), 'JUPPY');
    Animate_Play(GetHandle(1006), 0, 65535, Cardinal(-1));

    SetFocus(GetHandle(1));
    SetActiveWindow(GetHandle(1));
end;

procedure TAboutDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
begin
    //SendMessage(TrayHandle, WM_COMMAND, JP_HIDEABOUT, 0);
end;

procedure TAboutDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
var
    temp : String;
begin
    if wParam = 1000 then
    begin
        temp := Ctl_GetText(GetHandle(1000));
        OpenFile(temp);
    end
    else if wParam = 1001 then
    begin
        ShowRegistDialog(Handle);

        //v_Ng[U\(XV)
        Settings.ProductUser := KeyCheck;
        if Settings.ProductUser <> '' then
        begin
            Ctl_SetText(GetHandle(1005), Settings.ProductUser);
            Ctl_SetEnabled(GetHandle(1001), False);
        end
        else
            Ctl_SetText(GetDlgItem(Handle, 1005), LoadResourceString(4105));
    end
    else
        inherited;
end;

//******************************************************************************

procedure ShowAboutDlg;
var
    Dlg : TAboutDlg;
begin
	if JobHandle = 0 then
	    Dlg := TAboutDlg.Create(TrayHandle, '2003')
    else
	    Dlg := TAboutDlg.Create(JobHandle, '2003');

    Dlg.ShowModal;
    Dlg.Free;
end;

end.
