unit jp5_adv;

interface

uses
    windows, messages, tn_classes, jp5_kern, tn_fw, tn_stdctl, tn_utils
    	, jp5_help;

type
    TAdvanceDlg     =   class(WModalDialog)
        private
            Info : PAccItemInfo;
            procedure Prepare;
        public
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnHelp(var Message: TMessage); message WM_HELP;
    end;

//procedures
    procedure ShowAdvanceDlg(Handle : THandle ; var TargetInfo : TAccItemInfo);

implementation

procedure TAdvanceDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
begin
    if wParam = IDOK then
    begin
        Info.Alias := Ctl_GetText(GetHandle(1001));
        Info.PopAddr := Ctl_GetText(GetHandle(1002));
        Info.PopPort := StrToInt(Ctl_GetText(GetHandle(1003)));
        Info.SmtpAddr := Ctl_GetText(GetHandle(1004));
        Info.SmtpPort := StrToInt(Ctl_GetText(GetHandle(1005)));
        Info.Option := Ctl_GetText(GetHandle(1006));
        Info.APOP := Ctl_IsChecked(GetHandle(1007));
        Close;
    end
    else
        inherited;
end;

procedure TAdvanceDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    Prepare;
end;

procedure TAdvanceDlg.Prepare;
begin
    Ctl_SetText(GetHandle(1001), Info.Alias);
    Ctl_SetText(GetHandle(1002), Info.PopAddr);
    Ctl_SetText(GetHandle(1003), IntToStr(Info.PopPort));
    Ctl_SetText(GetHandle(1004), Info.SmtpAddr);
    Ctl_SetText(GetHandle(1005), IntToStr(Info.SmtpPort));
    Ctl_SetText(GetHandle(1006), Info.Option);
    Ctl_SetCheck(GetHandle(1007), Info.APOP);
end;

procedure TAdvanceDlg.OnHelp(var Message: TMessage);
begin
    WinHelp(TrayHandle
                , PChar(ExtractFilePath(ParamStr(0)) + 'jp5dx.hlp')
                , HELP_CONTEXT, HELPC_0039);

    Message.Result := 0;
end;

//******************************************************************************

procedure ShowAdvanceDlg(Handle : THandle ; var TargetInfo : TAccItemInfo);
var
    Dlg : TAdvanceDlg;
begin
    Dlg := TAdvanceDlg.Create(Handle, '2013');
    Dlg.Info := @TargetInfo;
    Dlg.ShowModal;
    Dlg.Free;
end;

end.
