unit jp5_debug;

interface

uses
    windows, messages, shellapi, tn_utils, jp5_dll, jp5_kern;

var
    DebugFile : String;
    DebugHandle : THandle;
    TimerHandle : THandle;
    WatchStop : Boolean;
    CachePath : String;
    SaveBoxPath : String;
    LoadBoxPath : String;


//procedure
    procedure ShowDebugDlg;

const
    TITLE           =   'Grape Software Jupiter 5';
    DEBUG_DLG       =   2001;

//\[X
const
    ERR_NOTJSFILE   =   3101;
    ERR_NOTFILECH   =   3102;
    ERR_OPENDEBUG   =   3103;
    CAPTION_RUN     =   3104;
    CAPTION_STOP    =   3105;

implementation

procedure ShowDebugDlg;

    function DialogCallBack(hDlg : THandle ; uMsg : Cardinal ; wParam : Integer ; lParam : integer) : BOOL; stdcall;
    var
        dummy : Integer;
        Handle : THandle;
        temp : String;
        Buf : array [0..512] of Char;
        TempBuf : String;
        Item : TItemInfo;
        Size : Integer;
        Style : Cardinal;
        StrData : PChar;
    begin
        Result := True;

        case uMsg of
            WM_COMMAND:
                begin
                    case WParam of
                        4001:
                            begin
                                //ҏW
                                if DebugFile = '' then
                                begin
                                    MessageBox(TrayHandle
                                        , PChar(LoadResourceString(ERR_NOTFILECH)), TITLE
                                        , MB_TOPMOST or MB_SETFOREGROUND or MB_ICONWARNING);

                                    Exit;
                                end;

                                ShellExecute(hDlg, 'open', 'notepad.exe'
                                            , PChar(DebugFile), nil, SW_SHOW);
                            end;

                        4002:
                            begin
                                //sE~
                                if DebugFile = '' then
                                begin
                                    MessageBox(TrayHandle
                                        , PChar(LoadResourceString(ERR_NOTFILECH)), TITLE
                                        , MB_TOPMOST or MB_SETFOREGROUND or MB_ICONWARNING);

                                    Exit;
                                end;

                                Handle := GetDlgItem(hDlg, 4002);

                                if DebugHandle = 0 then
                                begin
                                    //{^u~vɕς
                                    SendMessage(Handle, WM_SETTEXT, 0
                                                    , Integer(PChar(LoadResourceString(CAPTION_STOP))));

                                    FillChar(Item, SizeOf(Item), #0);
                                    Item.FileName := PChar(DebugFile);
                                    Item.Handle := hDlg;
                                    Item.Cache := PChar(CachePath);
                                    Item.SaveBox := PChar(SaveBoxPath);
                                    Item.LoadBox := PChar(LoadBoxPath);
                                    Item.Temporary := PChar(TempPath);
                                    Item.Proxy_Addr := PChar(Settings.Proxy_Addr);
                                    Item.Proxy_Port := Settings.Proxy_Port;

                                    //fobOo͂NA
                                    Handle := GetDlgItem(hDlg, 4006);
                                    SendMessage(Handle, LB_RESETCONTENT, 0, 0);

                                    //fobOJ
                                    WatchStop := True;
                                    DebugHandle := JupiterOpen(@Item);

                                    //{^Zbg
                                    Handle := GetDlgItem(hDlg, 4004);
                                    SendMessage(Handle, WM_SETTEXT, 0, Integer(PChar(TempBuf)));

                                    //RpC
                                    JupiterCompile(DebugHandle);
                                    
                                    //\擾
                                    Size := JupiterGetStructSize(DebugHandle);
                                    SetLength(TempBuf, Size);
                                    JupiterGetStructStr(DebugHandle, PChar(TempBuf));
                                    Handle := GetDlgItem(hDlg, 4005);
                                    SendMessage(Handle, WM_SETTEXT, 0
                                                    , Integer(PChar(TempBuf)));

                                    //RpCG[擾
                                    Size := JupiterGetCompileSize(DebugHandle);
                                    SetLength(TempBuf, Size);
                                    JupiterGetCompileStr(DebugHandle, PChar(TempBuf));
                                    Handle := GetDlgItem(hDlg, 4004);
                                    SendMessage(Handle, WM_SETTEXT, 0
                                                    , Integer(PChar(TempBuf)));

                                    //s
                                    JupiterRun(DebugHandle, False);
                                    WatchStop := False;
                                end
                                else
                                begin
                                    WatchStop := True;
                                    SendMessage(Handle, WM_SETTEXT, 0
                                                    , Integer(PChar(LoadResourceString(CAPTION_RUN))));
                                    JupiterClose(DebugHandle);
                                    DebugHandle := 0;
                                    WatchStop := False;
                                end;
                            end;
                    end;
                end;

            WM_INITDIALOG:
                begin
                    DragAcceptFiles(hDlg, True);

                    if DebugFile <> '' then
                    begin
                        Handle := GetDlgItem(hDlg, 4000);
                        SendMessage(Handle, WM_SETTEXT, 0, Integer(PChar(DebugFile)));
                    end;

                    //X^Cݒ
                    Style := GetWindowLong(hDlg, GWL_EXSTYLE) or WS_EX_APPWINDOW;
                    SetWindowLong(hDlg, GWL_EXSTYLE, Style);

                    //^C}[̐ݒ
                    TimerHandle := SetTimer(hDlg, 0, 100, nil);
                    Result := False;

                    //pX̐ݒ
                    CachePath := ExtractFilePath(ParamStr(0))
                                        + 'datas\default\cache\';
                    SaveBoxPath := ExtractFilePath(ParamStr(0))
                                        + 'datas\default\savebox\';
                    LoadBoxPath := ExtractFilePath(ParamStr(0))
                                        + 'datas\default\loadbox\';

                    SetActiveWindow(hDlg);
                    SetForegroundWindow(hDlg);
                end;

            WM_DRAWITEM:
                begin
                end;

            WM_CLOSE:
                begin
                    dummy := 0;

                    //słΏI
                    if DebugHandle <> 0 then
                        JupiterClose(DebugHandle);

                    KillTimer(hDlg, 0);
                    EndDialog(hDlg, dummy);
                    SendMessage(TrayHandle, WM_COMMAND, JP_HIDEDEBUG, 0);
                    Result := False;
                end;

            WM_DROPFILES:
                begin
                    //t@C̃hbv
                    FillChar(Buf, SizeOf(Buf), #0);
                    DragQueryFile(wParam, 0, Buf, SizeOf(Buf));
                    DragFinish(wParam);

                    //t@Č
                    temp := Buf;

                    if UpperCase(ExtractFileExt(temp)) <> 'JS' then
                    begin
                        MessageBox(TrayHandle, PChar(ERR_NOTJSFILE), TITLE
                                        , MB_TOPMOST or MB_SETFOREGROUND or MB_ICONWARNING);
                        Exit;
                    end;

                    //fobOt@Cݒ
                    DebugFile := temp;

                    //eLXg̐ݒ
                    Handle := GetDlgItem(hDlg, 4000);
                    SendMessage(Handle, WM_SETTEXT, 0, Integer(@Buf));
                    Result := False;
                end;

            WM_TIMER:
                begin
                    //s̃XNvg̊Ď
                    if (not WatchStop) and (DebugHandle <> 0) then
                    begin
                        if not JupiterIsRunning(DebugHandle) then
                        begin
                            WatchStop := True;
                            JupiterClose(DebugHandle);
                            Handle := GetDlgItem(hDlg, 4002);
                            SendMessage(Handle, WM_SETTEXT, 0
                                            , Integer(PChar(LoadResourceString(CAPTION_RUN))));
                            DebugHandle := 0;
                            WatchStop := False;
                        end;
                    end;
                end;

            WM_JPMESSAGE:
                begin
                    //bZ[W̎M
                    Handle := GetDlgItem(hDlg, 4006);
                    StrData := PChar(lParam);
                    SendMessage(Handle, LB_ADDSTRING, 0, Integer(StrData));
                end;

            else
                Result := False;
        end;
    end;

begin
    SetActiveWindow(GetDesktopWindow);
    SetForegroundWindow(GetDesktopWindow);
    DialogBox(hInstance, MAKEINTRESOURCE(DEBUG_DLG), TrayHandle, @DialogCallBack);
end;

initialization
    DebugFile := '';
    DebugHandle := 0;
    WatchStop := False;

end.
