unit jp5_itemchk;

interface

uses
    windows, messages, tn_classes, jp5_kern, tn_stdctl, tn_utils, tn_fw;

type
    TCheckDlg   =   class(WModalDialog)
        private
            info : PAccItemInfo;
            procedure Prepare;
        public
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

//procedures
    procedure ShowItemChkDlg(Handle : THandle ; var TargetInfo : TAccItemInfo);

implementation


//******************************************************************************

procedure TCheckDlg.Prepare;
var
    Handle : THandle;
    n : Integer;
begin
    Handle := GetHandle(1005);

    //R{{bNX̐ݒ
    for n := 0 to 59 do
        Combo_Add(Handle, IntToStr(n));

    Combo_SetIndex(Handle, 0);

    //ݒɉăZbg
    Combo_SetIndex(Handle, Info.Time);
    Ctl_SetText(GetHandle(1006), IntToStr(Info.Time));

    case Info.IntCheck of
        EXE_NONE:
            begin
                Ctl_SetCheck(GetHandle(1001), True);
                EnableWindow(GetHandle(1005), False);
                EnableWindow(GetHandle(1006), False);
            end;

        EXE_HOUR:
            begin
                Ctl_SetCheck(GetHandle(1002), True);
                EnableWindow(GetHandle(1005), True);
                EnableWindow(GetHandle(1006), False);
            end;

        EXE_INT:
            begin
                Ctl_SetCheck(GetHandle(1003), True);
                EnableWindow(GetHandle(1005), False);
                EnableWindow(GetHandle(1006), True);
            end;
    end;
end;

procedure TCheckDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    Prepare;
end;

procedure TCheckDlg.OnCommand(Sender : WObject ; wParam : Integer
                            ; lParam : Integer ; var Return : LRESULT);
begin
    if wParam = IDOK then
    begin
        if (Ctl_IsChecked(GetHandle(1003)))
            and (StrToInt(Ctl_GetText(GetHandle(1006))) < 1) then
        begin
            MessageBox(Handle, PChar(LoadResourceString(4001))
                        , 'Grape Software Jupiter 5', MB_ICONWARNING);
            Exit;
        end;

        //ݒۑ
        if Ctl_IsChecked(GetHandle(1001)) then
        begin
            Info.IntCheck := EXE_NONE;
        end
        else if Ctl_IsChecked(GetHandle(1002)) then
        begin
            Info.IntCheck := EXE_HOUR;
            Info.Time := StrToInt(Ctl_GetText(GetHandle(1005)));
        end
        else if Ctl_IsChecked(GetHandle(1003)) then
        begin
            Info.IntCheck := EXE_INT;
            Info.Time := StrToInt(Ctl_GetText(GetHandle(1006)));
        end;

        Close;
    end
    else if wParam = IDCANCEL then
        Close
    else if wParam = 1001 then
    begin
        EnableWindow(GetHandle(1005), False);
        EnableWindow(GetHandle(1006), False);
    end
    else if wParam = 1002 then
    begin
        EnableWindow(GetHandle(1005), True);
        EnableWindow(GetHandle(1006), False);
    end
    else if wParam = 1003 then
    begin
        EnableWindow(GetHandle(1005), False);
        EnableWindow(GetHandle(1006), True);
    end;
end;

//******************************************************************************

procedure ShowItemChkDlg(Handle : THandle ; var TargetInfo : TAccItemInfo);
var
    Dlg : TCheckDlg;
begin
    Dlg := TCheckDlg.Create(Handle, '2010');
    Dlg.Info := @TargetInfo;
    Dlg.Prepare;
    Dlg.ShowModal;
    Dlg.Free;
end;

end.
