unit jp5_pass;

interface

uses
    windows, messages, tn_fw, jp5_kern, tn_stdctl, tn_utils;

type
    TPassDlg    =   class(WModalDialog)
        private
            TimeLimit : Integer;
            Title : String;
            Data : String;
        public
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
            procedure OnTimer(var Message: TMessage); message WM_TIMER;
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
    end;

const
    PASS_DLG       =   '2006';

//procedures
    function ShowPassDialog(ItemTitle : String ; Timer : Integer) : String;

implementation

//******************************************************************************

procedure TPassDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
begin
    if wParam = IDOK then
    begin
        Data := Ctl_GetText(GetHandle(1001));
        Close;
    end
    else if wParam = IDCANCEL then
        Close;
end;

procedure TPassDlg.OnTimer(var Message: TMessage);
begin
    Dec(TimeLimit);

    if TimeLimit <= 0 then
    begin
        KillTimer(Handle, 1);
        Close;
    end
    else
        Caption := Format(LoadResourceString(3901), [TimeLimit]);
end;

procedure TPassDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
begin
    if TimeLimit > 0 then KillTimer(Handle, 1);
end;

procedure TPassDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    Ctl_SetText(GetHandle(1000), Title);

    if TimeLimit <> 0 then
    begin
        SetTimer(Handle, 1, 1000, nil);
        Caption := Format(LoadResourceString(3901), [TimeLimit]);
    end;
end;

//******************************************************************************

function ShowPassDialog(ItemTitle : String ; Timer : Integer) : String;
var
    Dlg : TPassDlg;
begin
    Result := '';

    Dlg := TPassDlg.Create(TrayHandle, PASS_DLG);
    Dlg.Title := ItemTitle;
    Dlg.TimeLimit := Timer;
    Dlg.ShowModal;
    Result := Dlg.Data;
    Dlg.Free;
end;

end.

