unit jp5_regist;

interface

uses
    windows, messages, tn_fw, jp5_kern, tn_stdctl, tn_utils, tn_crc;

type
    TRegistDlg  =   class(WModalDialog)
        private
            function IsItGenuine(User : String ; Pass : String) : Boolean;
            procedure WriteInfo(User : String ; Pass : String);
        public
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

//procedures
    procedure ShowRegistDialog(Handle : THandle);
    function RegPassDecode(Source : String) : String;
    function KeyCheck : String;

implementation

//******************************************************************************

procedure TRegistDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
var
    User : String;
    Pass : String;
begin
    if wParam = IDOK then
    begin
        User := Ctl_GetText(GetHandle(1001));
        Pass := Ctl_GetText(GetHandle(1002));

        if User = '' then
        begin
            MessageBox(Handle, PChar(LoadResourceString(4101)), TITLE, MB_ICONWARNING);
            Exit;
        end;

        if Pass = '' then
        begin
            MessageBox(Handle, PChar(LoadResourceString(4102)), TITLE, MB_ICONWARNING);
            Exit;
        end;

        if IsItGenuine(User, Pass) then
        begin
            WriteInfo(User, Pass);
            MessageBox(Handle, PChar(LoadResourceString(4103)), TITLE, MB_ICONWARNING);
        end
        else
            MessageBox(Handle, PChar(LoadResourceString(4104)), TITLE, MB_ICONWARNING);

        Close;
    end
    else
        inherited;
end;

function TRegistDlg.IsItGenuine(User : String ; Pass : String) : Boolean;
begin
    Result := (User = RegPassDecode(Pass)) and (Length(User + ':' + Pass) < 236);
end;

procedure TRegistDlg.WriteInfo(User : String ; Pass : String);
var
    FileName : String;
    Image : array [0..255] of Char;
    Data : String;
    F : File;
    PImage : PChar;
    PCrc : PInteger;
begin
    FileName := ExtractFilePath(ParamStr(0)) + 'jp5.key';
    Data := User + ':' + Pass;
    FillChar(Image, SizeOf(Image), #0);
    PImage := @Image;
    PImage := PImage + 20;
    StrPCopy(PImage, Data);
    PCrc := @Image;
    PCrc^ := GetCrcInt(Data);

    if Length(Data) >= 236 then Exit;

    try
        AssignFile(F, FileName);
        ReWrite(F, 1);
        BlockWrite(F, Image, SizeOf(Image));
    finally
        CloseFile(F);
    end;
end;

//******************************************************************************

procedure ShowRegistDialog(Handle : THandle);
var
    Dlg : TRegistDlg;
begin
    Dlg := TRegistDlg.Create(Handle, '2014');
    Dlg.ShowModal;
    Dlg.Free;
end;

function RegPassDecode(Source : String) : String;
const
    PASS_TABLE = 'CgQ4u7JYZlIcNO3BLbt81h/xmkMzPrFAvaUSs+X5nR2W9EqH6yKDdeGipjwfoV0T';
var
    a , b , k , l , m : Integer;
begin
    l := 13;
    k := 27;
    Result := '';

    if Length(Source) mod 2 <> 0 then Exit;
    for m:= 1 to Length(Source) div 2 do
    begin
        a := Pos(Source[m*2-1], PASS_TABLE) - 1;
        b := Pos(Source[m*2], PASS_TABLE) - 1;
        Result := Result + Chr(((a xor k) xor l ) * 64 + (b xor l));
        k := k + 6;
        l := l + 35;
        if k > 63 then k := k - 64;
        if l > 63 then l := l - 64;
    end;
end;

function KeyCheck : String;
var
    Image : array [0..255] of Char;
    Data : String;
    F : File;
    FileName : String;
    PImage : PChar;
    ps : Integer;
    User : String;
    Pass : String;
begin
    Result := '';
    FileName := ExtractFilePath(ParamStr(0)) + 'jp5.key';
    FillChar(Image, SizeOf(Image), #0);
    if not FileExists(FileName) then Exit;

    try
        AssignFile(F, FileName);
        Reset(F, 1);
        BlockRead(F, Image, SizeOf(Image));
    finally
        CloseFile(F);
    end;

    PImage := @Image;
    Data := String(PChar(PImage + 20));
    if PInteger(PImage)^ <> GetCrcInt(Data) then Exit;
    ps := Pos(':', Data);
    if ps = 0 then Exit;

    User := Copy(Data, 1, ps - 1);
    Pass := Copy(Data, ps + 1, Length(Data) - ps);
    if Length(User) < 5 then Exit;
    if User = RegPassDecode(Pass) then Result := Copy(Data, 1, ps - 1);
end;

end.
