unit jp5_serv;

interface

uses
    windows, winsock, tn_server, tn_utils, tn_classes, jp5_kern, jp5_crypt
        ,tn_crc, jp5_pass, messages;

type
    TPopThread      =   class(TNServerThread)
        private
            procedure DeleteFiles(var NewLists : TNStringList ; Path : String);
		protected
			procedure Execute; override;
    end;

    TSmtpThread      =   class(TNServerThread)
		protected
			procedure Execute; override;
    end;

    TPopServer      =   class(TNServerSocket)
        public
            procedure ThreadStart(NewSocket : TSocket); override;
    end;

    TSmtpServer     =   class(TNServerSocket)
        public
            procedure ThreadStart(NewSocket : TSocket); override;
    end;

    TServer         =   class
        public
            Pop : TPopServer;
            Smtp : TSmtpServer;
            constructor Create;
            destructor Destroy; override;
    end;

var
    Server : TServer;

//procedures
    procedure MailStatus(Path : String ; var ItemCount : Integer ; var TotalSize : Integer);

implementation

//*****************************************************************************
// TPopThread

procedure TPopThread.Execute;
var
    temp : String;
    stemp : String;
    ttemp : String;
    User : String;
    Pass : String;
    Path : String;
    ItemCount : Integer;
    TotalSize : Integer;
    n : Integer;
    Mails : TNStringList;
    Size : Integer;
    Count : Integer;
    Index : Integer;
    //ItemIndex : Integer;
    ps : Integer;
    F : File;
    TextF : TextFile;
    Buf : array [0..4095] of Char;
    Msg : TJpMessage;
begin
    //ItemIndex := -1;
    Index := 0;

    if Settings.DenyNoLocalHost then
    begin
        //[JzXgłȂ
        if GetPeerAddress <> '127.0.0.1' then
        begin
            SendCommand('-ERR Access denied.');
            Close;
            Exit;
        end;
    end;

    //ڑ̃bZ[W\
    //SendCommand('+OK Jupiter 5.0 Server.');
    SendCommand('+OK Jupiter ' + GetShortVersion + ' POP3 server ready.');

    //[UID̎󂯕t
    while True do
    begin
        temp := ReadLine;

        if Pos(#10, temp) = 0 then
        begin
            Close;
            Exit;
        end;

        temp := Trim(temp);
        stemp := UpperCase(temp);

        if stemp = 'QUIT' then
        begin
            //QUITR}h
            SendCommand('+OK Sign off from Jupiter Version 5.0');
            Close;
            Exit;
        end
        else if Copy(stemp, 1, 4) = 'USER' then
        begin
            //USERR}h
            User := Trim(Copy(temp, 5, Length(temp) - 4));

            if User = '' then
                SendCommand('-ERR Invalid Command')
            else
            begin
                SendCommand('+OK Password Required for ' + User);
                Break;
            end;
        end
        else
            SendCommand('-ERR Invalid Command');
    end;

    //PASSR}h̎󂯕t
    while True do
    begin
        temp := ReadLine;

        if Pos(#10, temp) = 0 then
        begin
            Close;
            Exit;
        end;

        temp := Trim(temp);
        stemp := UpperCase(temp);
        Path := '';

        if stemp = 'QUIT' then
        begin
            //QUITR}h
            SendCommand('+OK Jupiter 5.0 POP Server signing off.');
            Close;
            Exit;
        end
        else if Copy(stemp, 1, 4) = 'PASS' then
        begin
            //PASSR}h
            Pass := Trim(Copy(temp, 5, Length(temp) - 4));

            //F؂
            for n := 0 to Items.Count - 1 do
            begin
                if Items.Mails.Strings[n] = User then
                begin
                    //ΏۂƂȂAJEg
                    temp := PasswordDecode(GetSettings(Items.Paths[n]
                                                + 'item.ini', 'Pass'));
					(*
                    if temp = '' then
                    begin
                        if Settings.PassInputEternally then
                            temp := ShowPassDialog(Items.Titles.Strings[n], 0)
                        else
                            temp := ShowPassDialog(Items.Titles.Strings[n], 20);
                    end;
                    *)

                    if (temp <> '') and (temp = Pass) then
                    begin
                        //pX[hv
                        MailStatus(Items.Paths[n] + 'savebox\'
                                    , ItemCount, TotalSize);

                        SendCommand('+OK ' + User + '''s maildrop has '
                                        + IntToStr(ItemCount) + ' messages ('
                                        + IntToStr(TotalSize) + ' octets)');
                        Path := Items.Paths[n] + 'savebox\';
                        //ItemIndex := n;
                    end
                    else
                    begin
                        //pX[hsv
                        SendCommand('-ERR Invalid Password');
                        Close;
                        Exit;
                    end;

                    Break;
                end;
            end;

            if Path <> '' then Break;

            //GCAX
            for n := 0 to Items.Count - 1 do
            begin
                if Items.Aliases.Strings[n] = User then
                begin
                    //ΏۂƂȂAJEg
                    temp := PasswordDecode(GetSettings(Items.Paths[n]
                                                + 'item.ini', 'Pass'));
                    (*
                    if temp = '' then
                    begin
                        if Settings.PassInputEternally then
                            temp := ShowPassDialog(Items.Titles.Strings[n], 0)
                        else
                            temp := ShowPassDialog(Items.Titles.Strings[n], 20);
                    end;
                    *)

                    if (temp <> '') and (temp = Pass) then
                    begin
                        //pX[hv
                        MailStatus(Items.Paths[n] + 'savebox\'
                                    , ItemCount, TotalSize);

                        SendCommand('+OK ' + User + '''s maildrop has '
                                        + IntToStr(ItemCount) + ' messages ('
                                        + IntToStr(TotalSize) + ' octets)');
                        Path := Items.Paths[n] + 'savebox\';
                        //ItemIndex := n;
                    end
                    else
                    begin
                        //pX[hsv
                        SendCommand('-ERR Invalid Password');
                        Close;
                        Exit;
                    end;
                end;
            end;

            if Path <> '' then Break;

            //[UȂ
            SendCommand('-ERR "' + User + '" Invalid User');
            Close;
            Exit;
        end
        else
            SendCommand('-ERR Invalid Command');
    end;

    Mails := SearchFile(Path + '*.eml');

    //R}h󂯕t
    while True do
    begin
        temp := ReadLine;

        if Pos(#10, temp) = 0 then
        begin
            Mails.Free;
            Break;
        end;

        temp := Trim(temp);
        stemp := Copy(UpperCase(temp), 1, 4);

        if stemp = 'QUIT' then
        begin
            DeleteFiles(Mails, Path);
            Break;
        end
        else if stemp = 'NOOP' then
        begin
            SendCommand('+OK');
        end
        else if stemp = 'STAT' then
        begin
            Size := 0;
            Count := 0;

            for n := 0 to Mails.Count - 1 do
            begin
                if Mails.Strings[n] = '' then Continue;
                Size := Size + FileSize(Path + Mails.Strings[n]);
                Count := Count + 1;
            end;

            SendCommand('+OK ' + IntToStr(Count) + ' ' + IntToStr(Size));
        end
        else if stemp = 'LIST' then
        begin
            ttemp := Trim(Copy(temp, 5, Length(temp) - 4));

            if ttemp = '' then
            begin
                //ׂẴbZ[WɂĂ̏
                Size := 0;
                Count := 0;

                for n := 0 to Mails.Count - 1 do
                begin
                    if Mails.Strings[n] = '' then Continue;
                    Size := Size + FileSize(Path + Mails.Strings[n]);
                    Count := Count + 1;
                end;

                SendCommand('+OK ' + IntToStr(Count) + ' messages ('
                                + IntToStr(Size) +' octets)');

                for n := 0 to Mails.Count - 1 do
                begin
                    if Mails.Strings[n] = '' then Continue;
                    SendCommand(IntToStr(n + 1) + ' '
                                    + IntToStr(FileSize(Path
                                                    + Mails.Strings[n])));
                end;

                SendCommand('.');
            end
            else
            begin
                //bZ[Ww肳Ă
                Index := StrToInt(ttemp) - 1;

                if (Index < -1) or (Index >= Mails.Count) then
                begin
                    SendCommand('-ERR No Such Message');
                    Continue;
                end;

                //݂̊mF
                if Mails.Strings[Index] = '' then
                begin
                    SendCommand('-ERR No Such Message');
                    Continue;
                end;

                //݂܂
                SendCommand('+OK ' + IntToStr(Index + 1) + ' '
                            + IntToStr(FileSize(Path + Mails.Strings[Index])));
            end;
        end
        else if stemp = 'RETR' then
        begin
            //CfbNX̎擾
            Index := StrToInt(Trim(Copy(temp, 5, Length(temp) - 4))) - 1;

            if (Index < -1) or (Index >= Mails.Count) then
            begin
                SendCommand('-ERR No Such Message');
                Continue;
            end;

            //݂̊mF
            if Mails.Strings[Index] = '' then
            begin
                SendCommand('-ERR No Such Message');
                Continue;
            end;

            //݂܂
            SendCommand('+OK '
                    + IntToStr(FileSize(Path + Mails.Strings[Index]))
                    + ' octets');

            try
                //t@CJ
                AssignFile(F, Path + Mails.Strings[Index]);
                Reset(F, 1);
                Seek(F, 0);
                Size := SizeOf(Buf);

                while Size <> 0 do
                begin
                    BlockRead(F, Buf, SizeOf(Buf), Size);
                    Write(@Buf, Size);
                end;
            finally
                CloseFile(F);
            end;

            SendCommand('');
            SendCommand('.');
        end
        else if stemp = 'DELE' then
        begin
            //CfbNX̎擾
            Index := StrToInt(Trim(Copy(temp, 5, Length(temp) - 4))) - 1;

            if (Index < -1) or (Index >= Mails.Count) then
            begin
                SendCommand('-ERR No Such Message');
                Continue;
            end;

            //݂̊mF
            if Mails.Strings[Index] = '' then
            begin
                SendCommand('-ERR No Such Message');
                Continue;
            end;

            //ۂɂQUIT̂Ƃɍ폜
            Mails.Strings[Index] := '';
            SendCommand('+OK message ' + IntToStr(Index + 1) + ' deleted');
        end
        else if stemp = 'TOP ' then
        begin
            //擪̕Ԃ܂
            ttemp := Trim(Copy(temp, 5, Length(temp) - 4));

            if ttemp = '' then
            begin
                SendCommand('-ERR Invalid Command');
                Continue;
            end;

            ps := Pos(' ', ttemp);

            if ps = 0 then
            begin
                SendCommand('-ERR Invalid Command');
                Continue;
            end;

            //CfbNXƍs擾
            Index := StrToInt(Trim(Copy(ttemp, 1, ps - 1))) - 1;
            Count := StrToInt(Trim(Copy(ttemp, ps + 1, Length(ttemp) - ps)));

            if (Index < 0) or (Index >= Mails.Count) then
            begin
                SendCommand('-ERR No Such Message');
                Continue;
            end;

            //݂̊mF
            if Mails.Strings[Index] = '' then
            begin
                SendCommand('-ERR No Such Message');
                Continue;
            end;

            //wb_+ws𑗐M
            SendCommand('+OK');

            try
                //t@CJ
                AssignFile(TextF, Path + Mails.Strings[Index]);
                Reset(TextF);

                while not Eof(TextF) do
                begin
                    ReadLn(TextF, ttemp);
                    SendCommand(ttemp);
                    if ttemp = '' then Break;
                end;

                for n := 1 to Count do
                begin
                    if Eof(TextF) then Break;
                    ReadLn(TextF, ttemp);
                    SendCommand(ttemp);
                end;
            finally
                CloseFile(TextF);
            end;

            SendCommand('.');
        end
        else if stemp = 'RSET' then
        begin
            DeleteFiles(Mails, Path);
            Mails.Free;
            Mails := SearchFile(Path + '*.eml');
            SendCommand('+OK');
        end
        else if stemp = 'UIDL' then
        begin
            //UIDLR}h
            ttemp := Trim(Copy(temp, 5, Length(temp) - 4));
            Index := StrToInt(ttemp) - 1;

            if ttemp = '' then
            begin
                SendCommand('+OK');

                for n := 0 to Mails.Count - 1 do
                begin
                    SendCommand(IntToStr(n + 1) + ' '
                                + Copy(Mails.Strings[n], 1
                                        , Length(Mails.Strings[n]) - 3)
                                + GetCrc(User));
                end;

                SendCommand('.');
            end
            else
            begin
                if (Index < -1) or (Index >= Mails.Count)
                    or (Mails.Strings[Index] = '') then
                begin
                    SendCommand('-ERR No Such Message');
                    Continue;
                end;

                SendCommand('+OK ' + IntToStr(Index + 1) + ' '
                                + Copy(Mails.Strings[Index], 1
                                        , Length(Mails.Strings[Index]) - 3)
                                + GetCrc(User));
            end;
        end
        else
        begin
            //ȃR}h
            SendCommand('-ERR Invalid Command');
        end;
    end;

    //\Pbg
    SendCommand('+OK Jupiter 5.0 POP Server signing off.');
    Sleep(100);
    Close;

    //CEBhEɊJnʒm
    //if (Settings.ExecImmediately) and (ItemIndex <> -1) then
    //    SendMessage(TrayHandle, WM_JPSTART, ItemIndex, 0);

    //\̍XV
    Msg.Handle := 0;
    Msg.Index := Index;
    Msg.MessageStr := nil;
    Msg.Types := mtUpdate;
    SendMessage(JobHandle, WM_JPMSG, Integer(@Msg), 0);

    //j[̍XV
    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
end;

procedure TPopThread.DeleteFiles(var NewLists : TNStringList ; Path : String);
var
    n : Integer;
    Files : TNStringList;
begin
    Files := SearchFile(Path + '*.eml');

    for n := 0 to Files.Count - 1 do
    begin
        if NewLists.IndexOf(Files.Strings[n]) = -1 then
            DeleteFile(PChar(Path + Files.Strings[n]));
    end;

    Files.Free;
end;

//*****************************************************************************
// TSmtpThread

procedure TSmtpThread.Execute;
var
    temp : String;
    stemp : String;
    ttemp : String;
    Path : String;
    Address : String;
    SendTo : String;
    FileName : String;
    Index : Integer;
    ps : Integer;
    Count : Integer;
    TextF : TextFile;
    n : Integer;
    Msg : TJpMessage;
begin
    //
    Address := '';
    Path := '';
    SendTo := '';
    Count := 0;
    Index := 0;

    if Settings.DenyNoLocalHost then
    begin
        //[JzXgłȂ
        if GetPeerAddress <> '127.0.0.1' then
        begin
            Close;
            Exit;
        end;
    end;

    //ڑ̃bZ[W\
    SendCommand('220 Jupiter 5 SMTP Server is ready.');

    //HELO̎󂯕t
    while True do
    begin
        temp := ReadLine;

        if Pos(#10, temp) = 0 then
        begin
            Close;
            Exit;
        end;

        temp := Trim(temp);
        stemp := UpperCase(temp);

        if stemp = 'QUIT' then
        begin
            //QUITR}h
            SendCommand('221 Connection closed.');
            Close;
            Exit;
        end
        else if Copy(stemp, 1, 4) = 'HELO' then
        begin
            //HELOR}h
            ttemp := Trim(Copy(temp, 5, Length(temp) - 4));
            SendCommand('250 Hello ' + GetPeerHost
                            + ' [' + GetPeerAddress
                            + '], Pleased to meet you.');
            Break;
        end
        else
            SendCommand('500 You must say helo first.');
    end;

    //R}h󂯕t
    while True do
    begin
        temp := ReadLine;

        if Pos(#10, temp) = 0 then
            Break;

        temp := Trim(temp);
        stemp := Copy(UpperCase(temp), 1, 4);

        if stemp = 'QUIT' then
        begin
            Break;
        end
        else if (stemp = 'MAIL') and (UpperCase(Copy(temp, 5, 6)) = ' FROM:') then
        begin
            ttemp := Trim(Copy(temp, 11, Length(temp) - 10));
            ps := Pos('<', ttemp);

            if ps = 0 then
            begin
                SendCommand('500 Command unrecognized.');
                Continue;
            end;

            ttemp := Trim(Copy(ttemp, ps + 1, Length(ttemp) - ps));
            ps := Pos('>', ttemp);

            if ps = 0 then
            begin
                SendCommand('500 Command unrecognized.');
                Continue;
            end;

            ttemp := Trim(Copy(ttemp, 1, ps - 1));

            //pXݒ
            Index := Items.Mails.IndexOf(ttemp);

            if Index = -1 then
            begin
                SendCommand('550 ' + ttemp + '''s Mailbox unavailable');
                Address := '';
                Path := '';
                Continue;
            end;

            Address := ttemp;
            Path := Items.Paths[Index];
            SendCommand('250 Sender "' + Address +'" OK');
        end
        else if (stemp = 'RCPT') and (UpperCase(Copy(temp, 5, 4)) = ' TO:') then
        begin
            ttemp := Trim(Copy(temp, 9, Length(temp) - 8));
            ps := Pos('<', ttemp);

            if ps = 0 then
            begin
                SendCommand('500 Command unrecognized.');
                Continue;
            end;

            ttemp := Trim(Copy(ttemp, ps + 1, Length(ttemp) - ps));
            ps := Pos('>', ttemp);

            if ps = 0 then
            begin
                SendCommand('500 Command unrecognized.');
                Continue;
            end;

            ttemp := Trim(Copy(ttemp, 1, ps - 1));

            if SendTo = '' then
                SendTo := ttemp
            else
                SendTo := SendTo + ';' + ttemp;

            SendCommand('250 Recipient "' + SendTo +'" OK');
        end
        else if (stemp = 'DATA') then
        begin
            if Address = '' then
            begin
                SendCommand('500 Needs "MAIL FROM" before "DATA".');
                Continue;
            end;

            if SendTo = '' then
            begin
                SendCommand('500 Needs "RCPT TO" before "DATA".');
                Continue;
            end;

            SendCommand('354 Start mail input; end with <CRLF>.<CRLF>');

            //t@C
            while True do
            begin
                FileName := Path + 'loadbox\'
                            + GetCrc(Address + SendTo + IntToStr(Count)
                            + EncodeGMTString(NowDateTime, 0))
                            + '.eml';
                if not FileExists(FileName) then Break;
            end;

            //t@Cɕۑ
            try
                AssignFile(TextF, FileName);
                ReWrite(TextF);
                System.Write(TextF, 'X-Deliver-To: ' + SendTo + #13#10);
                System.Write(TextF, 'X-Deliver-From: ' + Address + #13#10);
                System.Write(TextF, 'X-Deliver-Server: Jupiter/5.0(Windows; http://hp.vector.co.jp/authors/VA015579/)' + #13#10);

                while True do
                begin
                    temp := ReadLine;
                    if Pos(#13, temp) = 0 then Break;
                    if Trim(temp) = '.' then Break;
                    System.Write(TextF, temp);
                end;
            finally
                CloseFile(TextF);
            end;

            //ĐZbg
            SendTo := '';

            //𑗐M
            SendCommand('250 OK');
        end
        else if stemp = 'MBOX' then
        begin
            for n := 0 to Items.Count - 1 do
            begin
                SendCommand(Items.Mails.Strings[n]);
            end;
        end
        else if stemp = 'RSET' then
        begin
            SendTo := '';
            Address := '';
            SendCommand('250 OK');
        end
        else
        begin
            //ȃR}h
            SendCommand('500 Command unrecognized.');
        end;
    end;

    //\Pbg
    SendCommand('221 Connection closed.');
    Sleep(100);
    Close;

    //CEBhEɊJnʒm
    if Settings.ExecImmediately then
    begin
        if TScriptStatus(Items.Statuses.GetValue(Index)) = ITEM_IDLE then
            SendMessage(TrayHandle, WM_JPSTART, Index, 0);
    end;

    //\̍XV
    Msg.Handle := 0;
    Msg.Index := Index;
    Msg.MessageStr := nil;
    Msg.Types := mtUpdate;
    SendMessage(JobHandle, WM_JPMSG, Integer(@Msg), 0);

    //j[̍XV
    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
end;

//******************************************************************************
// TPopServer

procedure TPopServer.ThreadStart(NewSocket : TSocket);
begin
    TPopThread.Create(NewSocket);
end;

//******************************************************************************
// TSmtpServer

procedure TSmtpServer.ThreadStart(NewSocket : TSocket);
begin
    TSmtpThread.Create(NewSocket);
end;

//******************************************************************************
// TServer

constructor TServer.Create;
begin
    //POPT[ȍ
    if (Settings.UsePop) and (Settings.Pop_Port <> 0 ) then
        Pop := TPopServer.Create(Settings.Pop_Port)
    else
        Pop := nil;

    //SMTPT[ȍ
    if (Settings.UseSmtp) and (Settings.Smtp_Port <> 0 ) then
        Smtp := TSmtpServer.Create(Settings.Smtp_Port)
    else
        Smtp := nil;
end;

destructor TServer.Destroy;
begin
    if Pop <> nil then
    begin
        Pop.Terminate;
        Pop.Free;
    end;

    if Smtp <> nil then
    begin
        Smtp.Terminate;
        Smtp.Free;
    end;

    inherited Destroy;
end;

//******************************************************************************

procedure MailStatus(Path : String ; var ItemCount : Integer ; var TotalSize : Integer);
var
    Lists : TNStringList;
    n : Integer;
begin
    Lists := SearchFile(Path + '*.eml');
    ItemCount := Lists.Count;
    TotalSize := 0;

    for n := 0 to Lists.Count - 1 do
        TotalSize := FileSize(Path + Lists.Strings[n]);

    Lists.Free;
end;

initialization
    Server := TServer.Create;

finalization
    Server.Free;

end.
