unit jp5_sort;

interface

uses
    windows, tn_fw, tn_classes, tn_utils, jp5_kern, tn_stdctl;

type
    TSortDlg       =   class(WModalDialog)
        private
            Canceled : Boolean;
            ScriptList : THandle;
            TempList : TNIntList;
        public
            constructor Create(Parent : WHandle ; ResID : String); override;
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
    end;

//procedures
    function ShowSortDlg : Boolean;

implementation

constructor TSortDlg.Create(Parent : WHandle ; ResID : String);
begin
    inherited;
    Canceled := False;
end;

procedure TSortDlg.OnShow(Sender : WObject ; var Return : LRESULT);
var
    n : Integer;
    Value : Integer;
begin
    ScriptList := GetHandle(1001);
    TempList := TNIntList.Create;

    for n := 0 to Items.Count - 1 do
    begin
        Value := Items.UnConvertIndex(n);
        List_Add(ScriptList, Items.Titles.Strings[Value]);
        TempList.Add(Value);
    end;
end;

procedure TSortDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
begin
    TempList.Free;
end;

procedure TSortDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
var
    Index : Integer;
    Value1 : Integer;
    Value2 : Integer;
begin
    Index := List_GetIndex(ScriptList);

    case LOWORD(wParam) of
        IDOK:
            begin
                Items.SwapSortList(TempList);
                inherited;
            end;

        IDCANCEL:
            begin
                Canceled := True;
                inherited;
            end;

        1002:
            begin
                //
                if List_MoveUp(ScriptList) then
                begin
                    Value1 := TempList.GetValue(Index - 1);
                    Value2 := TempList.GetValue(Index);
                    TempList.SetValue(Index, Value1);
                    TempList.SetValue(Index - 1, Value2);
                end;
            end;

        1003:
            begin
                //
                if List_MoveDown(ScriptList) then
                begin
                    Value1 := TempList.GetValue(Index);
                    Value2 := TempList.GetValue(Index + 1);
                    TempList.SetValue(Index + 1, Value1);
                    TempList.SetValue(Index, Value2);
                end;
            end;

        else
            inherited;
    end;
end;

//******************************************************************************

function ShowSortDlg : Boolean;
var
    Dlg : TSortDlg;
begin
    Dlg := TSortDlg.Create(JobHandle, '2017');
    Dlg.ShowModal;
    Result := not Dlg.Canceled;
    Dlg.Free;
end;

end.
