unit jp5_update;

interface

uses
    windows, messages, jp5_kern, tn_fw, tn_classes, tn_stdctl, tn_utils
    , tn_http;

type
    TUpdateState    =   (usUpdated, usNotNes, usSkiped, usErr);

    TUpdateInfo     =   record
        Title : String;
        DocumentURL : String;
        FileName : String;
        NewVersion : Integer;
        ReadMe : String;
        How : TUpdateState;
        Url : String;
        Version : Integer;
    end;

    TUpdateThread   =   class;

    TUpdateDlg      =   class(WModalDialog)
        private
            AutoUpdate : Boolean;
            Thread : TUpdateThread;
            procedure SetChecking(Data : String);
        public
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnTimer(var Message: TMessage); message WM_TIMER;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
    end;

    TUpdateInfoDlg  =   class(WModalDialog)
        private
            Data : TUpdateThread;
        public
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
    end;

    TUpdateThread   =   class(TNThread)
        private
            Infos : array of TUpdateInfo;
            Dlg : TUpdateDlg;
        public
            constructor Create(CreateSuspended: Boolean);
            procedure Execute; override;
   end;

//procedures
    procedure DoUpdateCheck(AutoUpdate : Boolean);

implementation


//******************************************************************************
// TUpdateDlg

procedure TUpdateDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
var
    Dlg : TUpdateInfoDlg;
begin
    if wParam = 8181 then
    begin
        if not AutoUpdate then
        begin
            Dlg := TUpdateInfoDlg.Create(Handle, '2016');
            Dlg.Data := Thread;
            Dlg.ShowModal;
            Dlg.Free;
        end;
        
        Thread.Free;
        Close;
    end;
end;

procedure TUpdateDlg.OnShow(Sender : WObject ; var Return : LRESULT);
begin
    SetActiveWindow(Handle);
    SetTimer(Handle, 0, 1000, nil);
end;

procedure TUpdateDlg.SetChecking(Data : String);
begin
    Ctl_SetText(GetHandle(1001), Data);
end;

procedure TUpdateDlg.OnTimer(var Message: TMessage);
begin
    KillTimer(Handle, 0);

    if AutoUpdate or (MessageBox(Handle, PChar(LoadResourceString(4201))
                        , TITLE, MB_YESNO or MB_ICONINFORMATION) = IDYES) then
    begin
        Thread := TUpdateThread.Create(True);
        Thread.FreeOnTerminate := False;
        Thread.Dlg := Self;
        Thread.FreeOnTerminate := False;
        Thread.Execute;
    end
    else
    begin
        //SendMessage(TrayHandle, WM_COMMAND, JP_HIDEUPDATE, 0);
        Close;
    end;
end;

procedure TUpdateDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
begin
    //SendMessage(TrayHandle, WM_COMMAND, JP_HIDEUPDATE, 0);
end;

//******************************************************************************
// TUpdateInfoDlg

procedure TUpdateInfoDlg.OnShow(Sender : WObject ; var Return : LRESULT);
var
    han : THandle;
    n : Integer;
    List : TNStringList;
    temp : String;
begin
    han := GetHandle(1001);
    LV_AddColumn(han, PChar(LoadResourceString(4301)), 0, 150);
    LV_AddColumn(han, PChar(LoadResourceString(4302)), 1, 150);
    List := TNStringList.Create;

    for n := 0 to High(Data.Infos) do
    begin
        List.Clear;
        temp := Trim(Data.Infos[n].Title);

        if temp <> '' then
        begin
            List.Add(temp);

            case Data.Infos[n].How of
                usUpdated:
                    List.Add(LoadResourceString(4313));
                usNotNes:
                    List.Add(LoadResourceString(4311));
                usSkiped:
                    List.Add(LoadResourceString(4314));
                usErr:
                    List.Add(LoadResourceString(4312));
            end;

            LV_AddItem(han, List, 0);
        end;
    end;

    List.Free;
end;

//******************************************************************************
// TUpdateThread

constructor TUpdateThread.Create(CreateSuspended: Boolean);
begin
    SetLength(Infos, 0);

    inherited;
end;

procedure TUpdateThread.Execute;
var
    n : Integer;
    List : TNStringList;
    FileName : String;
    CheckURL : String;
    Data : String;
    Path : String;
    temp : String;

    function IsScriptUsed(const Name : String) : Boolean;
    begin
        Result := Items.Scripts.IndexOf(Name) <> -1;
    end;

begin
    //URLɃANZXo[W`FbN܂
    Path := ExtractFilePath(ParamStr(0)) + 'scripts\';
    List := SearchFile( Path + '*.js');
    SetLength(Infos, List.Count);

    for n := 0 to List.Count - 1 do
    begin
        //XNvg̃t@C
        FileName := Path + List.Strings[n];
        Infos[n].FileName := FileName;
        Infos[n].How := usErr;

        //XNvgo
        temp := GetSettings(FileName, '//ScriptTitle');
        Infos[n].Title := temp;

        if temp = '' then
        begin
            Continue;
        end
        else if not IsScriptUsed(temp) then
        begin
            Infos[n].How := usSkiped;
            Continue;
        end
        else
            Dlg.SetChecking(temp);

        //`FbNURLo
        CheckURL := GetSettings(FileName, '//UpdateURL');

        if CheckURL = '' then
        begin
            Infos[n].How := usErr;
            Continue;
        end;

        //o[Wo
        Infos[n].Version := StrToInt(GetSettings(FileName, '//ScriptVersion'));

        //XV_E[h
        FileName := TempPath + 'update.inf';
        Data := URLDownload(CheckURL, Settings.Proxy_Addr, Settings.Proxy_Port);
        SaveToFile(FileName, Data);

        if Data = '' then
        begin
            Infos[n].How := usErr;
            Continue;
        end;

        //eo
        temp := GetSettings(FileName, 'Version');
        Infos[n].NewVersion := StrToInt(temp);
        temp := GetSettings(FileName, 'URL');
        Infos[n].Url := temp;
        Infos[n].How := usNotNes;

        //o[W`FbN
        if Infos[n].NewVersion > Infos[n].Version then
        begin
            Data := URLDownload(Infos[n].Url, Settings.Proxy_Addr
                                            , Settings.Proxy_Port);

            if Data <> '' then
            begin
                SaveToFile(Infos[n].FileName, Data);
                Infos[n].How := usUpdated;
            end;
        end;
    end;

    List.Free;
    SendMessage(Dlg.Handle, WM_COMMAND, 8181, 0);
end;

//******************************************************************************

procedure DoUpdateCheck(AutoUpdate : Boolean);
var
    Dlg : TUpdateDlg;
begin
    Dlg := TUpdateDlg.Create(TrayHandle, '2008');
    Dlg.AutoClose := False;
    Dlg.AutoUpdate := AutoUpdate;
    Dlg.ShowModal;
    Dlg.Free;
end;

end.
