unit tn_imglist;

interface

uses
    windows, commctrl;

type
    TNImgList   =   class
        public
            Handle : HIMAGELIST;
            MaskColor : COLORREF;
            Width : Integer;
            Height : Integer;
            constructor Create(x : Integer ; y : Integer);
            destructor Destroy; override;
            procedure LoadBitmap(BitmapName : String);
    end;

implementation

constructor TNImgList.Create(x : Integer ; y : Integer);
begin
    Handle := ImageList_Create(x, y, ILC_COLOR8, 0, 0);
    Width := x;
    Height := y;
end;

destructor TNImgList.Destroy;
begin
    ImageList_Destroy(Handle);
end;

procedure TNImgList.LoadBitmap(BitmapName : String);
begin
    ImageList_LoadBitmap(hInstance, PChar(BitmapName), Size, Width, MaskColor);
end;

end.
