unit trayicon;

interface

uses
    windows, messages, shellapi, tnak_win, tn_utils;

type
    TTrayButton =   (mbtRight, mbtLeft, mbtCenter);

    TTrayIcon   =   class
        private
            nid : TNOTIFYICONDATA;
            procedure WndProc(var Msg: TMessage);
        public
            Handle : THandle;
            Quit : Boolean;
            LeftMenu : HMENU;
            RightMenu : HMENU;
            Enabled : Boolean;
            MainIcon : HICON;
            Title : String;
            constructor Create(Icon : HICON ; TrayTitle : String);
            destructor Destroy; override;
            procedure OnMouseDown(Button : TTrayButton); virtual;
            procedure OnMouseUp(Button : TTrayButton); virtual;
            procedure OnDoubleClick(Button : TTrayButton); virtual;
            procedure OnCommand(WParam : Integer ; LParam : Integer); virtual;
            procedure OnHotKey(WParam : Integer ; LParam : Integer); virtual;
            procedure OnTimer(WParam : Integer ; LParam : Integer); virtual;
            function OnMessage(Msg : Cardinal ; WParam : Integer ; LParam : Integer) : Integer; virtual;
            procedure PopupMenuLeft;
            procedure PopupMenuRight;
            procedure QuitTray;
            procedure SetIcon(Icon : HICON);
            procedure SetCaption(Data : String);
    end;

const
    WM_TRAY         =   WM_USER + 919;
    WM_TRAYENABLED  =   WM_USER + 920;

implementation

constructor TTrayIcon.Create(Icon : HICON ; TrayTitle : String);
begin
    inherited Create;
    Quit := False;
    Enabled := True;
    Title := TrayTitle;
    MainIcon := Icon;

    Handle := AllocWindow(WndProc, 'TNGSJP5');
    //ShowWindow(Handle,SW_HIDE);
    //ShowWindow(Handle,SW_MINIMIZE);
    //ShowWindow(Handle,SW_HIDE);

    nid.cbSize := sizeof(TNOTIFYICONDATA);
    nid.uID := 1;
    nid.Wnd := Handle;
    nid.uFlags := Nif_Message or Nif_Icon or Nif_Tip;
    nid.uCallbackMessage := WM_TRAY;
    nid.hIcon := Icon;
    lstrcpy(nid.szTip, PChar(Title));
    Shell_NotifyIcon(NIM_ADD, @nid);
end;

destructor TTrayIcon.Destroy;
begin
    Shell_NotifyIcon(NIM_DELETE, @nid);
    DeallocateWindow(Handle);
    inherited Destroy;
end;

procedure TTrayIcon.WndProc(var Msg: TMessage);
begin
    case Msg.Msg of
        WM_TRAY:
            begin
                if not Enabled then Exit;

                case Msg.lParam of
                    WM_LBUTTONUP:
                        OnMouseUp(mbtLeft);

                    WM_RBUTTONUP:
                        OnMouseUp(mbtRight);

                    WM_LBUTTONDOWN:
                        OnMouseDown(mbtLeft);

                    WM_RBUTTONDOWN:
                        OnMouseDown(mbtRight);

                    //WM_LBUTTONDBLCLK:
                        //OnDoubleClick(mbtLeft);
                end;
            end;

        WM_TRAYENABLED:
            begin
                if BOOL(Msg.WParam)  then
                    Enabled := True
                else
                    Enabled := False;
            end;

        WM_COMMAND:
            OnCommand(msg.WParam, msg.LParam);

        WM_QUIT:
            PostQuitMessage(0);

        WM_HOTKEY:
            OnHotKey(msg.WParam, msg.LParam);

        WM_TIMER:
            OnTimer(msg.WParam, msg.LParam);

        else
            Msg.Result := OnMessage(Msg.Msg, Msg.WParam, Msg.LParam);
    end;
end;

procedure TTrayIcon.PopupMenuLeft;
var
    tp : TPoint;
begin
    SetForegroundWindow(Handle);
    GetCursorPos(tp);
    TrackPopupMenu(LeftMenu,TPM_LEFTALIGN or TPM_RIGHTBUTTON,tp.x,tp.y,0,Handle,nil);
end;

procedure TTrayIcon.PopupMenuRight;
var
    tp : TPoint;
begin
    SetForegroundWindow(Handle);
    GetCursorPos(tp);
    TrackPopupMenu(RightMenu,TPM_LEFTALIGN or TPM_RIGHTBUTTON,tp.x,tp.y,0,Handle,nil);
end;

procedure TTrayIcon.OnMouseDown(Button : TTrayButton);
begin

end;

procedure TTrayIcon.OnMouseUp(Button : TTrayButton);
begin

end;

procedure TTrayIcon.OnDoubleClick(Button : TTrayButton);
begin

end;

procedure TTrayIcon.OnCommand(WParam : Integer ; LParam : Integer);
begin

end;

procedure TTrayIcon.OnHotKey(WParam : Integer ; LParam : Integer);
begin

end;

procedure TTrayIcon.OnTimer(WParam : Integer ; LParam : Integer);
begin

end;

function TTrayIcon.OnMessage(Msg : Cardinal ; WParam : Integer ; LParam : Integer) : Integer;
begin
    Result := DefWindowProc(Handle, Msg, WParam, LParam);
end;

procedure TTrayIcon.QuitTray;
begin
    //SendMessage(Handle, WM_QUIT, 0, 0);
    PostQuitMessage(0);
end;

procedure TTrayIcon.SetIcon(Icon : HICON);
begin
    if Icon = 0 then
    begin
        if nid.hIcon = MainIcon then Exit;
        nid.hIcon := MainIcon;
    end
    else
    begin
        if nid.hIcon = Icon then Exit;
        nid.hIcon := Icon;
    end;

    Shell_NotifyIcon(NIM_MODIFY, @nid);
end;

procedure TTrayIcon.SetCaption(Data : String);
begin
    if Title = Data then Exit;

    Title := Data;
    lstrcpy(nid.szTip, PChar(Title));
    Shell_NotifyIcon(NIM_MODIFY, @nid);
end;

end.
