unit tn_bregexp;

{
    BREGEXP.DLL gp邽߂̃bpIuWFNg bt T.Nak
}

interface

uses
    windows, tn_utils;

type
    PPChar          =   ^PChar;
    TRegMode        =   (rmNone, rmExec, rmSplit);

    TBRegExpRec     =   packed record
        outp : PChar;        // uʐ擪|C^
        outendp : PChar;     // uʖ|C^
        splitctr : Integer;  // split ʃJE^
        splitp : PPChar;     // split ʃ|C^|C^
        rsv1 : Integer;      // \ς
        parap : PChar;       // R}h擪|C^ ('s/xxxxx/yy/gi')
        paraendp : PChar;    // R}h񖖔|C^
        transtblp : PChar;   // tr e[uւ̃|C^
        startp : PPChar;     // }b`ւ̐擪|C^
        endp : PPChar;       // }b`ւ̖|C^
        nparens : Integer;   // match/subst ̊ʂ̐
    end;

    pTBRegExpRec    =   ^TBRegExpRec;

    TRegExp         =   class
        private
            Mode : TRegMode;
            LastExp : String;
            LastOpt : String;
            LastMatch : String;
            function GetCount: Integer;
            function GetStrings(Index : Integer) : String;
            function GetMatchCount : Integer;
            function GetSplitCount : Integer;
            function GetMatchStrings(Index : Integer) : String;
            function GetSplitStrings(Index : Integer) : String;
            function GetMatchPos(Index : Integer) : Integer;
            function GetMatchLen(Index : Integer) : Integer;
            function GetSubExprMatchCount : Integer;
        public
            Expression : String;
            Option : String;
            InputString : String;
            RegInfo : pTBRegExpRec;
            constructor Create(Exp : String ; Opt : String);
            destructor Destroy; override;
            function Exec(const Data: string) : Boolean;
            function ExecNext : Boolean;
            function Split(const Data : String ; Limit : Integer) : Boolean;
            property Count : Integer read GetCount;
            property Match[Index : Integer] : String read GetStrings;
            property MatchPos[Index : Integer] : Integer read GetMatchPos;
            property MatchLen[Index : Integer] : Integer read GetMatchLen;
            property SubExprMatchCount : Integer read GetSubExprMatchCount;
            function Replace(const Data : String ; ReplaceStr : String) : String;
            procedure FreeRegExp;
    end;

const
    REGEXP  =   'bregexp.dll';
    BREGEXP_ERROR_MAX= 80;  // G[bZ[W̍ő咷

//procedures
    function BMatch(str, target, targetendp: PChar; var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl; external REGEXP;
    function BSubst(str, target, targetendp: PChar; var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl; external REGEXP;
    function BTrans(str, target, targetendp: PChar; var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl; external REGEXP;
    function BSplit(str, target, targetendp: PChar; limit: Integer; var rxp: pTBRegExpRec; msg: PChar): Boolean; cdecl; external REGEXP;
    procedure BRegFree(rx: pTBRegExpRec); cdecl; external REGEXP name 'BRegfree';
    function BRegExpVersion: PChar; cdecl; external REGEXP name 'BRegexpVersion';

    function ConvSafeExpression(const Source : String) : String;

implementation

//******************************************************************************
// TRegExp

constructor TRegExp.Create(Exp : String ; Opt : String);
begin
    Mode := rmNone;
    Expression := Exp;
    Option := Opt;
    InputString := '';
    LastExp := '';
    LastOpt := '';
    RegInfo := nil;
end;

destructor TRegExp.Destroy;
begin
    if RegInfo <> nil then
        BRegFree(RegInfo);

    inherited Destroy;
end;

function TRegExp.Exec(const Data: string) : Boolean;
var
    ErrBuf : array [0..79] of Char;
    ExecPos : PChar;
    EndPos : PChar;
begin
    Result := False;

    if Data = '' then Exit;
    if Expression = '' then Exit;

    if (LastExp <> Expression) and (RegInfo <> nil) then
    begin
        //gpς݂̃|C^
        BRegFree(RegInfo);
        RegInfo := nil;
    end;

    Mode := rmExec;
    InputString := Data;
    LastExp := Expression;
    LastMatch := 'm/' + ConvSafeExpression(Expression) + '/' + Option;
    FillChar(ErrBuf, SizeOf(ErrBuf), #0);

    ExecPos := PChar(InputString);
    EndPos := ExecPos + Length(InputString);

    Result := BMatch(PChar(LastMatch)
                        , ExecPos
                        , EndPos
                        , RegInfo
                        , ErrBuf);

    if ErrBuf <> '' then
        Result := False;
end;

function TRegExp.ExecNext : Boolean;
var
    ExecPos : PChar;
    EndPos : PChar;
    ErrBuf : array [0..79] of Char;
begin
    Result := False;

    if RegInfo = nil then Exit;
    if InputString = '' then Exit;
    if Expression = '' then Exit;

    ExecPos := PChar(RegInfo^.endp^) + 1;
    EndPos := PChar(InputString) + Length(InputString);
    FillChar(ErrBuf, SizeOf(ErrBuf), #0);

    if ExecPos >= EndPos then Exit;

    Result := BMatch(PChar(LastMatch)
                        , ExecPos
                        , EndPos
                        , RegInfo, ErrBuf);

    if ErrBuf <> '' then
        Result := False;
end;

function TRegExp.Split(const Data : String ; Limit : Integer) : Boolean;
var
    ErrBuf : array [0..79] of Char;
begin
    Result := False;
    Mode := rmNone;

    if Data = '' then Exit;
    if Expression = '' then Exit;

    if (LastExp <> Expression) and (RegInfo <> nil) then
    begin
        //gpς݂̃|C^
        BRegFree(RegInfo);
        RegInfo := nil;
    end;

    Mode := rmExec;
    InputString := Data;
    LastExp := Expression;
    LastMatch := 'm/' + ConvSafeExpression(Expression) + '/';
    FillChar(ErrBuf, SizeOf(ErrBuf), #0);

    Result := BSplit(PChar(LastMatch)
                        , PChar(InputString)
                        , PChar(InputString) + Length(InputString)
                        , Limit
                        , RegInfo
                        , ErrBuf);

    if ErrBuf <> '' then
        Result := False;

    Mode := rmSplit;
end;

function TRegExp.Replace(const Data : String ; ReplaceStr : String) : String;
var
    ErrBuf : array [0..79] of Char;
    Matched : Boolean;
    Size : Integer;
    ep , sp : PPChar;
    rp : PChar;
begin
    Result := '';
    Mode := rmNone;

    if Data = '' then Exit;
    if Expression = '' then Exit;

    if (LastExp <> Expression) and (RegInfo <> nil) then
    begin
        //gpς݂̃|C^
        BRegFree(RegInfo);
        RegInfo := nil;
    end;

    Mode := rmExec;
    InputString := Data;
    LastExp := Expression;
    LastMatch := 's/' + ConvSafeExpression(Expression) + '/'
                    + ConvSafeExpression(ReplaceStr) + '/g';

    FillChar(ErrBuf, SizeOf(ErrBuf), #0);

    Matched := BSubst(PChar(LastMatch)
                        , PChar(InputString)
                        , PChar(InputString) + Length(InputString)
                        , RegInfo
                        , ErrBuf);

    if (ErrBuf <> '') or (not Matched) then
        Result := Data;

    sp := RegInfo^.startp;
    ep := RegInfo^.endp;
    Size := ep^ - sp^;
    SetLength(Result, Size);
    rp := PChar(Result);
    Move(sp^, rp, Size);
    Mode := rmExec;
end;

function TRegExp.GetStrings(Index : Integer) : String;
begin
    Result := '';

    if Mode = rmExec then
        Result := GetMatchStrings(Index)
    else if Mode = rmSplit then
        Result := GetSplitStrings(Index);
end;

function TRegExp.GetCount: Integer;
begin
    Result := 0;

    if Mode = rmExec then
        Result := GetMatchCount
    else if Mode = rmSplit then
        Result := GetSplitCount;
end;

function TRegExp.GetMatchCount : Integer;
begin
    Result := 0;
    if RegInfo = nil then Exit;
    Result := RegInfo^.nparens + 1;
end;

function TRegExp.GetSplitCount : Integer;
begin
    Result := 0;
    if RegInfo = nil then Exit;
    Result := RegInfo^.splitctr;
end;

function TRegExp.GetMatchStrings(Index : Integer) : String;
var
    sp , ep : PPChar;
begin
    Result:='';

    if RegInfo = nil then Exit;
    if (Index < 0) or (Index >= GetMatchCount) then Exit;

    sp := RegInfo^.startp;
    Inc(sp, Index);
    ep := RegInfo^.endp;
    Inc(ep, Index);
    SetLength(Result, Integer(ep^) - Integer(sp^));
    Move(sp^^, PChar(Result)^, Integer(ep^) - Integer(sp^));
end;

function TRegExp.GetSplitStrings(Index : Integer) : String;
var
    p : PPChar;
    sp , ep : PChar;
begin
    Result := '';

    if RegInfo = nil then Exit;
    if (Index < 0) or (Index >= GetSplitCount) then Exit;

    p := RegInfo^.splitp;
    Inc(p, Index * 2);
    sp := p^;
    Inc(p);
    ep := p^;
    SetLength(Result, Integer(ep) - Integer(sp));
    Move(sp^, PChar(Result)^, Integer(ep) - Integer(sp));
end;

function TRegExp.GetMatchPos(Index : Integer) : Integer;
begin
    Result := - 1;

    if RegInfo = nil then Exit;
    if Mode <> rmExec then Exit;

    Result := Integer(RegInfo^.startp^) - Integer(InputString) + 1;
end;

function TRegExp.GetMatchLen(Index : Integer) : Integer;
begin
    Result := 0;

    if RegInfo = nil then Exit;
    if Mode <> rmExec then Exit;

    Result:=Integer(RegInfo^.endp^) - Integer(RegInfo^.startp^);
end;

function TRegExp.GetSubExprMatchCount : Integer;
begin
    Result := 0;

    if RegInfo = nil then Exit;
    if Mode <> rmExec then Exit;

    Result := RegInfo^.nparens;
end;

procedure TRegExp.FreeRegExp;
begin
    if RegInfo <> nil then
        BRegFree(RegInfo);
end;

//******************************************************************************
// Procedures

function ConvSafeExpression(const Source : String) : String;
var
    n : Integer;
    ch : Char;
begin
    //^SȌ`ɕϊ
    //TRegExpr͓{EE؍MBCSł͖肪
    //ϊ֐

    for n := 1 to Length(Source) do
    begin
        ch := Source[n];

        if ByteType(Source, n) = btSingle then
        begin
            if ch = '/' then
                Result := Result + '\' + ch
            else
                Result := Result + ch;
        end
        else
        begin
            case ch of
                '^', '$', '.', '*', '+', '-', '[', ']', '{', '}', '\', '/':
                    Result := Result + '\' + ch
                else
                    Result := Result + ch;
            end;
        end;
    end;
end;

end.
