unit tn_classes;

interface

uses
    windows, messages;

type
    PInteger        =   ^Integer;
    PDouble         =   ^Double;
    TNotifyEvent    =	procedure (Sender: TObject) of object;
    TTermEvent      =	procedure (Sender: TObject);
    TSortEvent		=	procedure (Sender : TObject ; IndexA , IndexB : Integer) of Object;

    TNIntList       =   class
        private
            Items : Pointer;
            procedure QuickSort(L, R: Integer);
        public
            Count : Integer;
            Reverse : Boolean;
            SortEvent : TSortEvent;
            constructor Create;
            destructor Destroy; override;
            procedure Clear;
            procedure Add(Value : Integer);
            function GetValue(Index : Integer) : Integer;
            procedure SetValue(Index : Integer ; Value : Integer);
            property Values[Index : Integer] : Integer read GetValue write SetValue;
            procedure Delete(Index : Integer);
            function IndexOf(Value : Integer) : Integer;
            function MaxValue : Integer;
            procedure Sort;
            procedure LoadFromFile(FileName : String);
            procedure SaveToFile(FileName : String);
			procedure Import(Data : Pointer ; Size : Integer);
    end;

    TNDoubleList       =   class
        private
            Items : Pointer;
            procedure QuickSort(L, R: Integer);
            procedure QuickSortR(L, R: Integer);
        public
            Count : Integer;
            SortEvent : TSortEvent;
            ReverseSort : Boolean;
            constructor Create;
            destructor Destroy; override;
            procedure Clear;
            procedure Add(Value : Double);
            function GetValue(Index : Integer) : Double;
            procedure SetValue(Index : Integer ; Value : Double);
            property Values[Index : Integer] : Double read GetValue write SetValue;
            procedure Delete(Index : Integer);
            function IndexOf(Value : Double) : Integer;
            //function MaxValue : Integer;
            procedure Sort;
    end;

    TNBinaryList    =   class
        private
            RealCount : Integer;
            ListSize : Integer;
            PList : Pointer;
            PSize : PCardinal;
        public
            constructor Create;
            destructor Destroy; override;
            procedure Clear;
            procedure Add(Data : Pointer ; Size : Cardinal);
            procedure Delete(Index : Integer);
            procedure SetData(Index : Integer ; Data : Pointer ; Size : Cardinal);
            function GetData(Index : Integer) : Pointer;
            function GetDataSize(Index : Integer) : Integer;
        published
            property Count : Integer read RealCount;
    end;

    TNRecordList    =   class
        private
            PData : Pointer;
            RealCount : Integer;
            RecordSize : Integer;
            DataSize : Integer;
        public
            constructor Create(RecSize : Integer);
            destructor Destroy; override;
            procedure Add(pBuf : Pointer);
            procedure Delete(Index : Integer);
            procedure SetData(Index : Integer ; pBuf : Pointer);
            function GetData(Index : Integer) : Pointer;
            function IndexOf(Data : Pointer) : Integer;
        published
            property Count : Integer read RealCount;
    end;

    TNStringList    =   class
        private
            //Locked : Boolean;
            ItemCount : Integer;
            Items   : Pointer;
            Lengths : Pointer;
            function GetLine(Index : Integer) : String;
            procedure SetLine(Index : Integer ; const Value : String);
            procedure QuickSort(L, R: Integer);
        protected
            function GetText : String;
            procedure SetText(const Value : String);
        public
            SortEvent : TSortEvent;
            constructor Create;
            destructor Destroy; override;
            procedure Clear;
            procedure Add(const Value : String);
            property Count : Integer read ItemCount write ItemCount;
            property Strings[Index : Integer] : String read GetLine write SetLine;
            property Text : String read GetText write SetText;
            function CatStrings : String;
            procedure Sort;
            procedure Delete(Index : Integer);
            procedure LoadFromFile(FileName : String);
            procedure SaveToFile(FileName : String);
            function IndexOf(const Value : String) : Integer;
    end;

    TNThread    =   class
        private
            NowSuspended : Boolean;
            FFreeOnTerminate : Boolean;
            procedure StartThread;
        protected
            procedure Execute; virtual; abstract;
        public
            Handle : THandle;
            ThreadID : Longword;
            ExitCode : Cardinal;
            TermEventObj : TNotifyEvent;
            TermEvent : TTermEvent;
            constructor Create(CreateSuspended: Boolean);
            destructor Destroy; override;
            procedure Resume;
            procedure Suspend;
            procedure Terminate;
            property FreeOnTerminate : Boolean read FFreeOnTerminate write FFreeOnTerminate;
    end;

    TNMemory   =   class
        private
            PData : Pointer;
            BufSize : Integer;
            RealSize: Integer;
            BlockSize : Integer;
            procedure CheckMemory(Request : Integer);
        public
            constructor Create(Size : Integer);
            destructor Destroy; override;
            procedure PushChar(ch : Char);
            procedure PushWideChar(ch : WideChar);
            procedure Push(p : Pointer ; Size : Integer);
			procedure PushString(const Data : String);
            property Data : Pointer read PData;
        published
            property Size : Integer read RealSize;
    end;

    TNQue       =   class
        private
            Count : Integer;
            Ques : array of Char;
            Size : Integer;
        public
            constructor Create(Size : Integer);
            destructor Destroy; override;
            procedure Add(Data : Char);
            procedure Clear;
    end;

    TNWriteFile      =   class
        private
            Opened : Boolean;
            F : TextFile;
        public
            constructor Create(FileName : String);
            destructor Destroy; override;
            function Write(const Data : String) : Boolean;
            function Writeln(const Data : String) : Boolean;
            function Put(Data : Pointer ; Size : Integer) : Boolean;
    end;

    TNVirtualGrid   =   class
        private
            Width : Integer;
        public
            Datas : array of TNStringList;
            constructor Create(x : Integer);
            destructor Destroy; override;
            function GetData(Column : Integer ; Line : Integer) : String;
            function SearchIndex(const Data : String ; Index : Integer) : Integer;
            procedure Add(const args : array of String);
            procedure Clear;
    end;

implementation

uses
	tn_utils;

//******************************************************************************
//TNIntListNX

constructor TNIntList.Create;
begin
	SortEvent := nil;
    Count := 0;
    Reverse := False;
    GetMem(Items, Count * SizeOf(Integer));
end;

destructor TNIntList.Destroy;
begin
    Clear;
    inherited Destroy;
end;

procedure TNIntList.Clear;
begin
    if Items <> nil then
    begin
        FreeMem(Items,Count * SizeOf(Integer));
        Items := nil;
        Count := 0;
    end;
end;

procedure TNIntList.Add(Value : Integer);
begin
    ReallocMem(Items , (Count + 1) * SizeOf(Integer));
    PInteger(PChar(Items) + SizeOf(Integer) * Count)^ := Value;
    Count := Count + 1;
end;

function TNIntList.GetValue(Index : Integer) : Integer;
begin
    Result := 0;
    if (Index < 0) or (Index >= Count) then Exit;

    Result := PInteger(PChar(Items) + SizeOf(Integer) * Index)^;
end;

procedure TNIntList.SetValue(Index : Integer ; Value : Integer);
begin
    if (Index < 0) or (Index >= Count) then Exit;

    PInteger(PChar(Items) + SizeOf(Integer) * Index)^ := Value;
end;

procedure TNIntList.Delete(Index : Integer);
var
    p : PChar;
begin
    if Count = 0 then Exit;
    if (Index < 0) or (Index >= Count) then Exit;

    GetMem(p , (Count - 1) * SizeOf(Integer));
    CopyMemory(p , Items, Index * SizeOf(Integer));
    CopyMemory(p + Index * SizeOf(Integer)
                    , PChar(PChar(Items) + (Index + 1) * SizeOf(Integer))
                    , (Count - Index - 1) * SizeOf(Integer));

    FreeMem(Items, Count * SizeOf(Integer));
    Items := p;

    Count := Count - 1;
end;

function TNIntList.IndexOf(Value : Integer) : Integer;
var
    n : Integer;
begin
    Result := -1;

    if not Reverse then
    begin
        for n := 0 to Count - 1 do
        begin
            if GetValue(n) = Value then
            begin
                Result := n;
                Break;
            end;
        end;
    end
    else
    begin
        for n := Count - 1 downto 0 do
        begin
            if GetValue(n) = Value then
            begin
                Result := n;
                Break;
            end;
        end;
    end;
end;

function TNIntList.MaxValue : Integer;
var
    n : Integer;
    Value : Integer;
begin
    Result := -2147483647;

    for n := 0 to Count - 1 do
    begin
        Value := GetValue(n);

        if Value > Result then
            Result := Value;
    end;
end;

procedure TNIntList.QuickSort(L, R: Integer);
var
    I, J, Index : Integer;
    T : Integer;
    pI, pJ : PInteger;
    NowValue : Integer;
begin
    repeat
        I := L;
        J := R;
        Index := (L + R) shr 1;
        NowValue := PInteger(PChar(Items) + SizeOf(Pointer) * Index)^;

        repeat
            while GetValue(I) - NowValue < 0 do
                I := I + 1;

            while GetValue(J) - NowValue > 0 do
                J := J - 1;

            if I <= J then
            begin
                //|C^̈ړ
                pI := PInteger(PChar(Items) + SizeOf(Integer) * I);
                pJ := PInteger(PChar(Items) + SizeOf(Integer) * J);
                T := pI^;
                pI^ := pJ^;
                pJ^ := T;

                if @SortEvent <> nil then SortEvent(Self, I, J);

                I := I + 1;
                J := J - 1;
            end;
        until I > J;

        if L < J then QuickSort(L, J);
        L := I;
    until I >= R;
end;

procedure TNIntList.Sort;
begin
    if Count > 0 then
        QuickSort(0, Count - 1);
end;

procedure TNIntList.LoadFromFile(FileName : String);
var
    F : File;
    Size : Integer;
begin
    if not FileExists(FileName) then Exit;
    Size := FileSize(FileName);

    if Size mod SizeOf(Integer) = 0 then
    begin
        try
            AssignFile(F, FileName);
            try
                Reset(F, 1);
                //̃TCYZbg
                ReallocMem(Items, Size);
                BlockRead(F, Items^, Size);
            finally
                Count := Size div SizeOf(Integer);
                CloseFile(F);
            end;
        except
        end;
    end;
end;

procedure TNIntList.SaveToFile(FileName : String);
var
    F : File;
    Size : Integer;
begin
    Size := Count * SizeOf(Integer);

    try
        AssignFile(F, FileName);
        try
            ReWrite(F, 1);
            BlockWrite(F, Items^, Size);
        finally
            CloseFile(F);
        end;
    except
    end;
end;

procedure TNIntList.Import(Data : Pointer ; Size : Integer);
begin
    if Size mod SizeOf(Integer) = 0 then
    begin
    	//̃TCYZbg
        ReallocMem(Items, Size);
		Move(Data^, Items^, Size);
        Count := Size div SizeOf(Integer);
    end;
end;

//******************************************************************************
//TNDoubleListNX

constructor TNDoubleList.Create;
begin
	SortEvent := nil;
    Count := 0;
	ReverseSort := False;
    GetMem(Items, Count * SizeOf(Double));
end;

destructor TNDoubleList.Destroy;
begin
    Clear;
    inherited Destroy;
end;

procedure TNDoubleList.Clear;
begin
    if Items <> nil then
    begin
        FreeMem(Items, Count * SizeOf(Double));
        Items := nil;
        Count := 0;
    end;
end;

procedure TNDoubleList.Add(Value : Double);
begin
    ReallocMem(Items , (Count + 1) * SizeOf(Double));
    PDouble(PChar(Items) + SizeOf(Double) * Count)^ := Value;
    Count := Count + 1;
end;

function TNDoubleList.GetValue(Index : Integer) : Double;
begin
    Result := 0;
    if (Index < 0) or (Index >= Count) then Exit;

    Result := PDouble(PChar(Items) + SizeOf(Double) * Index)^;
end;

procedure TNDoubleList.SetValue(Index : Integer ; Value : Double);
begin
    if (Index < 0) or (Index >= Count) then Exit;

    PDouble(PChar(Items) + SizeOf(Double) * Index)^ := Value;
end;

procedure TNDoubleList.Delete(Index : Integer);
var
    p : PChar;
begin
    if Count = 0 then Exit;
    if (Index < 0) or (Index >= Count) then Exit;

    GetMem(p , (Count - 1) * SizeOf(Double));
    CopyMemory(p , Items, Index * SizeOf(Double));
    CopyMemory(p + Index * SizeOf(Double)
                    , PChar(PChar(Items) + (Index + 1) * SizeOf(Double))
                    , (Count - Index - 1) * SizeOf(Double));

    FreeMem(Items, Count * SizeOf(Double));
    Items := p;

    Count := Count - 1;
end;

function TNDoubleList.IndexOf(Value : Double) : Integer;
var
    n : Integer;
begin
    Result := -1;

    for n := 0 to Count - 1 do
    begin
        if GetValue(n) = Value then
        begin
            Result := n;
            Break;
        end;
    end;
end;

{
function TNDoubleList.MaxValue : Integer;
var
    n : Integer;
    Value : Integer;
begin
    Result := -2147483647;

    for n := 0 to Count - 1 do
    begin
        Value := GetValue(n);

        if Value > Result then
            Result := Value;
    end;
end;
}

procedure TNDoubleList.QuickSort(L, R: Integer);
var
    I, J, Index : Integer;
    T : Double;
    pI, pJ : PDouble;
    NowValue : Double;
begin
    repeat
        I := L;
        J := R;
        Index := (L + R) shr 1;
        NowValue := PDouble(PChar(Items) + SizeOf(Double) * Index)^;

        repeat
            while GetValue(I) < NowValue do
                I := I + 1;

            while GetValue(J) > NowValue do
                J := J - 1;

            if I <= J then
            begin
                //|C^̈ړ
                pI := PDouble(PChar(Items) + SizeOf(Double) * I);
                pJ := PDouble(PChar(Items) + SizeOf(Double) * J);
                T := pI^;
                pI^ := pJ^;
                pJ^ := T;

                if @SortEvent <> nil then SortEvent(Self, I, J);

                I := I + 1;
                J := J - 1;
            end;
        until I > J;

        if L < J then QuickSort(L, J);
        L := I;
    until I >= R;
end;

procedure TNDoubleList.QuickSortR(L, R: Integer);
var
    I, J, Index : Integer;
    T : Double;
    pI, pJ : PDouble;
    NowValue : Double;
begin
    repeat
        I := L;
        J := R;
        Index := (L + R) shr 1;
        NowValue := PDouble(PChar(Items) + SizeOf(Double) * Index)^;

        repeat
            while GetValue(I) > NowValue do
                I := I + 1;

            while GetValue(J) < NowValue do
                J := J - 1;

            if I <= J then
            begin
                //|C^̈ړ
                pI := PDouble(PChar(Items) + SizeOf(Double) * I);
                pJ := PDouble(PChar(Items) + SizeOf(Double) * J);
                T := pI^;
                pI^ := pJ^;
                pJ^ := T;

                if @SortEvent <> nil then SortEvent(Self, I, J);

                I := I + 1;
                J := J - 1;
            end;
        until I > J;

        if L < J then QuickSortR(L, J);
        L := I;
    until I >= R;
end;

procedure TNDoubleList.Sort;
begin
    if Count > 0 then
    begin
    	if ReverseSort then
	        QuickSortR(0, Count - 1)
        else
	        QuickSort(0, Count - 1);
    end;
end;

//******************************************************************************
//TNBinaryList

constructor TNBinaryList.Create;
begin
    PList := nil;
    PSize := nil;
    RealCount := 0;
    ListSize := 0;
end;

destructor TNBinaryList.Destroy;
begin
    Clear;
    inherited;
end;

procedure TNBinaryList.Clear;
var
    ptr : Pointer;
    n : Integer;
begin
    if PList <> nil then
    begin
        for n := 0 to RealCount - 1 do
        begin
            ptr := Pointer(Pointer(Cardinal(PList) + Cardinal(n) * SizeOf(Cardinal))^);
            if ptr <> nil then FreeMem(ptr);
        end;

        FreeMem(PList);
        FreeMem(PSize);

        PList := nil;
        PSize := nil;
    end;
end;

procedure TNBinaryList.Add(Data : Pointer ; Size : Cardinal);
const
    LIST_BLOCK_SIZE =   128;
var
    ptr : PPointer;
    psz : PCardinal;
    pmem : Pointer;
begin
    if ListSize <= RealCount * SizeOf(Cardinal) then
    begin
        Inc(ListSize, LIST_BLOCK_SIZE);

        if PList = nil then
        begin
            GetMem(PList, ListSize);
            GetMem(PSize, ListSize);
        end
        else
        begin
            ReallocMem(PList, ListSize);
            ReallocMem(PSize, ListSize);
        end;
    end;

    // f[^Rs[
    if Size <> 0 then
    begin
        GetMem(pmem, Size);
        Move(Data^, pmem^, Size);
    end
    else
        pmem := nil;

    // |C^Xgɒǉ
    ptr := PPointer(Cardinal(PList) + Cardinal(RealCount) * SizeOf(Cardinal));
    ptr^ := pmem;

    // TCYXgɒǉ
    psz := PCardinal(Cardinal(PSize) + Cardinal(RealCount) * SizeOf(Cardinal));
    psz^ := Size;

    Inc(RealCount);
end;

procedure TNBinaryList.Delete(Index : Integer);
var
    n : Integer;
    ptr, pold : PPointer;
    pnewlist : PPointer;
begin
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;
    if RealCount = 0 then Exit;

    // |C^XgXV
    GetMem(pnewlist, ListSize);
    ptr := pnewlist;
    pold := PList;

    for n := 0 to RealCount - 1 do
    begin
        if n <> Index then
        begin
            ptr^ := pold^;
            Inc(ptr);
        end
        else
            FreeMem(pold^);

        Inc(pold);
    end;

    FreeMem(PList);
    PList := pnewlist;

    // TCYXgXV
    GetMem(pnewlist, ListSize);
    ptr := pnewlist;
    pold := PPointer(PSize);

    for n := 0 to RealCount - 1 do
    begin
        if n <> Index then
        begin
            ptr^ := pold^;
            Inc(ptr);
        end;

        Inc(pold);
    end;

    FreeMem(PSize);
    PSize := PCardinal(pnewlist);

    Dec(RealCount);
end;

procedure TNBinaryList.SetData(Index : Integer ; Data : Pointer ; Size : Cardinal);
var
    ptr : PPointer;
    pmem : Pointer;
begin
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;

    // Âf[^̊J
    ptr := PPointer(Cardinal(PList) + Cardinal(Index) * SizeOf(Cardinal));
    pmem := ptr^;
    FreeMem(pmem);

    // ̃Rs[
    GetMem(pmem, Size);
    Move(Data^, pmem^, Size);

    // Xg̍XV
    ptr^ := pmem;
end;

function TNBinaryList.GetData(Index : Integer) : Pointer;
var
    ptr : PPointer;
begin
    Result := nil;
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;
    ptr := PPointer(Cardinal(PList) + Cardinal(Index) * SizeOf(Cardinal));
    Result := ptr^;
end;

function TNBinaryList.GetDataSize(Index : Integer) : Integer;
var
    ptr : PCardinal;
begin
    Result := -1;
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;
    ptr := PCardinal(Cardinal(PSize) + Cardinal(Index) * SizeOf(Cardinal));
    Result := ptr^;
end;

//******************************************************************************
// TNRecordList

constructor TNRecordList.Create(RecSize : Integer);
begin
    DataSize := 0;
    PData := nil;
    RealCount := 0;
    RecordSize := RecSize;
end;

destructor TNRecordList.Destroy;
begin
    if PData <> nil then FreeMem(PData);
    inherited;
end;

procedure TNRecordList.Add(pBuf : Pointer);
const
    LIST_BLOCK_SIZE =   128;
var
    ptr : Pointer;
begin
    if DataSize <= RealCount * RecordSize then
    begin
        Inc(DataSize, LIST_BLOCK_SIZE * RecordSize);

        if PData = nil then
            GetMem(PData, DataSize)
        else
            ReallocMem(PData, DataSize);
    end;

    ptr := Pointer(Cardinal(PData) + Cardinal(RealCount) * Cardinal(RecordSize));

    if pBuf = nil then
        FillChar(ptr^, RecordSize, 0)
    else
        Move(pBuf^, ptr^, RecordSize);

    Inc(RealCount);
end;

procedure TNRecordList.Delete(Index : Integer);
var
    pnew, pold, ptr : Pointer;
    n : Integer;
begin
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;
    if RealCount = 0 then Exit;

    if RealCount = 1 then
        pnew := nil
    else
        GetMem(pnew, RecordSize * (RealCount - 1));

    ptr := pnew;
    pold := PData;

    for n := 0 to RealCount - 1 do
    begin
        if n <> Index then
        begin
            Move(pold^, ptr^, RecordSize);
            ptr := Pointer(Cardinal(ptr) + Cardinal(RecordSize));
        end;

        pold := Pointer(Cardinal(pold) + Cardinal(RecordSize));
    end;

    FreeMem(PData);
    PData := pnew;
end;

procedure TNRecordList.SetData(Index : Integer ; pBuf : Pointer);
var
    ptr : Pointer;
begin
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;
    if pBuf = nil then Exit;

    ptr := Pointer(Cardinal(PData) + Cardinal(Index) * Cardinal(RecordSize));
    Move(pBuf^, ptr^, RecordSize);
end;

function TNRecordList.GetData(Index : Integer) : Pointer;
begin
    Result := nil;
    if (Index < 0) or (Index >= Integer(RealCount)) then Exit;
    Result := Pointer(Cardinal(PData) + Cardinal(Index) * Cardinal(RecordSize));
end;

function TNRecordList.IndexOf(Data : Pointer) : Integer;
var
    m, n : Integer;
    p, pd : PChar;
    found : Boolean;
begin
    Result := -1;

    for n := 0 to RealCount - 1 do
    begin
        pd := Data;
        p := PChar(Cardinal(PData) + Cardinal(n) * Cardinal(RecordSize));
        found := True;

        for m := 0 to RecordSize - 1 do
        begin
            if p^ <> pd^ then
            begin
                found := False;
                Break;
            end;
        end;

        if found then
        begin
            Result := n;
            Exit;
        end;
    end;
end;

//******************************************************************************
//TStringListTuZbg

constructor TNStringList.Create;
begin
    ItemCount := 0;
    //Locked := False;
    SortEvent := nil;

    try
        GetMem(Items,ItemCount * SizeOf(Pointer));
        GetMem(Lengths,ItemCount * SizeOf(Pointer));
    except
    end;
end;

destructor TNStringList.Destroy;
begin
    Clear;
    FreeMem(Items,0);
    FreeMem(Lengths,0);
end;

procedure TNStringList.Clear;
var
    n : Integer;
    P : Pointer;
    sz : Integer;
begin
    try
        //bN܂őҋ@
        //while Locked do
        //    Sleep(10);

        //bN
        //Locked := True;

        //ACe
        for n := 0 to ItemCount - 1 do
        begin
            P := Pointer((PInteger(PChar(Items) + SizeOf(Pointer) * n))^);
            sz := (PInteger(PChar(Lengths) + SizeOf(Pointer) * n))^;
            FreeMem(P,sz);
        end;

        ReallocMem(Items,SizeOf(Pointer) * ItemCount);
        ReallocMem(Lengths,SizeOf(Pointer) * ItemCount);

        ItemCount := 0;
    except
    end;

    //bN
    //Locked := False;

    inherited Destroy;
end;

procedure TNStringList.Add(const Value : String);
var
    P : PInteger;
    Pt : Pointer;
    sz : Integer;
begin
    //bN܂őҋ@
    //while Locked do
    //    Sleep(10);

    //bN
    //Locked := True;

    ReallocMem(Items , SizeOf(Pointer) * (ItemCount + 1));
    ReallocMem(Lengths , SizeOf(Pointer) * (ItemCount + 1));
    sz := Length(Value);
    GetMem(Pt,sz);
    //XgɊi[
    P := PInteger(PChar(Items) + SizeOf(Pointer) * ItemCount);
    P^ := Integer(Pt);
    //XgɊi[
    P := PInteger(PChar(Lengths) + SizeOf(Pointer) * ItemCount);
    P^ := sz;
    //i[
    CopyString(Pt, Value);

    ItemCount := ItemCount + 1;

    //bN
    //Locked := False;
end;

function TNStringList.GetText : String;
var
    n : Integer;
    P : PChar;
    r : PChar;
    size : Integer;
    sz : Integer;
    csz : Integer;
begin
    //bN܂őҋ@
    //while Locked do
    //    Sleep(10);

    Result := '';
    size := 0;
    csz := 0;

    //TCY̌vZ
    for n := 0 to ItemCount - 1 do
        size := size + (PInteger(PChar(Lengths) + SizeOf(Pointer) * n))^ + 2;

    //TCYݒ
    SetLength(Result,size);
    r := PChar(Result);

    for n := 0 to ItemCount - 1 do
    begin
        P := Pointer((PInteger(PChar(Items) + SizeOf(Pointer) * n))^);
        sz := (PInteger(PChar(Lengths) + SizeOf(Pointer) * n))^;

        CopyString(r + csz , Copy(P,1,sz) + CRLF);
        csz := csz + sz + 2;
    end;
end;

{
procedure TNStringList.SetText(const Value : String);
var
    P : PChar;
    ch : Char;
    sz : Integer;
    n : Integer;
    start : Integer;
    temp : String;
begin
    Clear;

    P := PChar(Value);
    sz := Length(Value) - 1;
    start := 1;
    n := 0;

    while n <= sz do
    begin
        ch := (P + n)^;

        if ch = #13 then
        begin
            temp := Copy(Value,start,n-start+1);
            Add(temp);

            if n <> sz then
            begin
                if (P + n + 1)^ = #10 then
                begin
                    start := n + 3;
                    n := n + 1;
                end
                else
                    start := n + 1;
            end
            else
                Exit;
        end
        else if ch = #10 then
        begin
            temp := Copy(Value,start,n-start+1);
            Add(temp);
            start := n + 1;
        end;

        n := n + 1;
    end;

    if start <> sz then
    begin
        temp := Copy(Value,start,n-start+1);
        if temp <> '' then Add(temp);
    end;

end;
}

procedure TNStringList.SetText(const Value : String);
var
    p : PChar;
    n, sz : Integer;
    temp : String;
begin
    Clear;

    n := 0;
    p := PChar(Value);
    sz := Length(Value);
    temp := '';

    while n < sz do
    begin
        if p^ = #13 then
        begin
            Add(temp);
            temp := '';

            if (p + 1)^ = #10 then
            begin
                Inc(n);
                Inc(p);
            end;
        end
        else if p^ = #10 then
        begin
            Add(temp);
            temp := '';
        end
        else
            temp := temp + p^;

        Inc(n);
        Inc(p);
    end;

    if temp <> '' then Add(temp);
end;

function TNStringList.GetLine(Index : Integer) : String;
var
    P : PChar;
    sz : Integer;
begin
    //while Locked do
    //    Sleep(10);

    Result := '';

    if (Index < 0) or (Index >= ItemCount) then Exit;

    P := Pointer((PInteger(PChar(Items) + SizeOf(Pointer) * Index))^);
    sz := (PInteger(PChar(Lengths) + SizeOf(Pointer) * Index))^;
    SetLength(Result, sz);
    Move(p^, PChar(Result)^,sz);
    //Result := Copy(P,1,sz);
end;

procedure TNStringList.SetLine(Index : Integer ; const Value : String);
var
    P : PInteger;
    Pt : Pointer;
    sz : Integer;
begin
    if (Index < 0) or (Index >= ItemCount) then Exit;

    //bN܂őҋ@
    //while Locked do
    //    Sleep(10);

    //bN
    //Locked := True;

    //ȑÕf[^
    Pt := Pointer((PInteger(PChar(Items) + SizeOf(Pointer) * Index))^);
    sz := (PInteger(PChar(Lengths) + SizeOf(Pointer) * Index))^;
    FreeMem(Pt,sz);

    //Vf[^i[
    sz := Length(Value);
    GetMem(Pt,sz);

    P := PInteger(PChar(Items) + SizeOf(Pointer) * Index);
    P^ := Integer(Pt);

    P := PInteger(PChar(Lengths) + SizeOf(Pointer) * Index);
    P^ := sz;

    CopyString(Pt,Value);

    //bN
    //Locked := False;
end;

function TNStringList.CatStrings : String;
var
    n : Integer;
    P : PChar;
    r : PChar;
    size : Integer;
    sz : Integer;
    csz : Integer;
begin
    Result := '';
    size := 0;
    csz := 0;

    //TCY̌vZ
    for n := 0 to ItemCount - 1 do
        size := size + (PInteger(PChar(Lengths) + SizeOf(Pointer) * n))^;

    //TCYݒ
    SetLength(Result,size);
    r := PChar(Result);

    for n := 0 to ItemCount - 1 do
    begin
        P := Pointer((PInteger(PChar(Items) + SizeOf(Pointer) * n))^);
        sz := (PInteger(PChar(Lengths) + SizeOf(Pointer) * n))^;

        CopyString(r + csz , Copy(P,1,sz));
        csz := csz + sz;
    end;
end;

procedure TNStringList.QuickSort(L, R: Integer);
var
    I, J, Index : Integer;
    T : Integer;
    pI, pJ : PInteger;
    temp : String;
begin
    repeat
        I := L;
        J := R;
        Index := (L + R) shr 1;
        temp := GetLine(Index);
        repeat
            while CompareStr(GetLine(I), temp) < 0 do Inc(I);
            while CompareStr(GetLine(J), temp) > 0 do Dec(J);
            if I <= J then
            begin
                //|C^̈ړ
                pI := PInteger(PChar(Items) + SizeOf(Pointer) * I);
                pJ := PInteger(PChar(Items) + SizeOf(Pointer) * J);
                T := pI^;
                pI^ := pJ^;
                pJ^ := T;

                //TCŸړ
                pI := PInteger(PChar(Lengths) + SizeOf(Pointer) * I);
                pJ := PInteger(PChar(Lengths) + SizeOf(Pointer) * J);
                T := pI^;
                pI^ := pJ^;
                pJ^ := T;

                if @SortEvent <> nil then SortEvent(Self, I, J);

                Inc(I);
                Dec(J);
            end;
        until I > J;

        if L < J then
            QuickSort(L, J);
        L := I;
    until I >= R;
end;

procedure TNStringList.Sort;
begin
    //bN܂őҋ@
    //while Locked do
    //    Sleep(10);

    if ItemCount > 0 then
        QuickSort(0, ItemCount - 1);
end;

procedure TNStringList.Delete(Index : Integer);
var
    Pt : PChar;
    NPt : PChar;
    OPt : PChar;
    sz : Integer;
    bs : Integer;
begin
    //ubNTCY
    bs := SizeOf(Pointer);

    //`FbN
    if ItemCount = 0 then Exit;
    if (Index < 0) or (Index >= ItemCount) then Exit;

    //ȑÕf[^
    Pt := PChar((PInteger(PChar(Items) + bs * Index))^);
    sz := (PInteger(PChar(Lengths) + bs * Index))^;
    FreeMem(Pt,sz);

    //Ve[ȕ
    GetMem(Pt,(ItemCount - 1) * bs);

    //e[u̍č\z
    NPt := Pt;
    OPt := Items;
    CopyMemory( NPt , OPt , Index * bs );
    OPt := OPt + (Index + 1) * bs;
    NPt := Pt + Index * bs;
    CopyMemory(NPt , OPt , (ItemCount - Index - 1) * bs);

    //e[u
    OPt := Items;
    Items := Pt;

    //Âe[ủ
    FreeMem(OPt,ItemCount * bs);

    //VLengthe[ȕ
    GetMem(Pt,(ItemCount - 1) * bs);

    //Lengthe[u̍č\z
    NPt := Pt;
    OPt := Lengths;
    CopyMemory( NPt , OPt , Index * bs );
    OPt := OPt + (Index + 1) * bs;
    NPt := Pt + Index * bs;
    CopyMemory(NPt , OPt , (ItemCount - Index - 1) * bs);

    //Lengthe[u
    OPt := Lengths;
    Lengths := Pt;

    //LengthÂe[ủ
    FreeMem(OPt,ItemCount * bs);

    //ItemCountfNg
    ItemCount := ItemCount - 1;

    //XgAbN
    //Locked := False;
end;

procedure TNStringList.LoadFromFile(FileName : String);
begin
    SetText(tn_utils.LoadFromFile(FileName));
end;

procedure TNStringList.SaveToFile(FileName : String);
begin
    tn_utils.SaveToFile(FileName,GetText);
end;

function TNStringList.IndexOf(const Value : String) : Integer;
var
    n : Integer;
begin
    Result := -1;
    for n := 0 to Count - 1 do
    begin
        if GetLine(n) = Value then
        begin
            Result := n;
            Break;
        end;
    end;
end;

//Xbh֐

function ThreadProc(p: Pointer) : Integer;
var
    ExitCode : Cardinal;
    Thread : TNThread;
begin
    Result := 0;
    if p = nil then Exit;
    Thread := TNThread(p);
    GetExitCodeThread(Thread.Handle,ExitCode);

    Thread.ExitCode := ExitCode;
    Thread.Execute;

    //XbhI
    Result := ExitCode;
    CloseHandle(Thread.Handle);

    //
    Thread.Handle := 0;
    Thread.NowSuspended := True;

    if Thread.FFreeOnTerminate then Thread.Free;
end;

//XbhNX

constructor TNThread.Create(CreateSuspended: Boolean);
begin
    Handle := 0;
    NowSuspended := True;
    TermEventObj := nil;
    TermEvent := nil;

    if not CreateSuspended then Resume;
end;

destructor TNThread.Destroy;
begin
    Terminate;
    if @TermEventObj <> nil then TermEventObj(Self);
    if @TermEvent <> nil then
        TermEvent(Self);

    inherited Destroy;
end;

procedure TNThread.StartThread;
begin
    Handle := BeginThread(nil,0,ThreadProc,Self,0,ThreadID);
    if Handle <> 0 then
        NowSuspended := False;
end;

procedure TNThread.Resume;
begin
    if not NowSuspended then Exit;

    if Handle <> 0 then
    begin
        if not (ResumeThread(ThreadID) = $FFFFFFFF) then
            NowSuspended := False;
    end
    else
        StartThread;
end;

procedure TNThread.Suspend;
begin
    if (NowSuspended) or (Handle = 0) then Exit;

    if not (SuspendThread(Handle) = $FFFFFFFF) then
        NowSuspended := True;
end;

procedure TNThread.Terminate;
begin
    if (Handle = 0) and (NowSuspended) then Exit;

    TerminateThread(Handle, ExitCode);
    CloseHandle(Handle);
    Handle := 0;
    NowSuspended := True;
end;

//******************************************************************************
// TNMemory

constructor TNMemory.Create(Size : Integer);
begin
    BlockSize := Size;
    BufSize := BlockSize;
    RealSize := 0;
    GetMem(PData, BufSize);
end;

destructor TNMemory.Destroy;
begin
    FreeMem(PData);

    inherited;
end;

procedure TNMemory.CheckMemory(Request : Integer);
var
    rsize : Integer;
begin
    rsize := RealSize + Request;

    if rsize > BufSize then
    begin
        while BufSize < rsize do
            BufSize := BufSize + BlockSize;

        ReallocMem(PData, BufSize);
    end;
end;

procedure TNMemory.PushChar(ch : Char);
begin
    CheckMemory(SizeOf(Char));
    PChar(PChar(PData) + RealSize)^ := ch;
    Inc(RealSize, SizeOf(Char));
end;

procedure TNMemory.PushWideChar(ch : WideChar);
begin
    CheckMemory(SizeOf(WideChar));
    PWideChar(PChar(PData) + RealSize)^ := ch;
    Inc(RealSize, SizeOf(WideChar));
end;

procedure TNMemory.Push(p : Pointer ; Size : Integer);
var
    dp : Pointer;
begin
    CheckMemory(Size);
    dp := PChar(PData) + RealSize;
    Move(p^, dp^, Size);
    Inc(RealSize, Size);
end;

procedure TNMemory.PushString(const Data : String);
begin
	Push(PChar(Data), Length(Data));
end;

//******************************************************************************

constructor TNQue.Create(Size : Integer);
begin
    Count := Size;
    SetLength(Ques, Count);
end;

destructor TNQue.Destroy;
begin
    inherited Destroy;
    SetLength(Ques, 0);
end;

procedure TNQue.Add(Data : Char);
var
    n : Integer;
begin
    for n := 0 to Count - 2 do
    begin
        Ques[n] := Ques[n + 1];
    end;

    Ques[Count - 1] := Data;
end;

procedure TNQue.Clear;
begin
    FillChar(Ques, Size, #0);
end;

//******************************************************************************

constructor TNWriteFile.Create(FileName : String);
begin
    Opened := True;
    FileMode := 1;
    try
        AssignFile(F, FileName);
        ReWrite(F);
    except
        Opened := False;
    end;
end;

destructor TNWriteFile.Destroy;
begin
    CloseFile(F);
    inherited Destroy;
end;

function TNWriteFile.Write(const Data : String) : Boolean;
begin
    Result := True;

    try
        System.Write(F, Data);
    except
        Result := False;
    end;
end;

function TNWriteFile.Writeln(const Data : String) : Boolean;
begin
    Result := True;

    try
        System.Writeln(F, Data);
    except
        Result := False;
    end;
end;

function TNWriteFile.Put(Data : Pointer ; Size : Integer) : Boolean;
var
    temp : String;
begin
    Result := True;
    SetLength(temp, Size);

    try
        Move(Data^, PChar(temp)^, Size);
    except
        Result := False;
    end;
end;

//******************************************************************************
//TNVirtualGrid

constructor TNVirtualGrid.Create(x : Integer);
var
    n : Integer;
begin
    if x < 1 then
    begin
        Width := 0;
        Exit;
    end;

    Width := x;
    SetLength(Datas, x);

    for n := 0 to Width - 1 do
    begin
        Datas[n] := TNStringList.Create;
    end;
end;

destructor TNVirtualGrid.Destroy;
var
    n : Integer;
begin
    for n := 0 to Width - 1 do
    begin
        Datas[n].Free;
    end;

    inherited Destroy;
end;

function TNVirtualGrid.GetData(Column : Integer ; Line : Integer) : String;
begin
    Result := '';
    if Width = 0 then Exit;
    if (Column >= Width) or (Line >= Datas[0].Count) then Exit;

    Result := Datas[Column].Strings[Line];
end;

function TNVirtualGrid.SearchIndex(const Data : String ; Index : Integer) : Integer;
begin
    if Width = 0 then
    begin
        Result := -1;
        Exit;
    end;

    if (Index < 0) or (Index >= Width) then
    begin
        Result := -1;
        Exit;
    end;

    Result := Datas[Index].IndexOf(Data);
end;

procedure TNVirtualGrid.Add(const args : array of String);
var
    n : Integer;
begin
    if Width = 0 then Exit;
    if High(args) <> Width - 1 then Exit;

    for n := 0 to Width - 1 do
        Datas[n].Add(args[n]);
end;

procedure TNVirtualGrid.Clear;
var
    n : Integer;
begin
    for n := 0 to Width - 1 do
        Datas[n].Clear;
end;

end.
