unit tn_inet;

{
    Based on Delphi's wininet.pas

    wininet.dllIEɓYtDLLZbĝߏWin95ł͓RȂ瑶݂Ȃ
    邢͌Âo[Wł͖肪\
    ̂ߓI[hɂāA\ȂΎgps\łΎgpȂƂɂ
}

interface

uses
    windows;

var
    InetInstance : THandle;
    InetLoaded : Boolean;

type
    HINTERNET = Pointer;
    PHINTERNET = ^HINTERNET;

    INTERNET_PORT = Word;
    PINTERNET_PORT = ^INTERNET_PORT;

    TInternetOpen           =   function (lpszAgent: PChar; dwAccessType: DWORD; lpszProxy, lpszProxyBypass: PChar; dwFlags: DWORD): HINTERNET; stdcall;
    TInternetOpenUrl        =   function (hInet: HINTERNET; lpszUrl: PChar; lpszHeaders: PChar; dwHeadersLength: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; stdcall;
    TInternetSetOption      =   function (hInet: HINTERNET; dwOption: DWORD; lpBuffer: Pointer; dwBufferLength: DWORD): BOOL; stdcall;
    TInternetConnect        =   function (hInet: HINTERNET; lpszServerName: PChar; nServerPort : INTERNET_PORT; lpszUsername: PChar; lpszPassword: PChar; dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; stdcall;
    THttpOpenRequest        =   function (hConnect: HINTERNET; lpszVerb: PChar; lpszObjectName: PChar; lpszVersion: PChar; lpszReferrer: PChar; lplpszAcceptTypes: PChar; dwFlags: DWORD; dwContext: DWORD): HINTERNET; stdcall;
    THttpSendRequest        =   function (hRequest: HINTERNET; lpszHeaders: PAnsiChar; dwHeadersLength: DWORD; lpOptional: Pointer; dwOptionalLength: DWORD): BOOL; stdcall;
    THttpQueryInfo          =   function (hRequest: HINTERNET; dwInfoLevel: DWORD; lpvBuffer: Pointer; var lpdwBufferLength: DWORD; var lpdwReserved: DWORD): BOOL; stdcall;
    TInternetReadFile       =   function (hFile: HINTERNET; lpBuffer: Pointer; dwNumberOfBytesToRead: DWORD; var lpdwNumberOfBytesRead: DWORD): BOOL; stdcall;
    TInternetCloseHandle    =   function (hInet: HINTERNET): BOOL; stdcall;
    TInternetAttemptConnect =   function (dwReserved: DWORD): DWORD; stdcall;

    TNInet  =   class
        public
            constructor Create;
            destructor Destroy; override;
            function InternetOpen(lpszAgent : PChar ; dwAccessType : DWORD ; lpszProxy, lpszProxyBypass : PChar ; dwFlags : DWORD) : HINTERNET;
            function InternetOpenUrl(hInet: HINTERNET; lpszUrl: PChar; lpszHeaders: PChar; dwHeadersLength: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET;
            function InternetSetOption(hInet : HINTERNET ; dwOption : DWORD ; lpBuffer : Pointer ; dwBufferLength : DWORD) : BOOL;
            function InternetConnect(hInet : HINTERNET ; lpszServerName : PChar ; nServerPort : INTERNET_PORT ; lpszUsername : PChar ; lpszPassword : PChar ; dwService : DWORD ; dwFlags : DWORD ; dwContext : DWORD): HINTERNET;
            function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: PChar; lpszObjectName: PChar; lpszVersion: PChar; lpszReferrer: PChar; lplpszAcceptTypes: PChar; dwFlags: DWORD; dwContext: DWORD): HINTERNET;
            function HttpSendRequest(hRequest: HINTERNET; lpszHeaders: PAnsiChar ; dwHeadersLength : DWORD ; lpOptional : Pointer ; dwOptionalLength : DWORD): BOOL;
            function HttpQueryInfo(hRequest: HINTERNET; dwInfoLevel: DWORD; lpvBuffer: Pointer; var lpdwBufferLength: DWORD; var lpdwReserved: DWORD): BOOL;
            function InternetReadFile(hFile: HINTERNET; lpBuffer: Pointer; dwNumberOfBytesToRead: DWORD; var lpdwNumberOfBytesRead: DWORD): BOOL;
            function InternetCloseHandle(hInet: HINTERNET): BOOL;
            function InternetAttemptConnect(dwReserved: DWORD): DWORD;
    end;

const
    INTERNET_INVALID_PORT_NUMBER = 0;                 { use the protocol-specific default }

    INTERNET_DEFAULT_FTP_PORT = 21;                   { default for FTP servers }
    INTERNET_DEFAULT_GOPHER_PORT = 70;                {    "     "  gopher " }
    INTERNET_DEFAULT_HTTP_PORT = 80;                  {    "     "  HTTP   " }
    INTERNET_DEFAULT_HTTPS_PORT = 443;                {    "     "  HTTPS  " }
    INTERNET_DEFAULT_SOCKS_PORT = 1080;               { default for SOCKS firewall servers.}

    INTERNET_SERVICE_URL = 0;
    INTERNET_SERVICE_FTP = 1;
    INTERNET_SERVICE_GOPHER = 2;
    INTERNET_SERVICE_HTTP = 3;

    INTERNET_OPEN_TYPE_PRECONFIG        = 0;  { use registry configuration }
    INTERNET_OPEN_TYPE_DIRECT           = 1;  { direct to net }
    INTERNET_OPEN_TYPE_PROXY            = 3;  { via named proxy }
    INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY  = 4;   { prevent using java/script/INS }

    INTERNET_OPTION_CALLBACK = 1;
    INTERNET_OPTION_CONNECT_TIMEOUT = 2;
    INTERNET_OPTION_CONNECT_RETRIES = 3;
    INTERNET_OPTION_CONNECT_BACKOFF = 4;
    INTERNET_OPTION_SEND_TIMEOUT = 5;
    INTERNET_OPTION_CONTROL_SEND_TIMEOUT       = INTERNET_OPTION_SEND_TIMEOUT;
    INTERNET_OPTION_RECEIVE_TIMEOUT = 6;
    INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT    = INTERNET_OPTION_RECEIVE_TIMEOUT;
    INTERNET_OPTION_DATA_SEND_TIMEOUT = 7;
    INTERNET_OPTION_DATA_RECEIVE_TIMEOUT = 8;
    INTERNET_OPTION_HANDLE_TYPE = 9;

    INTERNET_OPTION_READ_BUFFER_SIZE = 12;
    INTERNET_OPTION_WRITE_BUFFER_SIZE = 13;

    INTERNET_OPTION_ASYNC_ID = 15;
    INTERNET_OPTION_ASYNC_PRIORITY = 16;

    INTERNET_OPTION_PARENT_HANDLE               = 21;
    INTERNET_OPTION_KEEP_CONNECTION             = 22;
    INTERNET_OPTION_REQUEST_FLAGS               = 23;
    INTERNET_OPTION_EXTENDED_ERROR              = 24;

    INTERNET_OPTION_OFFLINE_MODE                = 26;
    INTERNET_OPTION_CACHE_STREAM_HANDLE         = 27;
    INTERNET_OPTION_USERNAME                    = 28;
    INTERNET_OPTION_PASSWORD                    = 29;
    INTERNET_OPTION_ASYNC                       = 30;
    INTERNET_OPTION_SECURITY_FLAGS              = 31;
    INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT = 32;
    INTERNET_OPTION_DATAFILE_NAME               = 33;
    INTERNET_OPTION_URL                         = 34;
    INTERNET_OPTION_SECURITY_CERTIFICATE        = 35;
    INTERNET_OPTION_SECURITY_KEY_BITNESS        = 36;
    INTERNET_OPTION_REFRESH                     = 37;
    INTERNET_OPTION_PROXY                       = 38;
    INTERNET_OPTION_SETTINGS_CHANGED            = 39;
    INTERNET_OPTION_VERSION                     = 40;
    INTERNET_OPTION_USER_AGENT                  = 41;
    INTERNET_OPTION_END_BROWSER_SESSION         = 42;
    INTERNET_OPTION_PROXY_USERNAME              = 43;
    INTERNET_OPTION_PROXY_PASSWORD              = 44;
    INTERNET_OPTION_CONTEXT_VALUE               = 45;
    INTERNET_OPTION_CONNECT_LIMIT               = 46;
    INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT = 47;
    INTERNET_OPTION_POLICY                      = 48;
    INTERNET_OPTION_DISCONNECTED_TIMEOUT        = 49;
    INTERNET_OPTION_CONNECTED_STATE             = 50;
    INTERNET_OPTION_IDLE_STATE                  = 51;
    INTERNET_OPTION_OFFLINE_SEMANTICS           = 52;
    INTERNET_OPTION_SECONDARY_CACHE_KEY         = 53;
    INTERNET_OPTION_CALLBACK_FILTER             = 54;
    INTERNET_OPTION_CONNECT_TIME                = 55;
    INTERNET_OPTION_SEND_THROUGHPUT             = 56;
    INTERNET_OPTION_RECEIVE_THROUGHPUT          = 57;
    INTERNET_OPTION_REQUEST_PRIORITY            = 58;
    INTERNET_OPTION_HTTP_VERSION                = 59;
    INTERNET_OPTION_RESET_URLCACHE_SESSION      = 60;
    INTERNET_OPTION_ERROR_MASK                  = 62;

    INTERNET_FIRST_OPTION                      = INTERNET_OPTION_CALLBACK;
    INTERNET_LAST_OPTION                       = INTERNET_OPTION_PROXY;

    INTERNET_FLAG_RELOAD = $80000000;                 { retrieve the original item }

    INTERNET_FLAG_RESYNCHRONIZE     = $00000800;  // asking wininet to update an item if it is newer
    INTERNET_FLAG_HYPERLINK         = $00000400;  // asking wininet to do hyperlinking semantic which works right for scripts
    INTERNET_FLAG_NO_UI             = $00000200;  // no cookie popup
    INTERNET_FLAG_PRAGMA_NOCACHE    = $00000100;  // asking wininet to add "pragma: no-cache"
    INTERNET_FLAG_CACHE_ASYNC       = $00000080;  // ok to perform lazy cache-write
    INTERNET_FLAG_FORMS_SUBMIT      = $00000040;  // this is a forms submit
    INTERNET_FLAG_NEED_FILE         = $00000010;  // need a file for this request

    INTERNET_FLAG_SECURE                = $00800000;  { use PCT/SSL if applicable (HTTP) }
    INTERNET_FLAG_KEEP_CONNECTION       = $00400000;  { use keep-alive semantics }
    INTERNET_FLAG_NO_AUTO_REDIRECT      = $00200000;  { don't handle redirections automatically }
    INTERNET_FLAG_READ_PREFETCH         = $00100000;  { do background read prefetch }
    INTERNET_FLAG_NO_COOKIES            = $00080000;  { no automatic cookie handling }
    INTERNET_FLAG_NO_AUTH               = $00040000;  { no automatic authentication handling }
    INTERNET_FLAG_CACHE_IF_NET_FAIL     = $00010000;  { return cache file if net request fails }

    INTERNET_FLAG_IGNORE_CERT_CN_INVALID        = $00001000; { bad common name in X509 Cert. }
    INTERNET_FLAG_IGNORE_CERT_DATE_INVALID      = $00002000; { expired X509 Cert. }
    INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS      = $00004000; { ex: http:// to https:// }
    INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP       = $00008000; { ex: https:// to http:// }

    HTTP_QUERY_RAW_HEADERS_CRLF                 = 22; { special: all headers }

implementation

constructor TNInet.Create;
begin
    //Wininet.dll
    {
    DLLInst := LoadLibrary('wininet.dll');
    Succeed := DLLInst <> 0;
    }
end;

destructor TNInet.Destroy;
begin
    //if Succeed then FreeLibrary(DLLInst);
    inherited Destroy;
end;

function TNInet.InternetOpen(lpszAgent : PChar ; dwAccessType : DWORD;
            lpszProxy, lpszProxyBypass : PChar ; dwFlags : DWORD) : HINTERNET;
var
    Proc : TInternetOpen;
begin
    //Proc := GetProcAddress(DLLInst, 'InternetOpenA');
    Proc := GetProcAddress(InetInstance, 'InternetOpenA');
    Result := Proc(lpszAgent, dwAccessType, lpszProxy, lpszProxyBypass, dwFlags);
end;

function TNInet.InternetOpenUrl(hInet: HINTERNET; lpszUrl: PChar
                                ; lpszHeaders: PChar; dwHeadersLength: DWORD
                                ; dwFlags: DWORD; dwContext: DWORD): HINTERNET;
var
    Proc : TInternetOpenUrl;
begin
    Proc := GetProcAddress(InetInstance, 'InternetOpenUrlA');
    Result := Proc(hInet, lpszUrl, lpszHeaders
                    , dwHeadersLength, dwFlags, dwContext);
end;

function TNInet.InternetSetOption(hInet : HINTERNET ; dwOption : DWORD
                        ; lpBuffer : Pointer ; dwBufferLength : DWORD) : BOOL;
var
    Proc : TInternetSetOption;
begin
    //Proc := GetProcAddress(DLLInst, 'InternetSetOptionA');
    Proc := GetProcAddress(InetInstance, 'InternetSetOptionA');
    Result := Proc(hInet, dwOption, lpBuffer, dwBufferLength);
end;

function TNInet.InternetConnect(hInet : HINTERNET ; lpszServerName : PChar
    ; nServerPort : INTERNET_PORT ; lpszUsername : PChar ; lpszPassword : PChar
    ; dwService : DWORD ; dwFlags : DWORD ; dwContext : DWORD): HINTERNET;
var
    Proc : TInternetConnect;
begin
    //Proc := GetProcAddress(DLLInst, 'InternetConnectA');
    Proc := GetProcAddress(InetInstance, 'InternetConnectA');
    Result := Proc(hInet, lpszServerName, nServerPort, lpszUsername
                        , lpszPassword, dwService, dwFlags, dwContext);
end;

function TNInet.HttpOpenRequest(hConnect : HINTERNET ; lpszVerb : PChar
                                    ; lpszObjectName : PChar
                                    ; lpszVersion : PChar
                                    ; lpszReferrer : PChar
                                    ; lplpszAcceptTypes : PChar
                                    ; dwFlags : DWORD
                                    ; dwContext: DWORD) : HINTERNET;
var
    Proc : THttpOpenRequest;
begin
    //Proc := GetProcAddress(DLLInst, 'HttpOpenRequestA');
    Proc := GetProcAddress(InetInstance, 'HttpOpenRequestA');
    Result := Proc(hConnect, lpszVerb, lpszObjectName, lpszVersion
                    , lpszReferrer, lplpszAcceptTypes, dwFlags, dwContext);
end;

function TNInet.HttpSendRequest(hRequest: HINTERNET; lpszHeaders: PAnsiChar
                                ; dwHeadersLength : DWORD ; lpOptional : Pointer
                                ; dwOptionalLength : DWORD): BOOL;
var
    Proc : THttpSendRequest;
begin
    //Proc := GetProcAddress(DLLInst, 'HttpSendRequestA');
    Proc := GetProcAddress(InetInstance, 'HttpSendRequestA');
    Result := Proc(hRequest, lpszHeaders, dwHeadersLength
                            , lpOptional, dwOptionalLength);
end;

function TNInet.HttpQueryInfo(hRequest: HINTERNET ; dwInfoLevel : DWORD
                            ; lpvBuffer: Pointer; var lpdwBufferLength: DWORD
                                                ; var lpdwReserved: DWORD): BOOL;
var
    Proc : THttpQueryInfo;
begin
    //Proc := GetProcAddress(DLLInst, 'HttpQueryInfoA');
    Proc := GetProcAddress(InetInstance, 'HttpQueryInfoA');
    Result := Proc(hRequest, dwInfoLevel, lpvBuffer
                    , lpdwBufferLength, lpdwReserved);
end;

function TNInet.InternetReadFile(hFile: HINTERNET; lpBuffer: Pointer
        ; dwNumberOfBytesToRead: DWORD; var lpdwNumberOfBytesRead: DWORD): BOOL;
var
    Proc : TInternetReadFile;
begin
    //Proc := GetProcAddress(DLLInst, 'InternetReadFile');
    Proc := GetProcAddress(InetInstance, 'InternetReadFile');
    Result := Proc(hFile, lpBuffer, dwNumberOfBytesToRead
                                    , lpdwNumberOfBytesRead);
end;

function TNInet.InternetCloseHandle(hInet: HINTERNET): BOOL;
var
    Proc : TInternetCloseHandle;
begin
    //Proc := GetProcAddress(DLLInst, 'InternetCloseHandle');
    Proc := GetProcAddress(InetInstance, 'InternetCloseHandle');
    Result := Proc(hInet);
end;

function TNInet.InternetAttemptConnect(dwReserved: DWORD): DWORD;
var
    Proc : TInternetAttemptConnect;
begin
    //Proc := GetProcAddress(DLLInst, 'InternetAttemptConnect');
    Proc := GetProcAddress(InetInstance, 'InternetAttemptConnect');
    Result := Proc(dwReserved);
end;

initialization
    InetInstance := LoadLibrary('wininet.dll');
    InetLoaded := InetInstance <> 0;

finalization
    if InetLoaded then FreeLibrary(InetInstance);

end.
