unit tn_socket;

interface

uses
    winsock, tn_classes, tn_utils;

type
	PAddrIn         =   ^TInAddr;

    TNSocket        =   class
        private
            function Get_LocalHost : String;
        public
            Connected : Boolean;
            Host : String;
            NoBuffer : Boolean;
            Port : Integer;
            Socket : TSocket;
            TimeOut : Integer;
            ProtocolType : Integer;
            constructor Create; overload;
            constructor Create(Types : Integer); overload;
            destructor Destroy; override;
            function Connect(Host : String ; Port : Integer) : Boolean;
            procedure Close;
            function Read(Buf : Pointer ; Size : Integer) : Integer;
            function Write(Buf : Pointer ; Size : Integer) : Integer;
            procedure SendCommand(SendString : String);
            function ReadLine : String;
            function SocketCheck : Boolean;
            procedure SendString(Data : String);
            procedure BlockWrite(const Data : String);
			function ReadData(Size : Integer) : String;
        published
            property LocalHost : String read Get_LocalHost;
    end;

implementation

constructor TNSocket.Create;
var
    Dummy : WSADATA;
begin
	//\Pbg̏
	WSAStartup($0101, Dummy);
    Socket := INVALID_SOCKET;
    Connected := False;
    Port := 0;
    Host := '';
    TimeOut := 30;
    NoBuffer := True;
    ProtocolType := SOCK_STREAM;
end;

constructor TNSocket.Create(Types : Integer);
var
    Dummy : WSADATA;
begin
	//\Pbg̏
	WSAStartup($0101, Dummy);
    Socket := INVALID_SOCKET;
    Connected := False;
    Port := 0;
    Host := '';
    TimeOut := 30;
    NoBuffer := True;
    ProtocolType := Types;
end;

destructor TNSocket.Destroy;
begin
    if SocketCheck then
        Close;

    WSACleanup;
    inherited Destroy;
end;

function TNSocket.Connect(Host : String ; Port : Integer) : Boolean;
var
    SockAddrIn : TSockAddrIn;
	HostEnt	: PHostEnt;
    //Data : Boolean;
    n : Integer;
begin
    Result := False;

    if Connected then
    begin
        Result := True;
        Exit;
    end;

    //\Pbg
    Winsock.closesocket(Socket);

    //vpeB̐ݒ
    Self.Host := Host;
    Self.Port := Port;

    //Ỏ
    for n := 1 to 5 do
    begin
        HostEnt := gethostbyname(PChar(Host));
        if HostEnt <> nil then Break;
    end;

    if HostEnt = nil then Exit;

    //SockAddrIn̏
    SockAddrIn.Sin_Family := AF_INET;
    SockAddrIn.Sin_addr.S_addr := INADDR_ANY;
    SockAddrIn.Sin_Port := htons(Port);
    SockAddrIn.sin_addr.S_addr := inet_addr(inet_ntoa((PAddrIn(HostEnt^.h_addr_list^))^));

    //Socket̏
    Socket := Winsock.Socket(AF_INET, ProtocolType, IPPROTO_IP);
    //Data := True;
    //setsockopt(Socket, SOL_SOCKET, SO_DONTLINGER, @Data, SizeOf(Boolean));

    //ڑ
    if Winsock.connect(Socket, SockAddrIn, SizeOf(SockAddrIn)) = SOCKET_ERROR then
        Socket := INVALID_SOCKET
    else
    begin
        Connected := True;
        Result := True;
    end;
end;

procedure TNSocket.Close;
begin
    if Connected then
    begin
        Winsock.closesocket(Socket);
        Socket := INVALID_SOCKET;
        Connected := False;
    end;
end;

function TNSocket.Read(Buf : Pointer ; Size : Integer) : Integer;
var
    Flag : Integer;
    FDSet : TFDSet;
    Tm: TTimeVal;
begin
    Result := 0;
    if not SocketCheck then Exit;

    Tm.tv_sec := Timeout;
    Tm.tv_usec := 0;
    FD_ZERO(FDSet);
    FD_SET(Socket, FDSet);
    Flag := select(Socket, @FDSet, nil, nil, @Tm);

    if (Flag = 0) or (Result = SOCKET_ERROR) then
    begin
        Close;
        Exit;
    end;

    Result := recv(Socket, Buf^, Size, 0);
end;

function TNSocket.Write(Buf : Pointer ; Size : Integer) : Integer;
var
    Flag : Integer;
    FDSet : TFDSet;
    Tm: TTimeVal;
begin
    Result := 0;
    if not SocketCheck then Exit;

    Tm.tv_sec := Timeout;
    Tm.tv_usec := 0;
    FD_ZERO(FDSet);
    FD_SET(Socket, FDSet);
    Flag := select(Socket, nil, @FDSet, nil, @Tm);
    Result := send(Socket, Buf^, Size, 0);

    if (Flag = 0) or (Result = SOCKET_ERROR) then Close;
    if Result = SOCKET_ERROR then Close;
end;

procedure TNSocket.SendCommand(SendString : String);
var
    Cmd : String;
begin
    if not SocketCheck then Exit;

    Cmd := SendString + #13#10;
    Self.Write(PChar(Cmd), Length(Cmd));
end;

function TNSocket.ReadLine : String;
var
    ch : Char;
begin
    Result := '';

    while Connected do
    begin
        if Read(@ch, 1) = -1 then Break;
        Result := Result + ch;
        if ch = #10 then Break;
    end;
end;

function TNSocket.SocketCheck : Boolean;
var
    SockAddr : TSockAddr;
    Value : Integer;
begin
    Result := False;
    if not Connected then Exit;

    if Socket = INVALID_SOCKET then
        Connected := False
    else
    begin
        Value := SizeOf(TSockAddr);

        if getpeername(Socket, SockAddr, Value) = 0 then
            Result := True
        else
            Connected := False;
    end;
end;

procedure TNSocket.SendString(Data : String);
begin
    if not SocketCheck then Exit;
    Self.Write(PChar(Data), Length(Data));
end;

procedure TNSocket.BlockWrite(const Data : String);
const
    BLOCK_SIZE  =   4096;
var
    PData : PChar;
    Ln : Integer;
    ps : Integer;
begin
    if not SocketCheck then Exit;
    PData := PChar(Data);
    Ln := Length(Data);
    ps := 0;

    while True do
    begin
        if ps >= Ln then Break;

        if (ps + BLOCK_SIZE) <= Ln then
            Self.Write(PChar(PData + ps), BLOCK_SIZE)
        else
            Self.Write(PChar(PData + ps), Ln mod BLOCK_SIZE);

        ps := ps + BLOCK_SIZE;
    end;
end;

{
function TNSocket.Get_LocalHost : String;
var
    buf : array [0..511] of Char;
begin
    FillChar(buf, SizeOf(buf), #0);
    gethostname(@buf, SizeOf(buf));
    Result := String(PChar(@buf));
end;
}

function TNSocket.Get_LocalHost : String;
type
	TInAddrList = array[0..100] of PInAddr;
    PInAddrList = ^TInAddrList;
var
	n : Integer;
    temp : String;
    buf : array [0..511] of Char;
    pent : PHostEnt;
    in_addr : TInAddr;
    list : TNStringList;
begin
    gethostname(buf, SizeOf(buf));
    pent := gethostbyname(buf);
	n := 0;
    list := TNStringList.Create;

	while PInAddrList(pent^.h_addr_list)^[n] <> nil do
	begin
		in_addr  :=PInAddrList(pent^.h_addr_list)^[n]^;
        list.Add(String(inet_ntoa(in_addr)));
		Inc(n);
	end;

    //127.0.0.1łȂ192.168.*.*łȂc
    for n := 0 to list.Count - 1 do
    begin
    	temp := Trim(list.Strings[n]);

        if (temp <> '127.0.0.1') and (Copy(temp, 1, 8) <> '192.168.') then
        begin
        	list.Free;
        	Result := temp;
            Exit;
        end;
    end;

    //127.0.0.1ł͂Ȃ...
    for n := 0 to list.Count - 1 do
    begin
    	temp := Trim(list.Strings[n]);

        if temp <> '127.0.0.1' then
        begin
        	list.Free;
        	Result := temp;
            Exit;
        end;
    end;

	//127.0.0.1Ɍ
	list.Free;
    Result := '127.0.0.1';
end;

function TNSocket.ReadData(Size : Integer) : String;
var
	p : Pointer;
    rs : Integer;
begin
	Result := '';
	GetMem(p, size);
    rs := Read(p, Size);
    if rs <= 0 then Exit;
	SetLength(Result, rs);
    Move(p^, Pointer(PChar(Result))^, rs);
    FreeMem(p);
end;

end.
