unit tn_stdctl;

interface

uses
    windows, messages, tn_utils;

    function Combo_Add(Handle : THandle ; Value : String) : Integer;
    function Combo_Clear(Handle : THandle) : Integer;
    function Combo_Count(Handle : THandle) : Integer;
    function Combo_GetIndex(Handle : THandle) : Integer;
    function Combo_GetItem(Handle : THandle ; Index : Integer) : String;
    function Combo_IndexOf(Handle : THandle ; Value : String) : Integer;
    function Combo_SetIndex(Handle : THandle ; Index : Integer) : Integer;

    function List_Add(Handle : THandle ; Value : String) : Integer;
    function List_Clear(Handle : THandle) : Integer;
    function List_Count(Handle : THandle) : Integer;
    function List_GetIndex(Handle : THandle) : Integer;
    function List_GetItem(Handle : THandle ; Index : Integer) : String;
    function List_IndexOf(Handle : THandle ; Value : String) : Integer;
    function List_SetIndex(Handle : THandle ; Index : Integer) : Integer;
    function List_Insert(Handle : THandle ; Index : Integer ; Value : String) : Integer;
    function List_Delete(Handle : THandle ; Index : Integer) : Integer;
    procedure List_Swap(Handle : THandle ; Index1 : Integer ; Index2 : Integer);
    function List_MoveUp(Handle : THandle) : Boolean;
    function List_MoveDown(Handle : THandle) : Boolean;

    function Ctl_SetText(Handle : THandle ; Value : String) : Integer;
    function Ctl_GetText(Handle : THandle) : String;
    procedure Ctl_SetEnabled(Handle : THandle ; Value : Boolean);

    function Ctl_IsChecked(Handle : THandle) : Boolean;
    function Ctl_SetCheck(Handle : THandle ; Checked : Boolean) : Integer;

implementation

//******************************************************************************
//R{{bNX

function Combo_Add(Handle : THandle ; Value : String) : Integer;
begin
    Result := SendMessage(Handle, CB_ADDSTRING, 0, Integer(PChar(Value)));
end;

function Combo_Clear(Handle : THandle) : Integer;
begin
    Result := SendMessage(Handle, CB_RESETCONTENT, 0, 0);
end;

function Combo_Count(Handle : THandle) : Integer;
begin
    Result := SendMessage(Handle, CB_GETCOUNT, 0, 0);
end;

function Combo_GetIndex(Handle : THandle) : Integer;
begin
    Result := SendMessage(Handle, CB_GETCURSEL, 0, 0);
end;

function Combo_GetItem(Handle : THandle ; Index : Integer) : String;
var
    Buf : String;
    Size : Integer;
begin
    Size := SendMessage(Handle, CB_GETLBTEXTLEN, Index, 0);
    SetLength(Buf, Size);
    SendMessage(Handle, CB_GETLBTEXT, Index, Integer(PChar(Buf)));
    Result := Trim(Buf);
end;

function Combo_IndexOf(Handle : THandle ; Value : String) : Integer;
begin
    Result := SendMessage(Handle, CB_FINDSTRING, 0, Integer(PChar(Value)));
end;

function Combo_SetIndex(Handle : THandle ; Index : Integer) : Integer;
begin
    Result := SendMessage(Handle, CB_SETCURSEL, Index, 0);
end;

//******************************************************************************
//Xg{bNX

function List_Add(Handle : THandle ; Value : String) : Integer;
begin
    Result := SendMessage(Handle, LB_ADDSTRING, 0, Integer(PChar(Value)));
end;

function List_Clear(Handle : THandle) : Integer;
begin
    Result := SendMessage(Handle, LB_RESETCONTENT, 0, 0);
end;

function List_Count(Handle : THandle) : Integer;
begin
    Result := SendMessage(Handle, LB_GETCOUNT, 0, 0);
end;

function List_GetIndex(Handle : THandle) : Integer;
begin
    Result := SendMessage(Handle, LB_GETCURSEL, 0, 0);
end;

function List_GetItem(Handle : THandle ; Index : Integer) : String;
var
    Buf : String;
    Size : Integer;
begin
    Size := SendMessage(Handle, LB_GETTEXTLEN, Index, 0);
    SetLength(Buf, Size);
    SendMessage(Handle, LB_GETTEXT, Index, Integer(PChar(Buf)));
    Result := Trim(Buf);
end;

function List_IndexOf(Handle : THandle ; Value : String) : Integer;
begin
    Result := SendMessage(Handle, LB_FINDSTRING, 0, Integer(PChar(Value)));
end;

function List_SetIndex(Handle : THandle ; Index : Integer) : Integer;
begin
    Result := SendMessage(Handle, LB_SETCURSEL, Index, 0);
end;

function List_Insert(Handle : THandle ; Index : Integer
                                                ; Value : String) : Integer;
begin
    Result := SendMessage(Handle, LB_INSERTSTRING, Index
                            , Integer(PChar(Value)));
end;

function List_Delete(Handle : THandle ; Index : Integer) : Integer;
begin
    Result := SendMessage(Handle, LB_DELETESTRING, Index, 0);
end;

procedure List_Swap(Handle : THandle ; Index1 : Integer ; Index2 : Integer);
var
    Data1, Data2 : String;
begin
    Data1 := List_GetItem(Handle, Index1);
    Data2 := List_GetItem(Handle, Index2);
    List_Delete(Handle, Index1);
    List_Insert(Handle, Index1, Data2);
    List_Delete(Handle, Index2);
    List_Insert(Handle, Index2, Data1);
end;

function List_MoveUp(Handle : THandle) : Boolean;
var
    Index : Integer;
begin
    Result := False;
    Index := List_GetIndex(Handle);
    if Index < 1 then Exit;
    Result := True;
    List_Swap(Handle, Index - 1, Index);
    List_SetIndex(Handle, Index - 1);
end;

function List_MoveDown(Handle : THandle) : Boolean;
var
    Index : Integer;
begin
    Result := False;
    Index := List_GetIndex(Handle);
    if Index = -1 then Exit;
    if Index >= List_Count(Handle) - 1 then Exit;
    Result := True;
    List_Swap(Handle, Index, Index + 1);
    List_SetIndex(Handle, Index + 1);
end;

//******************************************************************************
//ׂẴRg[

function Ctl_SetText(Handle : THandle ; Value : String) : Integer;
begin
    Result := SendMessage(Handle, WM_SETTEXT, 0, Integer(PChar(Value)));
end;

function Ctl_GetText(Handle : THandle) : String;
var
    Ln : Integer;
    Buf : String;
begin
    Ln := SendMessage(Handle, WM_GETTEXTLENGTH, 0, 0);
    SetLength(Buf, Ln + 1);
    SendMessage(Handle, WM_GETTEXT, Length(Buf), Integer(PChar(Buf)));
    Result := String(PChar(Buf));
end;

procedure Ctl_SetEnabled(Handle : THandle ; Value : Boolean);
begin
    //SendMessage(Handle, WM_ENABLE, Integer(Value), 0);
    EnableWindow(Handle, Value);
end;

//******************************************************************************
//`FbN{bNXƃWI{^̂ݗL

function Ctl_IsChecked(Handle : THandle) : Boolean;
var
    v : Integer;
begin
    v := SendMessage(Handle, BM_GETCHECK, 0, 0);
    Result := v = 1;
end;

function Ctl_SetCheck(Handle : THandle ; Checked : Boolean) : Integer;
begin
    if Checked then
        Result := SendMessage(Handle, BM_SETCHECK, 1, 0)
    else
        Result := SendMessage(Handle, BM_SETCHECK, 0, 0);
end;


end.
