unit tn_utils;

interface

uses
    tn_system, windows, shellapi, activex, shlobj, tn_classes;

type
    TByteType   =   (btSingle, btLead, btTrail);
    TQuoteType  =   (qtNone, qtSingle, qtDouble);

    PDayTable   =   ^TDayTable;
    TDayTable   =   array[1..12] of Word;

    TMethod = record
        Code, Data : Pointer;
    end;

    WordRec = packed record
        Lo, Hi: Byte;
    end;

	//֘A
    function AdjustLineBreaks(const Source : String) : String;
    function BackPos(SubStr : String ; Source : String) : Integer;
	function ByteType(const Data : String ; Index : Integer) : TByteType;
	function CompareStr(const S1, S2: string): Integer; assembler;
	procedure CopyString(Target : PChar ; const Value : String);
	function Replace(const Source, A, B : String ) : String;
    function SliceString(const Source, A, B : String ) : String;
    function Trim(const Source: String): String;
    function TrimLeft(const Source : String) : String;
    function TrimRight(const Source : String) : String;
    function SplitString(const Source, DivideBy : String) : TNStringList;
	function OmitString(const Data : String ; Size : Integer) : String;
    function StrPCopy(Dest: PChar; const Source: string): PChar;
    function StrLen(Str: PChar): Cardinal;
    function StrScan(Str: PChar; Chr: Char): PChar;
    function StrLComp(Str1, Str2: PChar; MaxLen: Cardinal): Integer;
    function StrLCopy(Dest, Source: PChar; MaxLen: Cardinal): PChar;
    function StrPosEx(var Target : PChar ; Data : PChar) : Integer;

	//ϊ
	function BytetoHex(Value : Byte) : String;
	function HextoByte(Value : String) : Byte;
	function StrtoInt(Value : String) : Integer;
    function StrtoDouble(Value : String) : Double;
	function InttoStr(Value : Integer) : String;
    function DoubletoStr(Value : Double) : String;
    function IntToHex(Value : Integer) : String;
    function LowerCase(const Source : String) : String;
    function UpperCase(const Source : String) : String;

	//t@C
	function CurrentPath : String;
    function SetPathEndsBackSlash(const Path : String) : String;
    function ExtractFileExt(FileName : String) : String;
    function ExtractFilePath(FileName : String) : String;
    function ExtractFileName(FileName : String) : String;
	function FileExists(FileName : String) : Boolean;
    function DirectoryExists(FileName: string): Boolean;
	function FileSize(FileName : String) : Int64;
    function LoadFromFile(FileName : String) : String;
    function RenameFile(const OldName, NewName: string): Boolean;
    procedure SaveToFile(const FileName, Data : String);
	function ShortPath(Path : String) : String;
    function SearchFile(Path : String) : TNStringList;
    function SearchFileCount(Path : String) : Integer;
    function SearchFolder(Path : String) : TNStringList;
    function CreateLink(TargetFile : String ; Option : String ; LinkFile : String ; IconIndex : Integer ; Descript : String) : HRESULT;
    function GetDesktopPath : String;

	//\[X
	function LoadResourceData(Types : String ; Name : String) : String;
    function LoadResourceString(ID : Integer) : String;

    //Ǘ
    procedure CopyMemory(Target : Pointer ; Value : Pointer ; Size : Integer);
    function CmpMemory(p1, p2 : Pointer ; size : Integer) : Integer; assembler;

    //_CAO
    procedure CautionDlg(Msg : String ; Title : String);
    procedure InfomationDlg(Msg : String ; Title : String);
    function YesNoDlg(Msg : String ; Title : String) : Boolean;

    //VF
    procedure OpenFile(const FileName : String);
    procedure EditFile(const FileName : String);

    //^ϊ
    function CardInt(Value : Cardinal) : Integer;
    function IntCard(Value : Integer) : Cardinal;

    //jR[h֐
    function UnicodeReplace(Source : WideString ; A : WideString ; B : WideString) : WideString;

    //`֐
    function IntString(Value : Integer ; Width : Integer) : String;
    //function wsprintf(Output : PChar; Format : PChar) : Integer; cdecl;
    function Format(const FormatStr : String ; Params : array of const) : String;
	function ExFormat(const FormatStr : String ; Params : array of const) : String;

    //t
    function IsLeapYear(Year : Integer) : Boolean;
    function SystemTimeToDateTime(Now : SYSTEMTIME) : TDateTime;
    function DateTimeToSystemTime(Now : TDateTime) : SYSTEMTIME;
    function TimeZone : TDateTime;
    function NowDateTime : TDateTime;
    function EncodeDateTime(Year : Integer ; Month : Integer ; Day : Integer ; Hour : Integer ; Minute : Integer ; Second : Integer ; MilliSecond : Integer) : TDateTime;
    function EncodeDate(Year : Integer ; Month : Integer ; Day : Integer) : TDateTime;
    function EncodeTime(Hour : Integer ; Minute : Integer ; Second : Integer ; MilliSecond : Integer) : TDateTime;
    procedure DecodeTime(Target : TDateTime ; var Hour : Integer ; var Minute : Integer ; var Second : Integer ; var MilliSecond : Integer);
    procedure DecodeDate(Target : TDateTime ; var Year : Integer ; var Month : Integer ; var Day : Integer);
    function GetDayOfWeek(Target : TDateTime) : Integer;
    function EncodeGMTString(Time : TDateTime ; Adjustment : TDateTime) : String;
    function DecodeGMTString(RFCDTime : String) : TDateTime;
    function DateTimeToStr(Time : TDateTime) : String;

    //oCif[^T[`
    function PosEx(Data : Pointer ; DataSize : Integer ; SearchData : Pointer ; SearchSize : Integer ; SameUL : Boolean) : Integer;

    //e|t@C
    function GetTempFileName : String;
    function GetTempPath(AppName : String) : String;

    //ݒ̕ۑE[h
    function GetSettings(const FileName, Section : String) : String;
    procedure SaveSettings(const FileName, Section, Data : String);

    //o[W̎擾
    function GetVersion : String;
	function GetShortVersion : String;
    function GetProductName : String;

    //擾
    function GetLanguageInfo : Word;

    //bZ[W
    procedure ProcessMessage;

    //ObZ[W

const
    CRLF    =   #13#10;
	HEXSTR  =   '0123456789ABCDEF';
    DW_MAX  =   4294967296;
    SecsPerDay = 24 * 60 * 60;
    MSecsPerDay = SecsPerDay * 1000;
    MonthDays: array [Boolean] of TDayTable =
        ((31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31),
            (31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31));
    DateDelta = 693594;
    mbSingleByte    =   btSingle;
    mbLeadByte      =   btLead;
    mbTrailByte     =   btTrail;


implementation

//

function AdjustLineBreaks(const Source : String) : String;
var
    sz : Integer;
    ln : Integer;
    r , s: PChar;
begin
    Result := '';

    if Source = '' then Exit;

    sz := Length(Source);
    SetLength(Result, sz * 2);
    r := PChar(Result);
    s := PChar(Source);
    ln := 0;

    repeat
        if s^ = #13 then
        begin
            r^ := #13;
            (r + 1)^ := #10;
            r := r + 2;
            ln := ln + 2;

            if (s + 1)^ = #10 then
            begin
                s := s + 2;
                sz := sz - 2;
            end
            else
            begin
                s := s + 1;
                sz := sz - 1;
            end
        end
        else if s^ = #10 then
        begin
            r^ := #13;
            (r + 1)^ := #10;
            r := r + 2;
            s := s + 1;
            ln := ln + 2;
            sz := sz - 1;
        end
        else
        begin
            r^ := s^;
            r := r + 1;
            s := s + 1;
            ln := ln + 1;
            sz := sz - 1;
        end;
    until sz <= 0;

    SetLength(Result, ln);
end;

function BackPos(SubStr : String ; Source : String) : Integer;
var
    n : Integer;
    m : Integer;
    p : PChar;
    s : PChar;
    sz : Integer;
    same : Boolean;
begin
    Result := 0;
    sz := Length(SubStr);

    if sz > Length(Source) then Exit;
    if (sz = 0) or (Length(Source) = 0) then Exit;

    p := PChar(Source);
    s := PChar(SubStr);

    for n := Length(Source) - Length(SubStr) downto 0 do
    begin
        same := True;
        for m := 0 to sz - 1 do
        begin
            if (p + n + m)^ = (s + m)^ then Continue;
            same := False;
            Break;
        end;

        if same then
        begin
            Result := n + 1;
            Break;
        end;
    end;
end;

function ByteType(const Data : String ; Index : Integer) : TByteType;
var
    n : Integer;
    ch : Char;
    Src : PChar;
    Size : Integer;
begin
    Result := btSingle;
    Size := Length(Data);
    if (Index < 1) or (Index > Size) then Exit;

    if IsDBCSLeadByteEx(0, Byte(Data[Index])) then
    begin
        if Index = 1 then
        begin
            Result := btLead;
            Exit;
        end;

        if Index = Size then
        begin
            Result := btTrail;
            Exit;
        end;

        if not IsDBCSLeadByteEx(0, Byte(Data[Index + 1])) then
        begin
            Result := btLead;
            Exit;
        end;
    end
    else
    begin
        if Index = 1 then Exit;

        if not IsDBCSLeadByteEx(0, Byte(Data[Index - 1])) then
            Exit;
    end;

    //肵ɂꍇAŏ猟

    Src := PChar(Data);

    for n := 0 to Index - 1 do
    begin
        ch := (Src + n)^;

        if Result = btLead then
            Result := btTrail
        else
        begin
            if IsDBCSLeadByteEx(0,Byte(ch)) then
                Result := btLead
            else
                Result := btSingle;
        end;
    end;
end;

function CompareStr(const S1, S2: string): Integer; assembler;
asm
        PUSH    ESI
        PUSH    EDI
        MOV     ESI,EAX
        MOV     EDI,EDX
        OR      EAX,EAX
        JE      @@1
        MOV     EAX,[EAX-4]
@@1:    OR      EDX,EDX
        JE      @@2
        MOV     EDX,[EDX-4]
@@2:    MOV     ECX,EAX
        CMP     ECX,EDX
        JBE     @@3
        MOV     ECX,EDX
@@3:    CMP     ECX,ECX
        REPE    CMPSB
        JE      @@4
        MOVZX   EAX,BYTE PTR [ESI-1]
        MOVZX   EDX,BYTE PTR [EDI-1]
@@4:    SUB     EAX,EDX
        POP     EDI
        POP     ESI
end;

procedure CopyString(Target : PChar ; const Value : String);
var
    n : Integer;
    src : PChar;
begin
    src := PChar(Value);
    for n := 0 to Length(Value) - 1 do
        (Target + n)^ := (src + n)^;
end;

function Replace(const Source, A, B : String) : String;
var
	l , n : Integer;
	temp : String;
begin
	l := Length(A);
	temp := Source;
	Result := '';
	n := Pos(A,temp);

	while n <> 0 do
	begin
		Result := Result + Copy(temp,1,n-1) + B;
		temp := Copy(temp, n + l, Length(temp) - n - l + 1);
		n := Pos(A,temp);
	end;

	Result := Result + temp;
end;

function SliceString(const Source, A, B : String) : String;
var
	l , n : Integer;
	temp : String;
begin
	Result := '';
	l := Length(Source);
	n := Pos(A,Source);

	if n <> 0 then
	begin
		temp := Copy(Source,n + Length(A),l-n-Length(A)+1);
		n := Pos(B,temp);
		if n<>0 then
			Result := Copy(temp,1,n-1);
	end;
end;

function Trim(const Source: String): String;
var
    ln , n : Integer;
begin
    ln := Length(Source);
    n := 1;

    while (n <= ln) and (Source[n] <= ' ') do
        n := n + 1;

    if n > ln then
        Result := ''
    else
    begin
        while Source[ln] <= ' ' do
            ln := ln - 1;
        Result := Copy(Source, n, ln - n + 1);
    end;
end;

function TrimLeft(const Source : String) : String;
var
    ln, n : Integer;
begin
    ln := Length(Source);
    n := 1;
    while (n <= ln) and (Source[n] <= ' ') do
        n := n + 1;
    Result := Copy(Source, n, Maxint);
end;

function TrimRight(const Source : String) : String;
var
    n : Integer;
begin
    n := Length(Source);
    while (n > 0) and (Source[n] <= ' ') do
        Dec(n);
    Result := Copy(Source, 1, n);
end;

{
function SplitString(const Source, DivideBy : String) : TNStringList;
var
    stemp : String;
    temp : String;
    Index : Integer;
begin
    temp := Source;
    Result := TNStringList.Create;

    while True do
    begin
        Index := Pos(DivideBy, temp);
        if Index = 0 then Break;
        //stemp := Trim(Copy(temp, 1, Index - 1));
        stemp := Copy(temp, 1, Index - 1);
        if stemp <> '' then
            Result.Add(stemp);
        temp := Copy(temp, Index + Length(DivideBy)
                            , Length(temp) - Length(DivideBy) - Index + 1);
    end;

    if temp <> '' then
        Result.Add(temp);
end;
}

function SplitString(const Source, DivideBy : String) : TNStringList;
var
    p, dp : PChar;
    ps : Integer;
    sz, dsz : Integer;
    temp : String;
begin
	p := PChar(Source);
    sz := Length(Source);
	dp := PChar(DivideBy);
    dsz := Length(DivideBy);

    Result := TNStringList.Create;

    if dsz = 0 then
    begin
    	Result.Add(Source);
    	Exit;
    end;

	while True and (sz >= dsz) do
    begin
    	ps := _Pos(p, dp, sz, dsz);

        if ps = -1 then
        begin
        	SetLength(temp, sz);
            Move(p^, PChar(temp)^, sz);
            Result.Add(temp);
			Exit;
        end;

        SetLength(temp, ps);
        Move(p^, PChar(temp)^, ps);
        Result.Add(temp);
        Inc(p, ps + dsz);
        Dec(sz, ps + dsz);
	end;

    if sz > 0 then
    begin
		SetLength(temp, sz);
		Move(p^, PChar(temp)^, sz);
		Result.Add(temp);
    end;
end;

function OmitString(const Data : String ; Size : Integer) : String;
var
	p : PChar;
    n : Integer;
    ln : Integer;
begin
	if Length(Data) <= Size then
    begin
        Result := Data;
        Exit;
	end;

	p := PChar(Data);
	n := 0;
	ln := Size - 3;
	Result := '';

	while n < ln do
	begin
		if IsDBCSLeadByte(Byte(p^)) then
		begin
			if n + 2 < ln then
			begin
				Result := Result + p^ + (p + 1)^;
                Inc(n);
                Inc(p);
            end
            else
            	Break;
        end
        else
        begin
        	if n + 1 < ln then
            	Result := Result + p^
            else
            	Break;
        end;

        Inc(n);
        Inc(p);
    end;

	Result := Result + '...';
end;

function StrPCopy(Dest: PChar; const Source: string): PChar;
begin
    lstrcpy(Dest, PChar(Source));
    Result := Dest;
end;

function StrLen(Str: PChar): Cardinal;
begin
    Result := 0;

    while True do
    begin
        if (Str + Result)^ = #0 then
            Exit
        else
            Result := Result + 1;
    end;
end;

function StrScan(Str: PChar; Chr: Char): PChar;
var
    n : Integer;
begin
    Result := nil;
    n := 0;

    while True do
    begin
        if (Str + n)^ = #0 then Exit;

        if (Str + n)^ = Chr then
        begin
            Result := Str + n;
            Break;
        end;

        n := n + 1;
    end;
end;

function StrLComp(Str1, Str2: PChar; MaxLen: Cardinal): Integer;
var
    n : Integer;
begin
    Result := 0;

    for n := 0 to MaxLen - 1 do
    begin
        if (Str1 + n)^ <> (Str2 + n)^ then
        begin
            Result := -1;
            Break;
        end;
    end;
end;

function StrLCopy(Dest, Source: PChar; MaxLen: Cardinal): PChar;
begin
    Result := Dest;
    CopyMemory(Dest, Source, MaxLen);
end;

function StrPosEx(var Target : PChar ; Data : PChar) : Integer;
var
    tar, tar2, dat : PChar;
    ch, ch2 : Char;
begin
    tar := Target;
    ch := Data^;
    Result := 0;

    if ch = #0 then
    begin
        Result := -1;
        Exit;
    end;

    while True do
    begin
        ch2 := tar^;

        if ch2 = #0 then
        begin
            Result := -1;
            Break;
        end;

        Inc(tar);

        if ch = ch2 then
        begin
            tar2 := tar;
            dat := Data;
            Inc(dat);

            while True do
            begin
                if dat^ = #0 then
                begin
                    Target := tar;
                    Dec(Target);
                    Exit;
                end;

                if tar2^ <> dat^ then Break;

                Inc(tar2);
                Inc(dat);
            end;
        end;

        Inc(Result);
    end;
end;

//ϊ

function BytetoHex(Value : Byte) : String;
var
    hword , lword : Byte;
begin
    hword := Value div 16;
    lword := Value mod 16;
    Result := HEXSTR[hword + 1] + HEXSTR[lword + 1];
end;

function HextoByte(Value : String) : Byte;
var
    h , l : Byte;
    sz : Integer;
begin
    l := 0;
    Result := 0;

    sz := Length(Value);
    if (sz > 3) or (sz = 0) then Exit;

    h := Pos(Value[1], HEXSTR);
    if h = 0 then Exit;
    h := h + 1;

    if sz = 2 then
    begin
        l := Pos(Value[2], HEXSTR);
        if l = 0 then Exit;
        l := l + 1;
    end;

    Result := h * 16 + l;
end;

function StrtoInt(Value : String) : Integer;
var
    n , code : Integer;
begin
    Val(Value,n,code);
    Result := n;
end;

function StrtoDouble(Value : String) : Double;
var
    n : Double;
    code : Integer;
begin
    Val(Value,n,code);
    Result := n;
end;

function InttoStr(Value : Integer) : String;
begin
    Str(Value, Result);
end;

function DoubletoStr(Value : Double) : String;
begin
    Str(Value : 16, Result);
end;

function IntToHex(Value : Integer) : String;
var
    Data : Cardinal;
begin
    Data := Cardinal((@Value)^);
    Result := ByteToHex(Byte(Data mod 256));
    Result := ByteToHex(Byte((Data mod 65536) div 256)) + Result;
    Result := ByteToHex(Byte((Data mod 16777216) div 65536)) + Result;
    Result := ByteToHex(Byte((Data mod 4294967296) div 16777216)) + Result;
end;

function LowerCase(const Source : String) : String;
var
    Len : Integer;
begin
    Len := Length(Source);
    SetString(Result, PChar(Source), Len);
    if Len > 0 then CharLowerBuff(Pointer(Result), Len);
end;

function UpperCase(const Source : String) : String;
var
    Len: Integer;
begin
    Len := Length(Source);
    SetString(Result, PChar(Source), Len);
    if Len > 0 then CharUpperBuff(Pointer(Result), Len);
end;

//t@C

function CurrentPath : String;
var
    p : PChar;
begin
    SetLength(Result,512);
    p := PChar(Result);
    GetCurrentDirectory(512,p);
    Result := String(p);

    if Result <> '' then
    begin
        if not ((Result[Length(Result)] = '\')
            and (ByteType(Result,Length(Result)) = btSingle)) then
        begin
            Result := Result + '\';
        end;
    end;
end;

function SetPathEndsBackSlash(const Path : String) : String;
var
	WPath : WideString;
begin
	WPath := Path;

    if WPath = '' then Exit;

    if WPath[Length(WPath)] = '\' then
    	Result := Path
    else
        Result := Path + '\';
end;

function ExtractFileExt(FileName : String) : String;
var
    n : Integer;
begin
    Result := '';

    for n := Length(FileName) downto 1 do
    begin
        if ByteType(FileName,n) = btSingle then
        begin
            if FileName[n] = '.' then
            begin
                Result := Copy(FileName,n+1,Length(FileName)-n);
                Exit;
            end;
        end;
    end;
end;

function ExtractFilePath(FileName : String) : String;
var
    n : Integer;
begin
    Result := '';

    for n := Length(FileName) downto 1 do
    begin
        if ByteType(FileName,n) = btSingle then
        begin
            if FileName[n] = '\' then
            begin
                Result := Copy(FileName,1,n);
                Exit;
            end;
        end;
    end;
end;

function ExtractFileName(FileName : String) : String;
var
    n : Integer;
begin
    Result := '';

    for n := Length(FileName) downto 1 do
    begin
        if ByteType(FileName,n) = btSingle then
        begin
            if FileName[n] = '\' then
            begin
                Result := Copy(FileName, n+1, Length(FileName) - n);
                Exit;
            end;
        end;
    end;
end;

function FileExists(FileName: string): Boolean;
var
    Code: Integer;
begin
    Code := GetFileAttributes(PChar(FileName));

    if Code = -1 then
        Result := False
    else
        Result := (FILE_ATTRIBUTE_DIRECTORY and Code) = 0;
end;

function DirectoryExists(FileName: string): Boolean;
var
    Code: Integer;
begin
    Code := GetFileAttributes(PChar(FileName));
    Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

function FileSize(FileName : String) : Int64;
var
    SearchRec : _WIN32_FIND_DATAA;
    Handle : THandle;
    temp : String;
const
    INT64MAX	=	4294967296;
begin
    Result := -1;
    Handle := FindFirstFile(PChar(ShortPath(FileName)), SearchRec);
    if Handle <> INVALID_HANDLE_VALUE then
    begin
        temp := SearchRec.cFileName;
        if (temp <> '.') and (temp <> '..')
            and ((SearchRec.dwFileAttributes mod 32) div 16 = 0 ) then
        begin
            Result := SearchRec.nFileSizeHigh * INT64MAX
					+ SearchRec.nFileSizeLow;
        end;
        FindClose(Handle);
    end;
end;

function LoadFromFile(FileName : String) : String;
var
    F : File;
    temp : String;
    n : PChar;
    l : Longint;
    ModeRestore : Byte;
begin
    {$I-}
    ModeRestore := FileMode;
    FileMode := 0;{fmOpenRead}
    Result:='';

    if FileExists(FileName) then
    begin
        AssignFile(F,FileName);
        try
            Reset(F,1);
            l := System.FileSize(F);
            SetLength(temp,l);
            n := @temp[1];
            BlockRead(F,n^,l);
        finally
            CloseFile(F);
            Result := temp;
        end;
    end;

    FileMode := ModeRestore;
    {$I+}
end;

function RenameFile(const OldName, NewName: string): Boolean;
begin
    Result := MoveFile(PChar(OldName), PChar(NewName));
end;

procedure SaveToFile(const FileName, Data : String);
var
    F : TextFile;
begin
    {$I-}
    try
        AssignFile(F, FileName);

        try
            ReWrite(F);
            Write(F,Data);
        finally
            CloseFile(F);
        end;

    except
    end;
    {$I+}
end;

function ShortPath(Path : String) : String;
var
    SPath : String;
begin
    SetLength(SPath,256);
    FillChar(PChar(SPath)^, 256, #0);
    GetShortPathName(PChar(Path),PChar(SPath),255);
    Result := PChar(SPath);
end;

function SearchFile(Path : String) : TNStringList;
var
    SearchRec : _WIN32_FIND_DATAA;
    Handle : THandle;
    temp : String;
begin
    Result := TNStringList.Create;
    Handle := FindFirstFile(PChar(ShortPath(ExtractFilePath(Path))
                                + ExtractFileName(Path)), SearchRec);
    if Handle <> INVALID_HANDLE_VALUE then
    begin
        temp := SearchRec.cFileName;
        if (temp <> '.') and (temp <> '..')
            and ((SearchRec.dwFileAttributes mod 32) div 16 = 0 ) then
                Result.Add(temp);

        while FindNextFile(Handle,SearchRec) do
        begin
            temp := SearchRec.cFileName;
            if (temp <> '.') and (temp <> '..')
                and ((SearchRec.dwFileAttributes mod 32) div 16 = 0 ) then
                    Result.Add(temp);
        end;
        FindClose(Handle);
    end;

    Result.Sort;
end;

function SearchFileCount(Path : String) : Integer;
var
    SearchRec : _WIN32_FIND_DATAA;
    Handle : THandle;
    temp : String;
begin
    Result := 0;
    Handle := FindFirstFile(PChar(ShortPath(ExtractFilePath(Path))
                                + ExtractFileName(Path)), SearchRec);
    if Handle <> INVALID_HANDLE_VALUE then
    begin
        temp := SearchRec.cFileName;

        if (temp <> '.') and (temp <> '..')
            and ((SearchRec.dwFileAttributes mod 32) div 16 = 0 ) then
                Result := Result + 1;

        while FindNextFile(Handle,SearchRec) do
        begin
            temp := SearchRec.cFileName;
            if (temp <> '.') and (temp <> '..')
                and ((SearchRec.dwFileAttributes mod 32) div 16 = 0 ) then
                    Result := Result + 1;
        end;
        FindClose(Handle);
    end;
end;

function SearchFolder(Path : String) : TNStringList;
var
    SearchRec : _WIN32_FIND_DATAA;
    Handle : THandle;
    temp : String;
begin
    Result := TNStringList.Create;
    Handle := FindFirstFile(PChar(ShortPath(Path) + '*.*'), SearchRec);
    if Handle <> INVALID_HANDLE_VALUE then
    begin
        temp := SearchRec.cFileName;
        if (temp <> '.') and (temp <> '..')
            and ((SearchRec.dwFileAttributes mod 32) div 16 <> 0 ) then
                Result.Add(temp);

        while FindNextFile(Handle,SearchRec) do
        begin
            temp := SearchRec.cFileName;
            if (temp <> '.') and (temp <> '..')
                and ((SearchRec.dwFileAttributes mod 32) div 16 <> 0 ) then
                    Result.Add(temp);
        end;
        FindClose(Handle);
    end;
    Result.Sort;
end;

function CreateLink(TargetFile : String ; Option : String ; LinkFile : String
                            ; IconIndex : Integer ; Descript : String) : HRESULT;
const
    IID_IShellLink : TGUID = SID_IShellLinkA;
    IID_IPersistFile : TGUID = '{0000010B-0000-0000-C000-000000000046}';
var
    psl : IShellLink;
    ppf : IPersistFile;
    PathLinkW : WideString;
begin
    //Microsoft's sample not contained, but in Delphi need this.
    CoInitialize(nil);

    // Get a pointer to the IShellLink interface.
    Result := CoCreateInstance(CLSID_ShellLink, nil, CLSCTX_INPROC_SERVER
                                , IID_IShellLink, psl);
    if Result = S_OK then
    begin
        // Set the path to the shortcut target, and add the
        // description.
        psl.SetPath(PChar(TargetFile));
        psl.SetWorkingDirectory(PChar(ExtractFilePath(TargetFile)));
        psl.SetIconLocation(PChar(TargetFile), IconIndex);
        psl.SetDescription(PChar(Descript));
        psl.SetArguments(PChar(Option));

        // Query IShellLink for the IPersistFile interface for saving the
        // shortcut in persistent storage.
        Result := psl.QueryInterface(IID_IPersistFile, ppf);

        if Result = S_OK then
        begin
            // Ensure that the string is ANSI.
            PathLinkW := LinkFile;

            // Save the link by calling IPersistFile::Save.
            Result := ppf.Save(PWideChar(PathLinkW), TRUE);
            //ppf._Release;
        end;

        //psl._Release;
    end;

    CoUninitialize;
end;

function GetDesktopPath : String;
var
    PID : PItemIDList;
    Path : array [1..MAX_PATH] of Char;
begin
    SHGetSpecialFolderLocation(0, CSIDL_DESKTOP, PID);
    SHGetPathFromIDList(PID, @Path);
    Result := SetPathEndsBackSlash(String(PChar(@Path)));
end;

//******************************************************************************
//\[X

function LoadResourceData(Types : String ; Name : String) : String;
var
    g : HGLOBAL;
    h : HRSRC;
    sz : Integer;
    p : PChar;
    r : PChar;
    n : Integer;
begin
    Result := '';

    if StrToInt(Name) = 0 then
    begin
    	if Types = 'HTML' then
		    h := FindResource(hInstance, PChar(Name), Pointer(23))
        else
		    h := FindResource(hInstance, PChar(Name), PChar(Types));
    end
    else
    begin
    	if Types = 'HTML' then
		    h := FindResource(hInstance, MAKEINTRESOURCE(StrToInt(Name)), Pointer(23))
        else
		    h := FindResource(hInstance, MAKEINTRESOURCE(StrToInt(Name)), PChar(Types));
    end;

    if h <> 0 then
    begin
        sz := SizeofResource(hInstance,h);
        g := LoadResource(hInstance,h);
        if g <> 0 then
        begin
            SetLength(Result,sz);
            r := PChar(Result);
            p :=LockResource(g);

            for n := 0 to sz - 1 do
                (r + n)^ := (p + n)^;
        end;
    end;
end;

function LoadResourceString(ID : Integer) : String;
var
    Buf : array [0..4095] of Char;
    Size : Integer;
begin
    FillChar(Buf, SizeOf(Buf), #0);
    Size := LoadString(hInstance, ID, @Buf, SizeOf(Buf));
    Result := Copy(Buf, 1, Size);
end;

//Ǘ

procedure CopyMemory(Target : Pointer ; Value : Pointer ; Size : Integer);
var
    t , s : PChar;
    n : Integer;
begin
    //|C^̑
    t := PChar(Target);
    s := PChar(Value);

    //|C^ẽRs[
    for n := 0 to Size - 1 do
        (t + n)^ := (s + n)^;
end;

function CmpMemory(p1, p2 : Pointer ; size : Integer) : Integer; assembler;
asm
        push    esi
        push    edi
        mov     esi, p1
        mov     edi, p2
        mov     ecx, size
        repe    cmpsb
        jne     @@1
        xor     eax, eax
        jmp     @@2
@@1:
        movzx   eax, byte ptr [esi - 1]
        movzx   edx, byte ptr [edi - 1]
        sub     eax, edx
@@2:
        pop     edi
        pop     esi
end;

//_CAO

procedure CautionDlg(Msg : String ; Title : String);
begin
    MessageBox(0,PChar(Msg),PChar(Title),MB_ICONWARNING);
end;

procedure InfomationDlg(Msg : String ; Title : String);
begin
    MessageBox(0,PChar(Msg),PChar(Title),MB_ICONASTERISK);
end;

function YesNoDlg(Msg : String ; Title : String) : Boolean;
begin
    Result := MessageBox(0,PChar(Msg),PChar(Title)
                            ,MB_ICONWARNING or MB_YESNO) = IDYES;
end;

//VF

procedure OpenFile(const FileName : String);
begin
    ShellExecute(0, 'open', PChar(FileName), nil, nil, SW_SHOW);
end;

procedure EditFile(const FileName : String);
begin
    if ShellExecute(0, 'edit', PChar(FileName), nil, nil, SW_SHOW) <= 32 then
        ShellExecute(0, 'open', PChar(FileName), nil, nil, SW_SHOW);
end;

//^ϊ

function CardInt(Value : Cardinal) : Integer;
begin
    Result := Integer(Pointer(Value));
end;

function IntCard(Value : Integer) : Cardinal;
begin
    Result := Cardinal(Pointer(Value));
end;

//jR[h֐

function UnicodeReplace(Source : WideString ; A : WideString ; B : WideString) : WideString;
var
	l , n : Integer;
	temp : String;
begin
	l := Length(A);
	temp := Source;
	Result := '';
	n := Pos(A,temp);

	while n <> 0 do
	begin
		Result := Result + Copy(temp,1,n-1) + B;
		temp := Copy(temp,n+l,Length(temp)-n-l+1);
		n := Pos(A,temp);
	end;

	Result := Result + temp;
end;

function IntString(Value : Integer ; Width : Integer) : String;
begin
    Result := IntToStr(Value);

    if Length(Result) < Width then
        Result := StringOfChar('0', Width - Length(Result)) + Result;
end;

//Format
{
function wsprintf; external 'user32.dll' name 'wsprintfA';

function wsprintf_del(Output : PChar ; Format : PChar ; Param : array of const) : Integer;
var
    i : Integer;
begin
    i := High(Param);
    asm
            mov ecx, i              //ecx <- i
            mov edx, ecx            //edx <- ecx
            inc ecx                 //ecx = ecx + 1
            shl edx, 3              //edx = edx * 8
            mov eax, Param          //eax <- Param̃|C^
            add eax, edx            //eax = eax + edx
        @1:
            push dword ptr [eax]
            sub eax,8
            loop @1
        @2:
            push dword ptr [Format]
            push dword ptr [Output]
            call wsprintf
            mov result,eax
            mov ecx,i
            add ecx,3
            shl ecx,2;
            add esp,ecx
    end;

end;

function Format(FormatStr : String ; Param : array of const) : String;
var
    sz : Integer;
begin
    if Length(FormatStr) * 10 < 256 then
        SetLength(Result, 256)
    else
        SetLength(Result, Length(FormatStr) * 10);
    sz := wsprintf_del(PChar(Result), PChar(FormatStr), Param);
    Result := Copy(Result, 1, sz);
end;
}

function Format(const FormatStr : String ; Params : array of const) : String;
begin
	Result := ExFormat(FormatStr, Params);
end;

function ExFormat(const FormatStr : String ; Params : array of const) : String;
var
	dat : TNMemory;
    p : PChar;
    n : Integer;
    ln : Integer;
    index :Integer;
    res : Integer;
	ch : Char;
    temp : String;
	buf : array [0..511] of Char;
begin
	Result := '';
	n := 0;
    index := 0;
    ln := Length(FormatStr);
    p := PChar(FormatStr);
	dat := TNMemory.Create(256);

	while n < ln do
    begin
    	ch := p^;

        if ch = '%' then
        begin
        	Inc(n);
            Inc(p);

            if index > High(Params) then
            begin
            	dat.PushChar('%');
            	Continue;
            end;

            temp := '%';

            //At@xbg܂Ŏ擾
			while n < ln do
            begin
            	temp := temp + p^;

                if ((p^ >= 'A') and (p^ <= 'Z'))
                	or ((p^ >= 'a') and (p^ <= 'z'))
                    or ((p^ <> '.') and (p^ <> '#')
                    	and (p^ <= '0') and (p^ >= '9')) then Break;

                Inc(n);
                Inc(p);
            end;

            ch := temp[Length(temp)];

            if ch = 's' then
            begin
            	if Params[index].VType = vtAnsiString then
                begin
                	temp := String(Params[index].VPChar);
                    dat.Push(PChar(temp), Length(temp));
                end
                else
                	dat.Push(PChar(temp), Length(temp));

	        	Inc(index);
            end
            else if (ch = 'd') or (ch = 'i') or (ch = 'u') or (ch = 'x')
															or (ch = 'X') then
            begin
            	if Params[index].VType = vtInteger then
                begin
                	res := wvsprintf(@buf, PChar(temp)
                    					, @(Params[index].VInteger));
                    if res > 0 then dat.Push(@buf, res);
                end
                else
                    dat.Push(PChar(temp), Length(temp));

	        	Inc(index);
            end
            else
                dat.Push(PChar(temp), Length(temp));
    	end
    	else
    		dat.PushChar(ch);

    	Inc(n);
    	Inc(p);
    end;

    dat.PushChar(#0);

    Result := String(PChar(dat.Data));
    dat.Free;
end;

//t

function IsLeapYear(Year : Integer) : Boolean;
begin
    Result := False;
    if Year mod 4 <> 0 then Exit;
    if (Year mod 100 = 0) and (Year mod 400 <> 0) then Exit;
    Result := True;
end;

function SystemTimeToDateTime(Now : SYSTEMTIME) : TDateTime;
var
    n : Integer;
    Days : PDayTable;
    BiasDay : Integer;
begin
    Result := 0;
	Days := @MonthDays[IsLeapYear(Now.wYear)];

    if (Now.wHour < 24) and (Now.wMinute < 60)
        and (Now.wSecond < 60) and (Now.wMilliseconds < 1000)
        and (Now.wYear >= 1) and (Now.wYear <= 9999)
        and (Now.wMonth >= 1) and (Now.wMonth <= 12)
        and (Now.wDay >= 1) and (Now.wDay <= Days^[Now.wMonth]) then
    begin
        BiasDay := Now.wDay;

	    for n := 1 to Now.wMonth - 1 do
		    BiasDay := BiasDay + Days^[n];

        n := Now.wYear - 1;

        Result := n * 365 + n div 4 - n div 100 + n div 400 + BiasDay - DateDelta
                    + (Now.wHour * 3600000 + Now.wMinute * 60000
                        + Now.wSecond * 1000 + Now.wMilliseconds) / MSecsPerDay;
    end;
end;

function DateTimeToSystemTime(Now : TDateTime) : SYSTEMTIME;
const
    MilliSecPerDay  =   86400000;
var
    TotalDays : Integer;
    Year : Integer;
    ThisYear : Integer;
    n : Integer;
    Days : PDayTable;
    Time : Double;
    MSec : Integer;
begin
    FillChar(Result, SizeOf(SYSTEMTIME), #0);
    TotalDays := Trunc(Now);
    if TotalDays < 0 then Exit;

    TotalDays := TotalDays - 1;
    Time := Now - TotalDays - 1;
    Year := 1900;

    while Result.wYear = 0 do
    begin
        if IsLeapYear(Year) then
            ThisYear := 366
        else
            ThisYear := 365;

        Days := @MonthDays[ThisYear = 366];

        if TotalDays <= ThisYear then
        begin
            Result.wYear := Year;

            for n := 1 to 12 do
            begin
                if TotalDays <= Days^[n] then
                begin
                    Result.wMonth := n;
                    Result.wDay := TotalDays;
                    Break;
                end
                else
                    TotalDays := TotalDays - Days^[n];
            end;
        end
        else
            TotalDays := TotalDays - ThisYear;

        Year := Year + 1;
    end;

    MSec := Trunc(Time * MilliSecPerDay);
    Result.wMilliseconds := MSec mod 1000;
    MSec := MSec div 1000;
    Result.wSecond := MSec mod 60;
    MSec := MSec div 60;
    Result.wMinute := MSec mod 60;
    MSec := MSec div 60;
    Result.wHour := MSec;
end;

function TimeZone : TDateTime;
var
    SysTime : SYSTEMTIME;
    LocalTime : SYSTEMTIME;
begin
    GetSystemTime(SysTime);
    GetLocalTime(LocalTime);
    Result := SystemTimeToDateTime(LocalTime) - SystemTimeToDateTime(SysTime);
end;

function NowDateTime : TDateTime;
var
    Local : SYSTEMTIME;
begin
    GetLocalTime(Local);
    Result := SystemTimeToDateTime(Local);
end;

function DayOfWeek(Date: TDateTime): Integer;
var
    Value : Integer;
begin
    Value := Trunc(Date - 1) div 7;
    if Value = 0 then Value := 7;
    Result := Value;
end;

function EncodeDateTime(Year : Integer ; Month : Integer ; Day : Integer ; Hour : Integer ; Minute : Integer ; Second : Integer ; MilliSecond : Integer) : TDateTime;
var
    SysTime : SYSTEMTIME;
begin
    SysTime.wYear := Year;
    SysTime.wMonth := Month;
    SysTime.wDay := Day;
    SysTime.wHour := Hour;
    SysTime.wMinute := Minute;
    SysTime.wSecond := Second;
    SysTime.wMilliseconds := MilliSecond;
    Result := SystemTimeToDateTime(SysTime);
end;

function EncodeDate(Year : Integer ; Month : Integer ; Day : Integer)
                                                                : TDateTime;
var
    SysTime : SYSTEMTIME;
begin
    SysTime.wYear := Year;
    SysTime.wMonth := Month;
    SysTime.wDay := Day;
    SysTime.wHour := 0;
    SysTime.wMinute := 0;
    SysTime.wSecond := 0;
    SysTime.wMilliseconds := 0;
    Result := SystemTimeToDateTime(SysTime);
end;

function EncodeTime(Hour : Integer ; Minute : Integer ; Second : Integer
                                        ; MilliSecond : Integer) : TDateTime;
var
    SysTime : SYSTEMTIME;
begin
    SysTime.wYear := 1899;
    SysTime.wMonth := 12;
    SysTime.wDay := 30;
    SysTime.wHour := Hour;
    SysTime.wMinute := Minute;
    SysTime.wSecond := Second;
    SysTime.wMilliseconds := MilliSecond;
    Result := SystemTimeToDateTime(SysTime);
end;

procedure DecodeTime(Target : TDateTime ; var Hour : Integer
                                    ; var Minute : Integer
                                    ; var Second : Integer
                                    ; var MilliSecond : Integer);
var
    Time : SYSTEMTIME;
begin
    Time := DateTimeToSystemTime(Target);
    Hour := Time.wHour;
    Minute := Time.wMinute;
    Second := Time.wSecond;
    MilliSecond := Time.wMilliseconds;
end;

procedure DecodeDate(Target : TDateTime ; var Year : Integer
                                    ; var Month : Integer
                                    ; var Day : Integer);
var
    Time : SYSTEMTIME;
begin
    Time := DateTimeToSystemTime(Target);
    Year := Time.wYear;
    Month := Time.wMonth;
    Day := Time.wDay;
end;

function GetDayOfWeek(Target : TDateTime) : Integer;
var
    Days : Integer;
begin
    Days := (Trunc(Target) - 1) mod 7;
    if Days = -1 then Days := 6;
    Result := Days;
end;

function EncodeGMTString(Time : TDateTime ; Adjustment : TDateTime) : String;
const
    WeekDay : array [0..6] of String
                    = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
    Month : array [1..12] of String
                    = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug'
                                                ,'Sep','Oct','Nov','Dec');
var
    year, mon, day, hour, min, sec, msec, wday : Integer;
    Adj : TDateTime;
begin
    //Fri, 19 Nov 1999 05:29:35 +0900Ƃ`̎o܂
    DecodeDate(Time, year, mon, day);
    DecodeTime(Time, hour, min, sec, msec);
    wday := GetDayOfWeek(Time);
    Result := WeekDay[wday] + ', ' + IntString(day, 2) + ' ' + Month[mon] + ' '
                + IntString(year, 4) + ' ' + IntString(hour, 2) + ':'
                + IntString(min, 2) + ':' + IntString(sec, 2);

    if Adjustment = 0 then
        Result := Result + ' GMT'
    else
    begin
        if Adjustment > 0 then
            Result := Result + ' +'
        else
            Result := Result + ' -';

        Adj := Abs(Adjustment);
        DecodeTime(Adj, hour, min, sec, msec);
        Result := Result + IntString(hour, 2) + IntString(min, 2);
    end;
end;

function DecodeGMTString(RFCDTime : String) : TDateTime;
const
    Month : array [1..12] of String
    = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

    function GetTimeAdjust(AdjustStr : String) : TDateTime;
    var
        hour , minute : Integer;
        ADJ : TDateTime;
    begin
        //
        hour := 0;
        minute := 0;


        //擾
        Result := TimeZone;

        //ݒ肩玞擾
        ADJ := 0;

        if AdjustStr = '' then Exit;

        if (AdjustStr[1] = '+') or (AdjustStr[1] = '-') then
        begin
            try
                hour := StrtoInt(Copy(AdjustStr,2,2));
                minute := StrtoInt(Copy(AdjustStr,4,2));
            finally
                ADJ := EncodeTime(hour,minute,0,0);
                if AdjustStr[1] = '+' then ADJ := -ADJ;
            end;
        end
        else if Pos('JST',UpperCase(AdjustStr)) <> 0 then
            ADJ := -EncodeDateTime(0,0,0,9,0,0,0)
        else if Pos('GMT',UpperCase(AdjustStr)) <> 0 then
            ADJ := -EncodeDateTime(0,0,0,0,0,0,0)
        else if Pos('PST',UpperCase(AdjustStr)) <> 0 then
            ADJ := EncodeDateTime(0,0,0,8,0,0,0);

        Result := Result + ADJ;
    end;

var
    l , n , year , mon , day , hour , min , sec: Integer;
    temp , stemp : String;
begin
    {$I-}
    Result := 0;
    try
	    year :=0;
	    mon := 0;
	    day := 0;
	    hour := 0;
	    min := 0;
	    sec := 0;
	    l := Pos(',',RFCDTime);
	    if l<>0 then
	        temp := Trim(Copy( RFCDTime , l + 1 , Length(RFCDTime) - l ))
	    else
	        temp := Trim(RFCDTime);
	    l := Pos( ' ' , temp );
	    stemp := Copy( temp , 1 , l - 1 );
	    if stemp <> '' then day:=StrtoInt(stemp);
	    if l<>0 then
	        temp := Trim(Copy( temp , l + 1 , Length(temp) - l ));

	    l := Pos( ' ' , temp );
	    stemp := UpperCase(Trim(Copy( temp , 1 , l - 1 )));
	    if stemp <> '' then
	    begin
	        for n:=1 to 12 do
	            if UpperCase(Month[n])=stemp then
	            begin
	                Mon:=n;
	                Break;
	            end;
	    end
	    else
	        Exit;

	    if l<>0 then
	        temp := Trim(Copy( temp , l + 1 , Length(temp) - l ));

	    l := Pos( ' ' , temp );
	    stemp := Copy( temp , 1 , l - 1 );
	    if stemp <> '' then year:=StrtoInt(stemp);
	    if l<>0 then
	        temp := Trim(Copy( temp , l + 1 , Length(temp) - l ));

	    l := Pos( ':' , temp );
	    stemp := Copy( temp , 1 , l - 1 );
	    if stemp <> '' then hour:=StrtoInt(stemp);
	    if l<>0 then
	        temp := Trim(Copy( temp , l + 1 , Length(temp) - l ));

	    l := Pos( ':' , temp );
	    stemp := Copy( temp , 1 , l - 1 );
	    if stemp <> '' then min:=StrtoInt(stemp);
	    if l<>0 then
	        temp := Trim(Copy( temp , l + 1 , Length(temp) - l ));

	    l := Pos( ' ' , temp );

	    if l<>0 then
        begin
	        stemp := Copy( temp , 1 , l - 1 );
            temp := Trim(Copy(temp,l+1,Length(temp)-l));
            l := Pos(' ',temp);
            if l <> 0 then
            begin
                temp := Trim(Copy(temp,1,l-1));
            end;
        end
	    else
        begin
	        stemp := Trim(temp);
            temp := '';
        end;

	    if stemp <> '' then sec:=StrtoInt(stemp);

	    if (year<200) and (year>40) then
	        year := year + 1900
	    else if year<40 then
	        year := year + 2000;

	    if (mon<1) or (mon>12) then Exit;
	    if (day<1) or (day>31) then Exit;
	    if (hour<0) or (hour>23) then Exit;
	    if (min<0) or (min>59) then Exit;
	    if (sec<0) or (sec>59) then Exit;

        Result := EncodeDateTime( year, mon, day, hour, min, sec, 0)
                            + GetTimeAdjust(temp);
    except
    end;
    {$I+}
end;

function DateTimeToStr(Time : TDateTime) : String;
var
    Coded : array [0..255] of Char;
    STime : SYSTEMTIME;
begin
    STime := DateTimeToSystemTime(Time);

    //t
    FillChar(Coded, SizeOf(Coded), #0);
    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, @STime
                                    , nil, @Coded, SizeOf(Coded));
    Result := String(Coded) + ' ';

    //
    FillChar(Coded, SizeOf(Coded), #0);
    GetTimeFormat(LOCALE_USER_DEFAULT, LOCALE_NOUSEROVERRIDE, @STime
                                    , nil, @Coded, SizeOf(Coded));

    Result := Result + String(Coded);
end;

//oCif[^T[`

function PosEx(Data : Pointer ; DataSize : Integer ; SearchData : Pointer ; SearchSize : Integer ; SameUL : Boolean) : Integer;

    function UpperLowerChk(a : Char ; b : Char ; SameUpperLower : Boolean) : Boolean;
    var
        new_a : Char;
        new_b : Char;
    begin
        new_a := a;
        new_b := b;

        if SameUpperLower then
        begin
            if (Byte(a) >= 97 ) and ( Byte(a) <= 122 ) then
                new_a := Char(Byte(a) - 32);

            if (Byte(b) >= 97 ) and ( Byte(b) <= 122 ) then
                new_b := Char(Byte(b) - 32);
        end;

        Result := new_a = new_b;
    end;

var
    m : Integer;
    n : Integer;
    dd : PChar;
    sd : PChar;
    fb : Char;
    found : Boolean;
begin
    Result := -1;

    dd := PChar(Data);
    sd := PChar(SearchData);
    fb := sd^;

    for n := 0 to DataSize - 1 do
    begin
        if UpperLowerChk((dd + n)^, fb, SameUL) then
        begin
            found := True;

            for m := 1 to SearchSize - 1 do
            begin
                if n + m >= DataSize then
                begin
                    found := False;
                    break;
                end;

                if not UpperLowerChk((dd + n + m)^, (sd + m)^, SameUL) then
                begin
                    found := False;
                    break;
                end;
            end;

            if found then
            begin
                Result := n;
                break;
            end;
        end;
    end;
end;

//e|t@C擾

function GetTempFileName : String;
var
    Path : array [0..511] of Char;
    Temp : array [0..511] of Char;
begin
    windows.GetTempPath(512, Path);
    windows.GetTempFileName(Path, '$TS$', 0, Temp);
    Result := Temp;
end;

function GetTempPath(AppName : String) : String;
var
    Path : array [0..511] of Char;
begin
    windows.GetTempPath(SizeOf(Path), Path);
    Result := String(PChar(@Path));

    if Result <> '' then
    begin
        if (Result[Length(Result)] <> '\')
            or (ByteType(Result, Length(Result)) <> btSingle) then
                Result := Result + '\';
    end;

    Result := Result + AppName + '\';
end;

//ݒ胍[hEۑ

function GetSettings(const FileName, Section : String) : String;
var
    F       : TextFile;
    temp , SName : String;
    SNLength : Integer;
begin
    Result:='';
    SName:=UpperCase(Section+'=');
    SNLength:=Length(SName);

    {$I-}
    try
        if FileExists(FileName)=True then
        begin
            AssignFile(F, FileName);
            Reset(F);

            try
                while not Eof(F) do
                begin
                    Readln(F,temp);
                    temp:=Trim(temp);
                    if UpperCase(Copy(temp,1,SNLength))=SName then
                    begin
                        Result:=Copy(temp , SNLength + 1 , Length(temp) - SNLength);
                        break;
                    end;
                end;
            except
            end;

            CloseFile(F);
        end;
    except
    end;
    {$I+}
end;

procedure SaveSettings(const FileName, Section, Data : String);
var
    F : File;
    G : TextFile;
    temp , utemp : String;
    fsize , start : Longint;
    p : PChar;
begin
    {$I-}
    if not FileExists(FileName) then
    begin
        AssignFile(G,FileName);
        ReWrite(G);
        try
            Writeln(G , '[Grape Software Products]');
            Writeln(G , Section + '=' + Data);
        finally
            CloseFile(G);
        end;
    end
    else
    begin
        AssignFile(F,FileName);
        Reset(F,1);

        try
            fsize := System.FileSize(F);
            SetLength(temp,fsize);
            p := @temp[1];
            BlockRead( F , p^ , fsize );
        finally
            CloseFile(F);
            utemp := UpperCase(temp);
            start := Pos(CRLF + UpperCase(Section) + '=' , utemp);

            if start <> 0 then
            begin
                utemp := Copy( temp , start + 2 , Length(temp) - start - 1);
                temp := Copy( temp , 1 , start - 1 );
                start := Pos( CRLF , utemp );
                if start <> 0 then
                    temp := temp + Copy( utemp , start , Length(utemp) - start + 1);
            end;

            temp := Trim(temp);
            AssignFile(G,FileName);
            ReWrite(G);
            try
                Writeln(G , temp);
                Writeln(G , Section + '=' + Data);
            finally
                CloseFile(G);
            end;

        end;
    end;
    {$I+}
end;

//******************************************************************************

function GetVersion : String;
var
    Size : Integer;
    Dummy : Cardinal;
    InfoSize : Cardinal;
    Buf : Pointer;
    Info : Pointer;
    Locale : String;
    Section : String;
begin
    Result := '';
    Dummy := 0;
    Size := GetFileVersionInfoSize(PChar(ParamStr(0)), Dummy);
    if Size = 0 then Exit;

    //m
    GetMem(Buf, Size);

    try
        GetFileVersionInfo(PChar(ParamStr(0)), 0, Size, Buf);
        VerQueryValue(Buf, PChar('\VarFileInfo\Translation'), Info, InfoSize);

        if InfoSize > 0 then
            Locale := IntToHex(Integer(Info^))
        else
        begin
            FreeMem(Buf);
            Exit;
        end;

        Locale := Copy(Locale, 5, 4) + Copy(Locale, 1, 4);
        Section := '\StringFileInfo\' + Locale + '\FileVersion';
        VerQueryValue(Buf, PChar(Section), Info, InfoSize);
        Result := String(PChar(Info));
    finally
        FreeMem(Buf);
    end;
end;

function GetShortVersion : String;
var
	temp : String;
    major : String;
    minor : String;
    release : String;
    ps : Integer;
begin
	temp := GetVersion;
	ps := Pos('.', temp);
    major := Copy(temp, 1, ps - 1);
    temp := Copy(temp, ps + 1, Length(temp) - ps);
    ps := Pos('.', temp);
    minor := Copy(temp, 1, ps - 1);
    temp := Copy(temp, ps + 1, Length(temp) - ps);
    ps := Pos('.', temp);
    release := Copy(temp, 1, ps - 1);
    Result := major + '.' + minor + release;
end;

function GetProductName : String;
var
    Size : Integer;
    Dummy : Cardinal;
    InfoSize : Cardinal;
    Buf : Pointer;
    Info : Pointer;
    Locale : String;
    Section : String;
begin
    Result := '';
    Dummy := 0;
    Size := GetFileVersionInfoSize(PChar(ParamStr(0)), Dummy);
    if Size = 0 then Exit;

    //m
    GetMem(Buf, Size);

    try
        GetFileVersionInfo(PChar(ParamStr(0)), 0, Size, Buf);
        VerQueryValue(Buf, PChar('\VarFileInfo\Translation'), Info, InfoSize);

        if InfoSize > 0 then
            Locale := IntToHex(Integer(Info^))
        else
        begin
            FreeMem(Buf);
            Exit;
        end;

        Locale := Copy(Locale, 5, 4) + Copy(Locale, 1, 4);
        Section := '\StringFileInfo\' + Locale + '\ProductName';
        VerQueryValue(Buf, PChar(Section), Info, InfoSize);
        Result := String(PChar(Info));
    finally
        FreeMem(Buf);
    end;
end;

function GetLanguageInfo : Word;
var
    Locale : array[0..127] of Char;
    Lang: Word;
begin
    FillChar(Locale, SizeOf(Locale), #0);
    GetLocaleInfo(GetUserDefaultLCID, LOCALE_ILANGUAGE, @Locale, SizeOf(Locale));
    Lang := StrToInt('$' + Locale);
    Result := WordRec(Lang).Lo;
end;

//******************************************************************************

procedure ProcessMessage;
var
    msg : TMsg;
begin
    while PeekMessage(msg,0,0,0,PM_REMOVE) do
    begin
        TranslateMessage(msg);
        DispatchMessage(msg);
    end;
end;

//******************************************************************************

end.
