/*
 * @(#)InitPackage.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons ;

import org.maachang.commons.resource.cache.CacheManager;
import org.maachang.commons.sys.GetEnvironment;
import org.maachang.commons.sys.Manager;
import org.maachang.commons.sys.NamingManager;
import org.maachang.commons.thread.ThreadManager;


/**
 * このパッケージを利用する場合に不可欠な初期化処理.
 * <BR><BR>
 * このパッケージを利用する場合に不可欠な初期化処理を行います.<BR>
 * また、スレッド処理を利用しない場合は呼び出す必要はありません.
 *
 * @version 1.00, 2006/02/05
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public class InitPackage
{
    
    /**
     * 同期.
     */
    private static Object SYNC = new Object() ;
    
    /**
     * 実行フラグ.
     */
    private static volatile boolean initFlag = false ;
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を実施します.
     */
    public void init() {
        
        synchronized( SYNC ) {
            if( initFlag == false ) {
                
                /////////////////////////////////
                // JRcCommonsコアパッケージ起動.
                /////////////////////////////////
                try{
                    ThreadManager.getInstance().initManager() ;
                }catch( Exception e ){
                }
                try{
                    GetEnvironment.getInstance().create() ;
                }catch( Exception e ){
                }
                try{
                    Manager.getInstance().init() ;
                }catch( Exception e ){
                }
                
                //////////////////////////
                // 基本常駐パッケージ起動.
                //////////////////////////
                
                // ネーミングマネージャ.
                try {
                    new NamingManager().init() ;
                } catch( Exception e ) {
                }
                
                // キャッシュマネージャ.
                try {
                    new CacheManager().init() ;
                } catch( Exception e ) {
                }
                
                initFlag = true ;
            }
        }
    }
    
    /**
     * 終了処理.
     * <BR><BR>
     * 終了処理を実施します.
     */
    public void destroy() {
        
        synchronized( SYNC ) {
            if( initFlag == true ) {
                
                //////////////////////////
                // 基本常駐パッケージ破棄.
                //////////////////////////
                
                // キャッシュマネージャ.
                new CacheManager().destroy() ;
                
                // ネーミングマネージャ.
                new NamingManager().destroy() ;
                
                /////////////////////////////////
                // JRcCommonsコアパッケージ破棄.
                /////////////////////////////////
                Manager.getInstance().destroy() ;
                ThreadManager.getInstance().destroyManager() ;
                GetEnvironment.getInstance().clear() ;
                
                initFlag = true ;
            }
        }
        
    }
    
}

