/*
 * @(#)CommonConfig.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.conf;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.util.read.ReadElement;


/**
 * コンフィグ情報インターフェイス.
 * <BR><BR>
 * 指定されたコンフィグ情報のインターフェイスを提供します.
 *
 * @version 1.00, 2004/06/06
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public interface CommonConfig
{
    
    /**
     * 情報の取得.
     * <BR><BR>
     * 対象の情報を取得します.
     * <BR>
     * @param section 取得対象のセクション名を指定します.
     * @param key 取得対象のキー名を設定します.
     * @param no 取得対象の項番を設定します.
     * @return ReadElement 取得された内容が返されます.
     * @exception InputException 入力例外.
     */
    public ReadElement get( String section,String key,int no )
        throws InputException ;
    
    /**
     * 情報の取得.
     * <BR><BR>
     * 対象の情報を取得します.
     * <BR>
     * @param out 取得された内容が返されます.
     * @param section 取得対象のセクション名を指定します.
     * @param key 取得対象のキー名を設定します.
     * @param no 取得対象の項番を設定します.
     * @exception InputException 入力例外.
     */
    public void get( ReadElement out,String section,String key,int no )
        throws InputException ;
    
    /**
     * 情報の取得.
     * <BR><BR>
     * 対象の情報を取得します.
     * <BR>
     * @param section 取得対象のセクション名を指定します.
     * @param key 取得対象のキー名を設定します.
     * @return ReadElement 取得された内容が返されます.
     * @exception InputException 入力例外.
     */
    public ReadElement get( String section,String key )
        throws InputException ;
    
    /**
     * 情報の取得.
     * <BR><BR>
     * 対象の情報を取得します.
     * <BR>
     * @param out 取得された内容が返されます.
     * @param section 取得対象のセクション名を指定します.
     * @param key 取得対象のキー名を設定します.
     * @exception InputException 入力例外.
     */
    public void get( ReadElement out,String section,String key )
        throws InputException ;
    
    /**
     * 対象キー名に対する情報数を取得.
     * <BR><BR>
     * 対象キー名に対する情報数を取得します.
     * <BR>
     * @param section 対象のセクション名を指定します.
     * @param key 対象のキー名を指定します.
     * @return int 格納情報数が返されます.
     * @exception InputException 入力例外.
     */
    public int getElement( String section,String key )
        throws InputException ;
    
    /**
     * 対象セクション名に対するキー名群を取得.
     * <BR><BR>
     * 対象セクション名に対するキー名群を取得します.
     * <BR>
     * @param section 対象のセクション名を指定します.
     * @return String[] 対象のキー名群が返されます.<BR>
     *                  情報が存在しない場合[null]が返されます.
     * @exception InputException 入力例外.
     */
    public String[] getNames( String section )
        throws InputException ;
    
    /**
     * 対象セクション名に対するキー数を取得.
     * <BR><BR>
     * 対象セクション名に対するキー数を取得します.
     * <BR>
     * @param section 対象のセクション名を指定します.
     * @return int 対象のキー名群が返されます.
     * @exception InputException 入力例外.
     */
    public int getElement( String section )
        throws InputException ;
    
    /**
     * セクション名群の取得.
     * <BR><BR>
     * セクション名群を取得します.
     * <BR>
     * @return String[] セクション名群が返されます.<BR>
     *                  情報が存在しない場合[null]が返されます.
     */
    public String[] getNames() ;
    
    /**
     * セクション数の取得.
     * <BR><BR>
     * セクション名群を取得します.
     * <BR>
     * @return int セクション名数が返されます.<BR>
     *             情報が存在しない場合[0]が返されます.
     */
    public int getElement() ;
    
    /**
     * 読み込みキャラクタセットを取得.
     * <BR><BR>
     * 読み込み対象のキャラクタセット情報が返されます.
     * <BR>
     * @return String 読み込みキャラクタセットが返されます.<BR>
     *                情報が存在しない場合[null]が返されます.
     */
    public String getCharset() ;
    
    /**
     * 読み込みファイル名を取得.
     * <BR><BR>
     * 読み込まれた対象ファイル名が返されます.
     * <BR>
     * @return String ファイル名が返されます.<BR>
     *                情報が存在しない場合[null]が返されます.
     */
    public String getFilename() ;
    
    /**
     * 対象セクション名存在チェック.
     * <BR><BR>
     * 対象セクション名存在チェックを行います.
     * <BR>
     * @param name チェック対象のセクション名を指定します.
     * @return boolean 情報存在結果が返されます.<BR>
     *                 [true]が返された場合情報は存在します.<BR>
     *                 [false]が返された場合情報は存在しません.
     */
    public boolean isSection( String name ) ;
    
    /**
     * 対象キー名存在チェック.
     * <BR><BR>
     * 対象キー名存在チェックを行います.
     * <BR>
     * @param section 対象のセクション名を指定します.
     * @param name チェック対象のキー名を指定します.
     * @return boolean 情報存在結果が返されます.<BR>
     *                 [true]が返された場合情報は存在します.<BR>
     *                 [false]が返された場合情報は存在しません.
     */
    public boolean isKey( String section,String name ) ;
    
}
