/*
 * @(#)CodeCommon.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.conv;

/**
 * 暗号基本処理.
 *
 * @version 1.00, 2005/04/21
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
class CodeCommon
{
    
    /**
     * 指定バイト情報のフリップ処理.
     * <BR><BR>
     * 指定バイト情報に対してステップ番号に対するフリップ処理を行います.
     * <BR>
     * @param pause フリップ対象の指定バイト情報を設定します.
     * @param step フリップに対するステップコードを指定します.
     * @return byte フリップされた情報が格納されます.
     */
    protected static final int flipCode( int pause,int step )
    {
        int ret ;
        
        step = ( step & 0x00000007 ) ;
        
        switch( step ){
            case 1:
                ret = (
                    ( ( ( pause & 0x00000003 ) << 6 ) & 0x000000c0 ) |
                    ( ( ( pause & 0x000000fc ) >> 2 ) & 0x0000003f )
                ) ;
                break ;
            case 2:
                ret = (
                    ( ( ( pause & 0x0000003f ) << 2 ) & 0x000000fc ) |
                    ( ( ( pause & 0x000000c0 ) >> 6 ) & 0x00000003 )
                ) ;
                break ;
            case 3:
                ret = (
                    ( ( ( pause & 0x00000001 ) << 7 ) & 0x00000080 ) |
                    ( ( ( pause & 0x000000fe ) >> 1 ) & 0x0000007f )
                ) ;
                break ;
            case 4:
                ret = (
                    ( ( ( pause & 0x0000000f ) << 4 ) & 0x000000f0 ) |
                    ( ( ( pause & 0x000000f0 ) >> 4 ) & 0x0000000f )
                ) ;
                break ;
            case 5:
                ret = (
                    ( ( ( pause & 0x0000007f ) << 1 ) & 0x000000fe ) |
                    ( ( ( pause & 0x00000080 ) >> 7 ) & 0x00000001 )
                ) ;
                break ;
            case 6:
                ret = (
                    ( ( ( pause & 0x00000007 ) << 5 ) & 0x000000e0 ) |
                    ( ( ( pause & 0x000000f8 ) >> 3 ) & 0x0000001f )
                ) ;
                break ;
            case 7:
                ret = (
                    ( ( ( pause & 0x0000001f ) << 3 ) & 0x000000f8 ) |
                    ( ( ( pause & 0x000000e0 ) >> 5 ) & 0x00000007 )
                ) ;
                break ;
            default :
                ret = pause ;
                break ;
        }
        return ret ;
    }
    
    /**
     * 対象の４バイトコード(0x3f->6Bit)に対して、ビット配列を逆転.
     * <BR><BR>
     * 対象の４バイトコード(0x3f->6Bit)に対して、ビット配列を逆転させます.
     * <BR>
     * @param byte4 対象の条件を設定します.
     * @return int 変換された条件が返されます.
     */
    protected static final int flipBit0x3f( int byte4 )
    {
        return (
            ( byte4 & 0x00000040 ) |
            ( byte4 & 0x00000080 ) |
            ( ( ( byte4 & 0x00000001 ) << 5 ) & 0x00000020 ) |
            ( ( ( byte4 & 0x00000002 ) << 3 ) & 0x00000010 ) |
            ( ( ( byte4 & 0x00000004 ) << 1 ) & 0x00000008 ) |
            ( ( ( byte4 & 0x00000008 ) >> 1 ) & 0x00000004 ) |
            ( ( ( byte4 & 0x00000010 ) >> 3 ) & 0x00000002 ) |
            ( ( ( byte4 & 0x00000020 ) >> 5 ) & 0x00000001 )
        ) ;
    }
    
    /**
     * 対象の４バイトコード(0x3c->8Bit)に対して、ビット配列を逆転.
     * <BR><BR>
     * 対象の４バイトコード(0x3c->8Bit)に対して、ビット配列を逆転させます.
     * <BR>
     * @param byte4 対象の条件を設定します.
     * @return int 変換された条件が返されます.
     */
    protected static final int flipBit0x3c( int byte4 )
    {
        return (
            ( byte4 & 0x00000001 ) |
            ( byte4 & 0x00000002 ) |
            ( byte4 & 0x00000040 ) |
            ( byte4 & 0x00000080 ) |
            ( ( ( byte4 & 0x00000004 ) << 3 ) & 0x00000020 ) |
            ( ( ( byte4 & 0x00000008 ) << 1 ) & 0x00000010 ) |
            ( ( ( byte4 & 0x00000010 ) >> 1 ) & 0x00000008 ) |
            ( ( ( byte4 & 0x00000020 ) >> 3 ) & 0x00000004 )
        ) ;
    }
    
    /**
     * 対象の４バイトコード(0xc3->8Bit)に対して、ビット配列を逆転.
     * <BR><BR>
     * 対象の４バイトコード(0xc3->8Bit)に対して、ビット配列を逆転させます.
     * <BR>
     * @param byte4 対象の条件を設定します.
     * @return int 変換された条件が返されます.
     */
    protected static final int flipBit0xc3( int byte4 )
    {
        return (
            ( byte4 & 0x00000004 ) |
            ( byte4 & 0x00000008 ) |
            ( byte4 & 0x00000010 ) |
            ( byte4 & 0x00000020 ) |
            ( ( ( byte4 & 0x00000001 ) << 7 ) & 0x00000080 ) |
            ( ( ( byte4 & 0x00000002 ) << 5 ) & 0x00000040 ) |
            ( ( ( byte4 & 0x00000040 ) >> 5 ) & 0x00000002 ) |
            ( ( ( byte4 & 0x00000080 ) >> 7 ) & 0x00000001 )
        ) ;
    }
    
    /**
     * 対象の４バイトコード(0xff->8Bit)に対して、ビット配列を逆転.
     * <BR><BR>
     * 対象の４バイトコード(0xff->8Bit)に対して、ビット配列を逆転させます.
     * <BR>
     * @param byte4 対象の条件を設定します.
     * @return int 変換された条件が返されます.
     */
    protected static final int flipBit0xff( int byte4 )
    {
        return (
            ( ( ( byte4 & 0x00000001 ) << 7 ) & 0x00000080 ) |
            ( ( ( byte4 & 0x00000002 ) << 5 ) & 0x00000040 ) |
            ( ( ( byte4 & 0x00000004 ) << 3 ) & 0x00000020 ) |
            ( ( ( byte4 & 0x00000008 ) << 1 ) & 0x00000010 ) |
            ( ( ( byte4 & 0x00000010 ) >> 1 ) & 0x00000008 ) |
            ( ( ( byte4 & 0x00000020 ) >> 3 ) & 0x00000004 ) |
            ( ( ( byte4 & 0x00000040 ) >> 5 ) & 0x00000002 ) |
            ( ( ( byte4 & 0x00000080 ) >> 7 ) & 0x00000001 )
        ) ;
    }
    
}

