/*
 * @(#)BaseDef.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.def;

import java.util.ArrayList;

import org.maachang.commons.util.UtilCom;


/**
 * 基本定義.
 * <BR><BR>
 * JRcCommonsで利用する基本情報を定義します.
 *  
 * @version 2003/10/24
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class BaseDef
{
    
    /**
     * project名.
     */
    public static final String PROJECT_NAME = MaachangCommonDef.getInstance().getName() ;
    
    /**
     * project バージョン.
     */
    public static final String PROJECT_VERSION = MaachangCommonDef.getInstance().getVersion() ;
    
    /**
     * project アップデート日付.
     */
    public static final String PROJECT_UPDATE = MaachangCommonDef.getInstance().getLastUpdate() ;
    
    /**
     * project シンボル情報.
     */
    public static final String PROJECT_SYMBOL = MaachangCommonDef.getInstance().getMaker() ;
    
    
    
    /**
     * javaコマンド.
     */
    public static final String JAVA_CMD = "java" ;
    
    /**
     * javaコマンド格納ディレクトリ名.
     */
    private static final String JAVA_BIN_DIR = "bin" ;
    
    /**
     * javaクラスパスコマンド.
     */
    public static final String JAVA_CLASSPATH_CMD = "-classpath" ;
    
    /**
     * １キロバイト.
     */
    public static final int K_BYTE = 0x00000400 ;
    
    /**
     * １メガバイト.
     */
    public static final int MEGA_BYTE = 0x00100000 ;
    
    /**
     * １ギガバイト.
     */
    public static final int GIGA_BYTE = 0x40000000 ;
    
    
    /**
     * ISO 8859-1 ラテンアルファベット No1.
     */
    public static final String ISO_8859_1 = "ISO8859_1" ;
    
    /**
     * 8ビット Unicode Transformation Format.
     */
    public static final String UTF8 = "UTF8" ;
    
    /**
     * 16ビット Unicode Transformation Format、
     * 必須の初期バイト順マークによって指定されたバイト順.
     */
    public static final String UTF16 = "UTF16" ;
    
    /**
     * 32ビット Unicode Transformation Format、
     * 必須の初期バイト順マークによって指定されたバイト順.
     */
    public static final String UTF32 = "UTF32" ;
    
    /**
     * American Standard Code for Information Interchange.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String ASCII = "ASCII" ;
    
    /**
     * ISO 2022 JP.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String JIS = "ISO2022JP" ;
    
    /**
     * JIS X 0201、0208、0212、EUC エンコーディング、日本語.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String EUC = "EUC_JP" ;
    
    /**
     * Shift-JIS、日本語.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String SJIS = "Shift_JIS" ;
    
    /**
     * Windows 日本語-NS932.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String MS932 = "MS932" ;
    
    /**
     * Windows 日本語-Win31J.
     * <RB><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String WIN31J = "Windows-31J" ;
    
    /**
     * Shift-JIS、EUC-JP、ISO 2022 JP の検出および変換.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String AUTO_DETECT = "JISAutoDetect" ;
    
    
    
    /**
     * 基本データ変換コード.
     */
    public static final String DEF_CHARSET = UTF8 ;
    
    /**
     * 文字スペース.
     */
    public static final String SPACE = " " ;
    
    /**
     * 文字タブ.
     */
    public static final String TAB = "\t" ;
    
    /**
     * 全角スペース.
     */
    public static final String SPACE2 = "　" ;
    
    /**
     * シングルコーテーション.
     */
    public static final String SINGLE_COAT = "'" ;
    
    /**
     * ダブルコーテーション.
     */
    public static final String DOUBLE_COAT = "\"" ;
    
    /**
     * ￥コード.
     */
    public static final String YEN_CODE = "\\" ;
    
    /**
     * バックスラッシュ.
     */
    public static final String SLASH_CODE = "/" ;
    
    /**
     * ドット.
     */
    public static final String DOT = "." ;
    
    /**
     * イコール.
     */
    public static final String EQUAL = "=" ;
    
    /**
     * 改行コード : Unix.
     */
    public static final String ENTER_UNIX = "\n" ;
    
    /**
     * 改行コード : Windows.
     */
    public static final String ENTER_WINDOWS = "\r\n" ;
    
    /**
     * 改行コード : Macintosh.
     */
    public static final String ENTER_MACINTOSH = "\r" ;
    
    /**
     * Boolean判定 : true.
     */
    public static final String BOOLEAN_TRUE = "true" ;
    
    /**
     * Boolean判定 : false.
     */
    public static final String BOOLEAN_FALSE = "false" ;
    
    /**
     * ini内キャラクタセット値.
     * <BR><BR>
     * ini内に設定されているキャラクタセットキー名です
     */
    public static final String INI_CHARSET = "charset" ;
    
    
    /**
     * ブートJAVAコマンドディレクトリ名.
     */
    public static final String BOOT_LIB_PATH = System.getProperty( "sun.boot.library.path" ) ;
    
    /**
     * ファイル区切り情報.
     */
    public static final String FILE_SEPARATOR = System.getProperty( "file.separator" ) ;
    
    /**
     * パス区切り情報.
     */
    public static final String PATH_SEPARATOR = System.getProperty( "path.separator" ) ;
    
    /**
     * 改行情報.
     */
    public static final String ENTER_SEPARATOR = System.getProperty( "line.separator" ) ;
    
    /**
     * 自OS文字コード.
     */
    public static final String THIS_CHARSET = System.getProperty( "file.encoding" ) ;
    
    /**
     * ログイン(JVM起動)ユーザ名.
     */
    public static final String LOGIN_USERNAME = System.getProperty( "user.name" ) ;
    
    /**
     * javaバージョン.
     */
    public static final String JAVA_VERSION = System.getProperty( "java.version" ) ;
    
    /**
     * javaVM名.
     */
    public static final String JAVA_VM_NAME = System.getProperty( "java.vm.name" ) ;
    
    /**
     * Javaディレクトリ.
     */
    public static final String JAVA_DIR = System.getProperty( "java.ext.dirs" ) ;
    
    /**
     * クラスパス情報.
     */
    public static final String JAVA_CLASSPATH = System.getProperty( "java.class.path" ) ;
    
    /**
     * OS名.
     */
    public static final String OS_NAME = System.getProperty( "os.name" ) ;
    
    /**
     * OSアーキテクチャー名.
     */
    public static final String OS_ARCH = System.getProperty( "os.arch" ) ;
    
    /**
     * OSバージョン名.
     */
    public static final String OS_VERSION = System.getProperty( "os.version" ) ;
    
    /**
     * ユーザホームディレクトリ.
     */
    public static final String USER_HOME = System.getProperty( "user.home" ) ;
    
    /**
     * 起動カレントディレクトリ.
     */
    public static final String CURRENT_DIR = System.getProperty( "user.dir" ) ;
    
    
    
    /**
     * シングルトン.
     */
    private static final BaseDef SNGL = new BaseDef() ;
    
    /**
     * コンストラクタ.
     */
    private BaseDef()
    {
        
    }
    
    
    /**
     * シングルトンオブジェクトを取得.
     * <BR><BR>
     * シングルトンオブジェクト情報を取得します.
     * <BR>
     * @return BaseDef シングルトンオブジェクトが返されます.
     */
    public static final BaseDef getInstance()
    {
        return BaseDef.SNGL ;
    }
    
    /**
     * java実行コマンドを取得.
     * <BR><BR>
     * 対象のJava実行コマンドを取得します.
     * <BR>
     * @param classPath 対象のクラスパス名を設定します.
     * @param execObj コマンド実行オブジェクト名(パッケージ名含む)を設定します.
     * @return String[] java実行コマンドが返されます.
     */
    public final String[] getExecJavaCommand( String[] classPath,String execObj )
    {
        String[] ret = null ;
        
        try{
            ret = this.getExecJavaCommand( null,classPath,execObj ) ;
        }catch( Exception t ){
            ret = null ;
        }
        
        return ret ;
    }
    
    /**
     * java実行コマンドを取得.
     * <BR><BR>
     * 対象のJava実行コマンドを取得します.
     * <BR>
     * @param javahome 実施対象のJavaディレクトリ(binディレクトリ含まない)を設定します.
     * @param classPath 対象のクラスパス名を設定します.
     * @param execObj コマンド実行オブジェクト名(パッケージ名含む)を設定します.
     * @return String[] java実行コマンドが返されます.
     */
    public final String[] getExecJavaCommand( String javahome,String[] classPath,String execObj )
    {
        int i,j ;
        int len ;
        int lenJ ;
        
        String[] ret = null ;
        StringBuffer buf = null ;
        ArrayList lst = null ;
        
        if( execObj == null ){
            return null ;
        }
        
        buf = new StringBuffer() ;
        
        try{
            
            if( ( lst = UtilCom.getClassPath() ) != null ){
                len = lst.size() ;
            }
            else{
                len = 0 ;
            }
            
            if( classPath != null ){
                lenJ = classPath.length ;
            }
            else{
                lenJ = 0 ;
            }
            
            
            if( javahome == null ){
                buf.append( BaseDef.BOOT_LIB_PATH ) ;
            }
            else{
                buf.append( javahome ) ;
                buf.append( BaseDef.FILE_SEPARATOR ) ;
                buf.append( BaseDef.JAVA_BIN_DIR ) ;
            }
            
            buf.append( BaseDef.FILE_SEPARATOR ) ;
            buf.append( BaseDef.JAVA_CMD ) ;
            buf.append( " " ) ;
            buf.append( BaseDef.JAVA_CLASSPATH_CMD ) ;
            buf.append( " " ) ;
            
            for( i = 0 ; i < len ; i ++ ){
                
                buf.append( ( String )lst.get( i ) ) ;
                buf.append( BaseDef.PATH_SEPARATOR ) ;
                
            }
            
            for( j = 0 ; j < lenJ ; j ++ ){
                
                buf.append( classPath[ j ] ) ;
                buf.append( BaseDef.PATH_SEPARATOR ) ;
                
            }
            
            buf.append( " " ) ;
            buf.append( execObj ) ;
            
            if( lst != null ){
                lst.clear() ;
                lst = null ;
            }
            
            lst = UtilCom.pauseString( buf.toString()," " ) ;
            
            if( lst != null && ( len = lst.size() ) > 0 ){
                
                ret = new String[ len ] ;
                for( i = 0 ; i < len ; i ++ ){
                    
                    ret[ i ] = ( String )lst.get( i ) ;
                    
                }
                
            }
            else{
                ret = null ;
            }
            
        }catch( Exception t ){
            ret = null ;
        }finally{
            
            if( lst != null ){
                lst.clear() ;
            }
            
            buf = null ;
            lst = null ;
            
        }
        
        return ret ;
    }
    
}

