/*
 * @(#)FileEncode.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.io.env.EnvFile;
import org.maachang.commons.io.env.EnvFileInputStream;
import org.maachang.commons.io.env.EnvFileOutputStream;


/**
 * 指定ファイルエンコーディング.
 * <BR><BR>
 * 指定されたファイルをエンコーディングします.
 *  
 * @version 1.0.0 2003/10/27
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class FileEncode
{
    /**
     * オブジェクト情報.
     */
    private static final FileEncode m_obj = new FileEncode() ;
    
    /**
     * コンストラクタ.
     */
    private FileEncode()
    {
        
    }
    
    /**
     * オブジェクト情報取得.
     * <BR><BR>
     * オブジェクト情報を取得します.
     * <BR>
     * @return FileEncode オブジェクト情報が返されます.
     */
    public static final FileEncode getInstance()
    {
        return m_obj ;
    }
    
    /**
     * エンコード処理.
     * <BR><BR>
     * エンコード処理を実施します.
     * <BR>
     * @param fileName エンコード対象のファイル名を指定します.
     * @param decode 指定ファイル名に対する文字コードを指定します.
     * @param encode 出力を行う場合のデコードコーディックを指定します.
     * @exception InputException 入力例外.
     * @exception FileAccessException ファイルアクセス例外.
     */
    public final void encodeFile( String fileName,String decode,String encode )
        throws InputException,FileAccessException
    {
        boolean flg = false ;
        
        String fileName2 = null ;
        BufferedReader in = null ;
        BufferedWriter out = null ;
        String tmp = null ;
        
        if( fileName == null || decode == null || encode == null ){
            throw new InputException( "引数が不正です" ) ;
        }
        
        fileName2 = fileName + "tmp" ;
        
        try{
            
            in = new BufferedReader(
                new InputStreamReader(
                    new EnvFileInputStream( fileName ),
                    decode
                )
            ) ;
            
            out = new BufferedWriter(
                new OutputStreamWriter(
                    new EnvFileOutputStream( fileName2 ),
                    encode
                )
            ) ;
            
            for( ; ( tmp = in.readLine() ) != null ; ){
                
                out.write( tmp ) ;
                out.newLine() ;
                
            }
            
            flg = true ;
            
        }catch( IOException io ){
            
            throw new FileAccessException( io ) ;
            
        }finally{
            
            EnvFile src = null ;
            EnvFile dest = null ;
            
            try{
                in.close() ;
            }catch( Exception t ){
            }
            
            try{
                out.flush() ;
            }catch( Exception t ){
            }
            
            try{
                out.close() ;
            }catch( Exception t ){
            }
            
            in = null ;
            out = null ;
            
            try{
                
                if( flg == true ){
                    
                    src = new EnvFile( fileName2 ) ;
                    dest = new EnvFile( fileName ) ;
                    
                    dest.delete() ;
                    src.renameTo(dest) ;
                }
                
            }catch( Exception t3 ){
            }finally{
                
                src = null ;
                dest = null ;
                
            }
            
            tmp = null ;
            
        }
    }
    
    
}

