/*
 * @(#)NotFileException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.io;

import org.maachang.commons.exception.AccessException;
import org.maachang.commons.exception.BaseException;

/**
 * 指定ファイルなし例外.
 * <BR><BR>
 * 指定された対象のファイルが存在しない場合発生します.
 *  
 * @version 1.0.0 2003/11/09
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotFileException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public NotFileException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotFileException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotFileException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotFileException(String message)
    {
        super(message) ;
    }
}
