/*
 * @(#)EnvRandomAccessFile.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.io.env;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import org.maachang.commons.io.IODef;


/**
 * 環境変数対応版[java.io.RandomAccessFile]オブジェクト.
 * <BR><BR>
 * [java.io.RandomAccessFile]のI/O対象名に環境変数が含まれている場合、
 * それらを解析して、I/O対象に変換します.
 *  
 * @version 1.0.0 2005/05/02
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class EnvRandomAccessFile extends RandomAccessFile
{
    public EnvRandomAccessFile( File file,String mode )
        throws IOException
    {
        super( file,mode ) ;
    }
    
    public EnvRandomAccessFile( String file,String mode )
        throws IOException
    {
        super( IODef.convertEnvName( file ),mode ) ;
    }
}

