/*
 * @( # )CommunicateException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.AccessException;
import org.maachang.commons.exception.BaseException;

/**
 * 通信例外.
 * <BR><BR>
 * 通信処理で例外が発生した場合、発生します.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class CommunicateException extends AccessException
{
    
    /**
     * エラーコード : 未接続.
     */
    public static final int NO_CONNECT = 0x00000000 ;
    
    /**
     * エラーコード : 接続先クローズ.
     */
    public static final int CLOSE_CONNECT = 0x00000001 ;
    
    /**
     * エラーコード : 接続先強制クローズ.
     */
    public static final int CLOSE_COMPULSION = 0x00000002 ;
    
    /**
     * エラーコード : 他のスレッドにより、クローズ.
     */
    public static final int ASYNCHRONOUSE_CLOSE = 0x00000003 ;
    
    /**
     * バインド失敗.
     */
    public static final int NOT_BIND = 0x00000010 ;
    
    /**
     * 未バインド例外.
     */
    public static final int UN_DEFINE_BIND = 0x00000011 ;
    
    /**
     * 接続先不明.
     */
    public static final int UNKNOWN_CONNECTION = 0x00000020 ;
    
    /**
     * コネクションタイムアウト.
     */
    public static final int TIME_OUT = 0x00000100 ;

    
    /**
     * エラーコード : その他エラー.
     */
    public static final int ETC_ERROR = 0x7fffffff ;
    
    /**
     * エラーコード.
     */
    private int m_code = CommunicateException.ETC_ERROR ;
    
    /**
     * コンタストラクタ.
     */
    private CommunicateException(  )
    {
    }
    
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param code エラーコード値を設定します.
     */
    public CommunicateException( int code )
    {
        m_code = code ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param message エラーメッセージを設定します.
     */
    public CommunicateException( String message )
    {
        super( message ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param code エラーコード値を設定します.
     * @param message エラーメッセージを設定します.
     */
    public CommunicateException( int code,String message )
    {
        super( message ) ;
        m_code = code ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public CommunicateException( Throwable e )
    {
        super( e ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public CommunicateException( BaseException e )
    {
        super( e ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     * @param code エラーコード値を設定します.
     */
    public CommunicateException( Throwable e,int code )
    {
        super( e ) ;
        m_code = code ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     * @param code エラーコード値を設定します.
     */
    public CommunicateException( BaseException e,int code )
    {
        super( e ) ;
        m_code = code ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     * @param message エラーメッセージを設定します.
     */
    public CommunicateException( Throwable e,String message )
    {
        super( e ) ;
        super.addMessage( message ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     * @param message エラーメッセージを設定します.
     */
    public CommunicateException( BaseException e,String message )
    {
        super( e ) ;
        super.addMessage( message ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     * @param code エラーコード値を設定します.
     * @param message エラーメッセージを設定します.
     */
    public CommunicateException( Throwable e,int code,String message )
    {
        super( e ) ;
        super.addMessage( message ) ;
        m_code = code ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     * @param code エラーコード値を設定します.
     * @param message エラーメッセージを設定します.
     */
    public CommunicateException( BaseException e,int code,String message )
    {
        super( e ) ;
        super.addMessage( message ) ;
        m_code = code ;
    }
    
    /**
     * エラーコード値の取得.
     * <BR><BR>
     * エラーコード値を取得します.
     * <BR>
     * @return int エラーコードが返されます.
     */
    public int getCode()
    {
        return m_code ;
    }
    
    /**
     * エラーコード文字情報変換.
     * <BR><BR>
     * 設定エラーコードを文字情報に変換します.
     * <BR>
     * @return String エラー文字情報が返されます.
     */
    public String getCodeToString()
    {
        String ret = null ;
        
        switch( m_code ){
            case CommunicateException.NO_CONNECT :
                ret = "接続先が存在しません" ;
                break ;
            case CommunicateException.CLOSE_CONNECT :
                ret = "接続先が切断しました" ;
                break ;
            case CommunicateException.CLOSE_COMPULSION :
                ret = "接続先が強制切断しました" ;
                break ;
            case CommunicateException.ASYNCHRONOUSE_CLOSE :
                ret = "別スレッドにより、ソケットオブジェクトがクローズされました" ;
                break ;
            case CommunicateException.NOT_BIND :
                ret = "バインドに失敗しました" ;
                break ;
            case CommunicateException.UN_DEFINE_BIND :
                ret = "バインドが行われていません" ;
                break ;
            case CommunicateException.UNKNOWN_CONNECTION :
                ret = "対象の接続先は不明です" ;
                break ;
            case CommunicateException.TIME_OUT :
                ret = "コネクションがタイムアウトを検知しました" ;
                break ;
            default :
                ret = "原因不明の例外が発生しました" ;
                break ;
        }
        
        return ret ;
    }
}
