/*
 * @(#)NetAdapterByWinNT.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.AccessException;
import org.maachang.commons.util.UtilCom;


/**
 * ネットワークアドレス取得WindowsNT版.
 * <BR><BR>
 * WindowsNT版のネットワークアドレス取得処理です.
 *  
 * @version 1.0.0 2004/10/13
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
class NetAdapterByWinNT extends NetAdapterBase
{
    
    /**
     * IPアドレス取得コマンド.
     */
    public static final String IPCONFIG_COMMAND = "ipconfig /all";
    
    /**
     * 媒体開始文字.
     */
    private static final String ADAPTER_NAME = "adapter" ;
    
    /**
     * ローカルアドレス媒体名.
     */
    private static final String LOCAL_ADAPTER_NAME = "ethernet" ;
    
    /**
     * 区切り値.
     */
    private static final String DIV_CODE = ":" ;
    
    /**
     * 詳細名.
     */
    private static final String ETC_NAME = "description" ;
    
    /**
     * IPアドレス.
     */
    private static final String IP_ADDR_1 = "ip" ;
    private static final String IP_ADDR_2 = "address" ;
    
    /**
     * サブネットマスク.
     */
    private static final String SUB_NET_1 = "subnet" ;
    private static final String SUB_NET_2 = "mask" ;
    
    /**
     * macアドレス.
     */
    private static final String MAC_ADDR_1 = "physical" ;
    private static final String MAC_ADDR_2 = "address" ;
    
    
    
    /**
     * MACアドレス区切り修正元.
     */
    private static final String MAC_ADDR_SRC = "-" ;
    
    /**
     * MACアドレス区切り修正先.
     */
    private static final String MAC_ADDR_DEST = ":" ;
    
    
    /**
     * コンストラクタ.
     */
    public NetAdapterByWinNT()
    {
    }
    
    /**
     * ネットワーク情報取得処理.
     * <BR><BR>
     * 対象のネットワーク情報を取得します.
     * <BR>
     * @exception AccessException アクセス例外.
     */
    public final void flush() throws AccessException
    {
        int i ;
        int len ;
        int localNo ;
        int wanNo ;
        int localCheck ;
        
        String[] cmdOut = null ;
        String cmd = null ;
        StringBuffer buf = null ;
        String name = null ;
        String value = null ;
        
        try{
            
            this.clear() ;
            cmdOut = super.runExec( NetAdapterByWinNT.IPCONFIG_COMMAND ) ;
            
            len = cmdOut.length ;
            for( i = 0,localNo = 0,wanNo = 0,localCheck = 0 ; i < len ; i ++ ){
                
                cmd = cmdOut[ i ] ;
                cmdOut[ i ] = null ;
                
                // adapter名を調べる.
                if(
                    cmd.indexOf( NetAdapterByWinNT.ADAPTER_NAME ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.DIV_CODE ) == cmd.length()-1
                )
                {
                    
                    // 対象adapter名がローカル媒体である場合.
                    if( cmd.indexOf( NetAdapterByWinNT.LOCAL_ADAPTER_NAME ) != -1 ){
                        
                        buf = new StringBuffer() ;
                        buf.append( NetAdapterBase.LOCAL_ETHER_NAME ) ;
                        buf.append( localNo ) ;
                        localNo ++ ;
                        
                        name = buf.toString() ;
                        buf = null ;
                        
                    }
                    // 対象adapter名がローカル媒体でない場合.
                    else{
                        
                        buf = new StringBuffer() ;
                        buf.append( NetAdapterBase.ETC_ETHER_NAME ) ;
                        buf.append( wanNo ) ;
                        wanNo ++ ;
                        
                        name = buf.toString() ;
                        buf = null ;
                        
                    }
                    
                }
                // 詳細名の場合.
                else if(
                    cmd.indexOf( NetAdapterByWinNT.ETC_NAME ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.DIV_CODE ) != -1
                )
                {
                    // 何もしない.
                    continue ;
                }
                // IPアドレスの場合.
                else if(
                    cmd.indexOf( NetAdapterByWinNT.IP_ADDR_1 ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.IP_ADDR_2 ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.DIV_CODE ) != -1
                )
                {
                    value = UtilCom.trimPlus( cmd.substring( cmd.indexOf( NetAdapterByWinNT.DIV_CODE )+1 ) ) ;
                    
                    // 対象IPアドレスがローカルアドレスを示す場合.
                    if( value.equals( NetDef.LOCAL_HOST ) == true ){
                        localCheck ++ ;
                    }
                    
                    super.addCategory( name,NetAdapter.CATEGORY_IPADDR,value ) ;
                }
                // サブネットマスクの場合.
                else if(
                    cmd.indexOf( NetAdapterByWinNT.SUB_NET_1 ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.SUB_NET_2 ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.DIV_CODE ) != -1
                )
                {
                    value = UtilCom.trimPlus( cmd.substring( cmd.indexOf( NetAdapterByWinNT.DIV_CODE )+1 ) ) ;
                    super.addCategory( name,NetAdapter.CATEGORY_SUBNET,value ) ;
                }
                // MACアドレスの場合.
                else if(
                    cmd.indexOf( NetAdapterByWinNT.MAC_ADDR_1 ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.MAC_ADDR_2 ) != -1 &&
                    cmd.indexOf( NetAdapterByWinNT.DIV_CODE ) != -1
                )
                {
                    value = UtilCom.trimPlus( cmd.substring( cmd.indexOf( NetAdapterByWinNT.DIV_CODE )+1 ) ) ;
                    value = UtilCom.changeString(
                        value,NetAdapterByWinNT.MAC_ADDR_SRC,NetAdapterByWinNT.MAC_ADDR_DEST
                    ).toUpperCase() ;
                    super.addCategory( name,NetAdapter.CATEGORY_MACADDR,value ) ;
                }
                // その他.
                else{
                    // 何もしない.
                    continue ;
                }
                
            }
            
            // ローカルアドレスが存在しない場合.
            if( localCheck == 0 ){
                
                // アドレスを追加.
                super.addCategory(
                    NetAdapterBase.DEFAULT_ETHER_NAME,
                    NetAdapter.CATEGORY_IPADDR,
                    NetDef.LOCAL_HOST
                ) ;
                // ホスト名を追加.
                super.addCategory(
                    NetAdapterBase.DEFAULT_ETHER_NAME,
                    NetAdapter.CATEGORY_SUBNET,
                    NetAdapterBase.LO_HOST_SUB
                ) ;
                
            }
            
        }catch( AccessException ac ){
            this.clear() ;
            throw ac ;
        }catch( Exception t ){
            this.clear() ;
        }finally{
            cmdOut = null ;
            cmd = null ;
            buf = null ;
            name = null ;
            value = null ;
        }
        
    }
    
}

