/*
 * @(#)NetAgent.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.AccessException;
import org.maachang.commons.exception.InputException;

/**
 * ネットワークエージェント処理.
 * <BR><BR>
 * ネットワークの切断/復帰を管理するエージェント処理です.
 *  
 * @version 1.0.0 2004/10/16
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NetAgent
{
    
    /**
     * ネットワークエージェントスレッド.
     */
    private final NetAgentThread m_thread = new NetAgentThread() ;
    
    /**
     * シングルトン.
     */
    private static final NetAgent SNGL = new NetAgent() ;
    
    
    
    /**
     * コンストラクタ.
     */
    private NetAgent()
    {
        try{
            m_thread.create() ;
        }catch( Exception t ){
        }
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            m_thread.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * オブジェクト情報を取得.
     * <BR><BR>
     * オブジェクト情報を取得します.
     * <BR>
     * @return NetAgent オブジェクト情報が返されます.
     */
    public static final NetAgent getInstance()
    {
        return SNGL ;
    }
    
    /**
     * 管理内容を破棄.
     * <BR><BR>
     * 管理されている内容を破棄します.
     */
    public final void destroyElements()
    {
        m_thread.destroyElements() ;
    }
    
    /**
     * ネットワークエージェント管理要素を追加.
     * <BR><BR>
     * ネットワークエージェント管理要素を追加します.
     * <BR>
     * @param value 対象のネットワークエージェント管理要素を設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public final void add( NetAgentElement value )
        throws InputException,AccessException
    {
        m_thread.add( value ) ;
    }
    
    /**
     * 実施インターバル値を設定.
     * <BR><BR>
     * 実施インターバル値を設定します.
     * <BR>
     * @param interval チェック間隔を設定します.<BR>
     *                 設定可能な最小値は[1000]です.<BR>
     *                 それ以下の値を設定した場合は、最小値となります.
     */
    public final void setInterval( int interval )
    {
        m_thread.setInterval( interval ) ;
    }
    
    /**
     * 実施インターバル値を取得.
     * <BR><BR>
     * 実施インターバル値を取得します.
     * <BR>
     * @return int 実施インターバル値が返されます.
     */
    public final int getInterval()
    {
        return m_thread.getInterval() ;
    }
    
    /**
     * ネットワークエージェント管理要素数を取得.
     * <BR><BR>
     * 対象のネットワークエージェント管理要素数を取得します.
     * <BR>
     * @return int 管理されているネットワークエージェント管理要素数が返されます.
     */
    public final int size()
    {
        return m_thread.size() ;
    }
    
    /**
     * 動作実施チェック.
     * <BR><BR>
     * このオブジェクトが動作しているかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、動作中です.<BR>
     *                 [false]が返された場合、停止中です.
     */
    public final boolean isExec()
    {
        return m_thread.isThread() ;
    }
    
}

