/*
 * @(#)UndefineBindException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.BaseException;

/**
 * バインド未定義例外.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class UndefineBindException extends CommunicateException
{
    /**
     * コンタストラクタ.
     */
    public UndefineBindException()
    {
        super( CommunicateException.UN_DEFINE_BIND ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public UndefineBindException(Throwable e)
    {
        super( e,CommunicateException.UN_DEFINE_BIND ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public UndefineBindException(BaseException e)
    {
        super( e,CommunicateException.UN_DEFINE_BIND ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public UndefineBindException(String message)
    {
        super( CommunicateException.UN_DEFINE_BIND,message ) ;
        
    }
}
