/*
 * @(#)FTPDef.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net.ftp;

import org.maachang.commons.io.IOCom;
/**
 * FTP定義.
 * <BR><BR>
 * FTPクライアントの定義ファイルです.
 *  
 * @version 1.0.0 2004/11/27
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
class FTPDef
{
    
    /**
     * 匿名ユーザ名.
     */
    public static final String ANONYMOUS = "anonymous" ;
    
    /**
     * デフォルトポート番号.
     */
    public static final int DEF_PORT = IOCom.FTP_PORT ;
    
    /**
     * 電文受信タイムアウト値.
     */
    public static final int RECV_TELEGRAM_TIME = 150 ;
    
    /**
     * バッファ長.
     */
    public static final int BUF_LENGTH = 1024 ;
    
    /**
     * コマンド要求リトライカウント.
     */
    public static final int GET_RETRY = 499 ;
    
    /**
     * コマンド要求マックスリトライカウント.
     */
    public static final int GET_MAXRETRY = 1999 ;
    
    /**
     * コマンド要求タイムアウト値.
     */
    public static final int COMMAND_TIMEOUT = 500 ;
    
    
    
    /**
     * FTPコマンド戻りコード : REST条件戻り値.
     */
    public static final int RETOK_REST_MARK = 110 ;
    
    /**
     * FTPコマンド戻りコード : 接続リトライ.
     */
    public static final int RETWNG_RETRY_CONNECT = 120 ;
    
    /**
     * FTPコマンド戻りコード : 既に接続が確立.
     */
    public static final int RETWNG_USE_CONNECT = 125 ;
    
    /**
     * FTPコマンド戻りコード : ファイルステータスは正常.
     */
    public static final int RETOK_FILE_STATE = 150 ;
    
    /**
     * FTPコマンド戻りコード : 正常なコマンドを受理.
     */
    public static final int RETOK_SUCCESS = 200 ;
    
    /**
     * FTPコマンド戻りコード : 異常なコマンドを受理.
     */
    public static final int RETNG_ERROR = 202 ;
    
    /**
     * FTPコマンド戻りコード : STAT条件戻り値.
     */
    public static final int RETOK_STAT = 211 ;
    
    /**
     * FTPコマンド戻りコード : STATによるディレクトリ情報.
     */
    public static final int RETOK_STAT_DIR = 212 ;
    
    /**
     * FTPコマンド戻りコード : STATによるファイル情報.
     */
    public static final int RETOK_STAT_FILE = 213 ;
    
    /**
     * FTPコマンド戻りコード : HELP条件戻り値.
     */
    public static final int RETOK_HELP = 214 ;
    
    /**
     * FTPコマンド戻りコード : SYST条件戻り値.
     */
    public static final int RETOK_SYST = 215 ;
    
    /**
     * FTPコマンド戻りコード : ログイン条件戻り値.
     */
    public static final int RETOK_LOGIN = 220 ;
    
    /**
     * FTPコマンド戻りコード : 終了条件戻り値.
     */
    public static final int RETOK_QUIT = 221 ;
    
    /**
     * FTPコマンド戻りコード : コネクション確立戻り値.
     */
    public static final int RETOK_CONNECT = 225 ;
    
    /**
     * FTPコマンド戻りコード : クローズ確立戻り値.
     */
    public static final int RETOK_CLOSE = 226 ;
    
    /**
     * FTPコマンド戻りコード : PASV条件戻り値.
     */
    public static final int RETOK_PASV = 227 ;
    
    /**
     * FTPコマンド戻りコード : ログイン成功戻り値.
     */
    public static final int RETOK_SUCCESS_LOGIN = 230 ;
    
    /**
     * FTPコマンド戻りコード : コマンド成功戻り値.
     */
    public static final int RETOK_SUCCESS_COMMAND = 250 ;
    
    /**
     * FTPコマンド戻りコード : 作成戻り値.
     */
    public static final int RETOK_SUCCESS_CREATE = 257 ;
    
    /**
     * FTPコマンド戻りコード : パスワード再入力.
     */
    public static final int RETWNG_RETRY_PASSWD = 331 ;
    
    /**
     * FTPコマンド戻りコード : ACCTコマンドによる課金指定.
     */
    public static final int RETWNG_RETRY_ACCT = 332 ;
    
    /**
     * FTPコマンド戻りコード : 情報要求.
     */
    public static final int RETOK_RETRY_INFO = 350 ;
    
    /**
     * FTPコマンド戻りコード : サービス提供が不可.
     */
    public static final int RETNG_NOT_SEARVICE = 421 ;
    
    /**
     * FTPコマンド戻りコード : コネクションが不可.
     */
    public static final int RETNG_NOT_CONNECT = 425 ;
    
    /**
     * FTPコマンド戻りコード : コネクションがクローズされた.
     */
    public static final int RETNG_CLOSE_CONNECT = 426 ;
    
    /**
     * FTPコマンド戻りコード : 何らかの利用でリクエストの応答不可.
     */
    public static final int RETNG_NOT_REQUEST = 450 ;
    
    /**
     * FTPコマンド戻りコード : ローカルエラー.
     */
    public static final int RETNG_LOCAL = 451 ;
    
    /**
     * FTPコマンド戻りコード : ディスク容量が無いためのエラー.
     */
    public static final int RETNG_FULL_DISK = 452 ;
    
    /**
     * FTPコマンド戻りコード : 文法エラー.
     */
    public static final int RETNG_SYNTAX = 500 ;
    
    /**
     * FTPコマンド戻りコード : 引数エラー.
     */
    public static final int RETNG_SYNTAX_PARAMETER = 501 ;
    
    /**
     * FTPコマンド戻りコード : コマンド未実装/不正.
     */
    public static final int RETNG_NOT_COMMAND = 502 ;
    
    /**
     * FTPコマンド戻りコード : コマンド順番不正.
     */
    public static final int RETNG_NOSET_COMMAND = 503 ;
    
    /**
     * FTPコマンド戻りコード : 引数未実装.
     */
    public static final int RETNG_NOT_PARAMETER = 504 ;
    
    /**
     * FTPコマンド戻りコード : ログイン失敗.
     */
    public static final int RETNG_NOT_LOGIN = 530 ;
    
    /**
     * FTPコマンド戻りコード : ACCT確認.
     */
    public static final int RETNG_NOT_ACCT = 532 ;
    
    /**
     * FTPコマンド戻りコード : リクエストが何らかの問題でエラー.
     */
    public static final int RETNG_ERROR_REQUEST = 550 ;
    
    /**
     * FTPコマンド戻りコード : ページ構造タイプエラー.
     */
    public static final int RETNG_ERROR_PAGETYPE = 551 ;
    
    /**
     * FTPコマンド戻りコード : ディスク容量によるエラー.
     */
    public static final int RETNG_ERROR_DISK = 552 ;
    
    /**
     * FTPコマンド戻りコード : ファイル名不正によるエラー.
     */
    public static final int RETNG_ERROR_FILENAME = 553 ;
    
    /**
     * FTPコマンド戻りコード : 不明なエラー.
     */
    public static final int RETNG_UNKNOWN = 999 ;
    
    
    
    /**
     * FTPコマンド戻りマスク : 肯定的な予備応答.
     */
    public static final int RETMASK_NEXT_COMMAND = 100 ;
    
    /**
     * FTPコマンド戻りマスク : 肯定的な完了応答.
     */
    public static final int RETMASK_END_COMMAND = 200 ;
    
    /**
     * FTPコマンド戻りマスク : 肯定的な中間応答.
     */
    public static final int RETMASK_END_BITWEEN = 300 ;
    
    /**
     * FTPコマンド戻りマスク : 一時的な否定応答.
     */
    public static final int RETMASK_WARNING_COMMAND = 400 ;
    
    /**
     * FTPコマンド戻りマスク : 否定応答.
     */
    public static final int RETMASK_ERROR_COMMAND = 500 ;
    
    
    
    /**
     * FTPコマンド戻りカテゴリ : 文法エラー.
     */
    public static final int RETCATEGORY_SYNTAX = 0 ;
    
    /**
     * FTPコマンド戻りカテゴリ : インフォメーション.
     */
    public static final int RETCATEGORY_INFORMATION = 10 ;
    
    /**
     * FTPコマンド戻りカテゴリ : 接続関係.
     */
    public static final int RETCATEGORY_CONNECT = 20 ;
    
    /**
     * FTPコマンド戻りカテゴリ : 認証関係.
     */
    public static final int RETCATEGORY_ATTESTATION = 30 ;
    
    /**
     * FTPコマンド戻りカテゴリ : 未使用.
     */
    public static final int RETCATEGORY_DUMMY_1 = 40 ;
    
    /**
     * FTPコマンド戻りカテゴリ : ファイルシステム関連.
     */
    public static final int RETCATEGORY_FILESYSTEM = 50 ;
    
    
    
    /**
     * エラーレベル : エラー無し.
     */
    public static final int LEVEL_SUCCESS = 0 ;
    
    /**
     * エラーレベル : 警告.
     */
    public static final int LEVEL_WARNING = 1 ;
    
    /**
     * エラーレベル : エラー.
     */
    public static final int LEVEL_ERROR = 2 ;
    
    /**
     * エラーレベル : システムエラー.
     */
    public static final int LEVEL_SYSTEM = 3 ;
    
    
    /**
     * コンストラクタ.
     */
    private FTPDef(){}
    
    /**
     * エラーレベル判別.
     * <BR><BR>
     * エラーレベルを判別します.
     * <BR>
     * @param code チェック対象のコードを設定します.
     * @return int エラーレベルが返されます.<BR>
     *             [FTPDef.LEVEL_SUCCESS]の場合エラーは存在しません.<BR>
     *             [FTPDef.LEVEL_WARNING]の場合警告です.<BR>
     *             [FTPDef.LEVEL_ERROR]の場合エラーです.<BR>
     *             [FTPDef.LEVEL_SYSTEM]の場合システムエラーです.
     */
    public static final int getErrorLevel( int code )
    {
        int ret ;
        switch( code ){
            case FTPDef.RETOK_REST_MARK :           // 110 REST条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETWNG_RETRY_CONNECT :      // 120 接続リトライ.
                ret = FTPDef.LEVEL_WARNING ; break ;    // 警告.
                
            case FTPDef.RETWNG_USE_CONNECT :        // 125 既に接続が確立.
                ret = FTPDef.LEVEL_WARNING ; break ;    // 警告.
                
            case FTPDef.RETOK_FILE_STATE :          // 150 ファイルステータスは正常.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_SUCCESS :             // 200 正常なコマンドを受理.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETNG_ERROR :               // 202 異常なコマンドを受理.
                ret = FTPDef.LEVEL_WARNING ; break ;    // 警告.
                
            case FTPDef.RETOK_STAT :                // 211 STAT条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_STAT_DIR :            // 212 STATによるディレクトリ情報.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_STAT_FILE :           // 213 STATによるファイル情報.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_HELP :                // 214 HELP条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_SYST :                // 215 SYST条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_LOGIN :               // 220 ログイン条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_QUIT :                // 221 終了条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_CONNECT :             // 225 コネクション確立戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_CLOSE :               // 226 クローズ確立戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_PASV :                // 227 PASV条件戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_SUCCESS_LOGIN :       // 230 ログイン成功戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_SUCCESS_COMMAND :     // 250 コマンド成功戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETOK_SUCCESS_CREATE :      // 257 作成戻り値.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETWNG_RETRY_PASSWD :       // 331 パスワード再入力.
                ret = FTPDef.LEVEL_WARNING ; break ;    // 警告.
                
            case FTPDef.RETWNG_RETRY_ACCT :         // 332 ACCTコマンドによる課金指定.
                ret = FTPDef.LEVEL_WARNING ; break ;    // 警告.
                
            case FTPDef.RETOK_RETRY_INFO :          // 350 情報要求.
                ret = FTPDef.LEVEL_SUCCESS ; break ;    // 正常.
                
            case FTPDef.RETNG_NOT_SEARVICE :        // 421 サービス提供が不可.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
                
            case FTPDef.RETNG_NOT_CONNECT :         // 425 コネクションが不可.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
                
            case FTPDef.RETNG_CLOSE_CONNECT :       // 426 コネクションがクローズされた.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
                
            case FTPDef.RETNG_NOT_REQUEST :         // 450 何らかの利用でリクエストの応答不可.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_LOCAL :               // 451 ローカルエラー.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_FULL_DISK :           // 452 ディスク容量が無いためのエラー.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_SYNTAX :              // 500 文法エラー.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_SYNTAX_PARAMETER :    // 501 引数エラー.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_NOT_COMMAND :         // 502 コマンド未実装/不正.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_NOSET_COMMAND :       // 503 コマンド順番不正.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_NOT_PARAMETER :       // 504 引数未実装.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_NOT_LOGIN :           // 530 ログイン失敗.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_NOT_ACCT :            // 532 ACCT確認.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_ERROR_REQUEST :       // 550 リクエストが何らかの問題でエラー.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_ERROR_PAGETYPE :      // 551 ページ構造タイプエラー.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
                
            case FTPDef.RETNG_ERROR_DISK :          // 552 ディスク容量によるエラー.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
                
            case FTPDef.RETNG_ERROR_FILENAME :      // 553 ファイル名不正によるエラー.
                ret = FTPDef.LEVEL_ERROR ; break ;      // エラー.
                
            case FTPDef.RETNG_UNKNOWN :             // 999 不明なエラー.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
            default :                               // その他.
                ret = FTPDef.LEVEL_SYSTEM ; break ;     // システムエラー.
        }
        
        return ret ;
        
    }

}
