/*
 * @(#)MgcTable.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net.mgc ;

import org.maachang.commons.util.array.ObjectArray;

/**
 * Mgc通信テーブル.
 *  
 * @version 1.0.0 2005/07/31
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
class MgcTable
{
    
    /**
     * データ管理用.
     */
    private final ObjectArray m_table = new ObjectArray() ;
    
    /**
     * コンストラクタ.
     */
    public MgcTable(){}
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 対象の情報をクリアします.
     */
    public final void clear()
    {
        synchronized( this ){
            m_table.clear() ;
        }
    }
    
    /**
     * 情報設定.
     * <BR><BR>
     * 情報を設定します.
     * <BR>
     * @param bin 対象のバイナリ情報を設定します.
     */
    public final void set( byte[] bin )
    {
        try{
            synchronized( this ){
                m_table.add( bin ) ;
            }
        }catch( Exception e ){
        }
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 情報が設定されている場合、取得されます.
     * <BR>
     * @return byte[] 対象のバイナリが返されます.<BR>
     *                [null]が返された場合、情報は存在しません.
     */
    public final byte[] get()
    {
        byte[] ret = null ;
        
        synchronized( this ){
            if( m_table.size() > 0 ){
                ret = ( byte[] )m_table.remove( 0 ) ;
            }
        }
        
        return ret ;
    }
    
    /**
     * 格納情報数を取得.
     * <BR><BR>
     * 現在格納されている情報数が返されます.
     * <BR>
     * @return int 格納されている情報数が返されます.
     */
    public final int size()
    {
        int ret ;
        
        synchronized( this ){
            ret = m_table.size() ;
        }
        
        return ret ;
    }
}

