/*
 * @(#)MgcWriteValue.java
 *
 * Copyright (c) ; 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net.mgc ;

/**
 * マルチキャストグループ書き込み用オブジェクト.
 * <BR><BR>
 * 接続情報を格納するマルチキャストグループ書き込み用要素オブジェクトです.
 *  
 * @version 1.0.0 2005/07/29
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface MgcWriteValue
{
    
    /**
     * 前回応答時間を更新.
     * <BR><BR>
     * 前回の応答時間を更新します.
     */
    public void update() ;
    
    /**
     * 接続カウントを設定.
     * <BR><BR>
     * 接続カウントを設定します.
     * <BR>
     * @param cnt 対象のカウントを設定します.
     */
    public void setConnectCount( int cnt ) ;
    
    /**
     * 応答時間を設定.
     * <BR><BR>
     * 対象の応答時間を設定します.
     * <BR>
     * @param time 応答時間を設定します.
     */
    public void setResponseTime( int time ) ;
    
    /**
     * MgcServer標準時間を設定.
     * <BR><BR>
     * MgcServer標準時間を設定します.<BR>
     * この値はグループ内で一番低い値が標準時間となります.
     * <BR>
     * @param time 対象の標準時間を設定します.
     */
    public void setDefaultTime( long time ) ;
    
    /**
     * 応答なしカウントを１インクリメント.
     * <BR><BR>
     * 応答なしカウントを１インクリメントします.
     */
    public void addNoResponseCount() ;
    
    /**
     * 応答なしカウントを取得.
     * <BR><BR>
     * 現在の応答なしカウントを取得します.
     * <BR>
     * @return int 現在の応答なしカウントが返されます.
     */
    public int getNoResponseCount() ;
    
}
