/*
 * @(#)CmdCommon.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.sys.cmd;

import org.maachang.commons.sys.Os;

/**
 * コマンド共通処理.
 * <BR><BR>
 * コマンド共通処理です.
 * 
 * @version 1.0.0 2004/10/15
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
class CmdCommon
{
    
    /**
     * コマンド実行接頭語 : windowsNT系.
     */
    private static final String[] WINNT_ENVCMD = {
        "cmd", "/c"
    } ;
    
    /**
     * コマンド実行接頭語 : windows9x系.
     */
    private static final String[] WIN9X_ENVCMD = {
        "command.com", "/c"
    } ;
    
    /**
     * コマンド実行接頭語 : os/2系.
     */
    private static final String[] OS_2_ENVCMD = {
        "cmd", "/c"
    } ;
    
    /**
     * コンストラクタ.
     */
    private CmdCommon()
    {
    }
    
    /**
     * コマンド接頭語チェック.
     * <BR><BR>
     * コマンド接頭語チェックを行います.<BR>
     * また、引数はどちらか１つを設定します.
     * <BR>
     * @param param 対象のパラメータ付きコマンドを設定します.
     * @param cmd 単一のコマンドを設定します.
     * @return String[] チェックされたコマンド情報が返されます.
     */
    public static final String[] getCmdHeader( String[] param,String cmd )
    {
        int i ;
        int len ;
        boolean flg ;
        
        String[] tmp = null ;
        String[] ret = null ;
        
        if( param != null && param.length == 1 ){
            cmd = param[ 0 ] ;
            param = null ;
        }
        
        // 複数コマンドの場合.
        if( param != null ){
            
            switch( Os.getInstance().getOS() ){
                case Os.OS_WINNT :
                    tmp = WINNT_ENVCMD ;
                    break ;
                case Os.OS_DOS :
                case Os.OS_WIN9X :
                    tmp = WIN9X_ENVCMD ;
                    break ;
                case Os.OS_OS_2 :
                    tmp = OS_2_ENVCMD ;
                    break ;
                default :
                    tmp = null ;
            }
            
            if( tmp != null ){
                
                len = tmp.length ;
                flg = true ;
                
                if( len > 0 ){
                    for( i = 0 ; i < len ; i ++ ){
                        if( tmp[ i ].toLowerCase().equals( param[ i ].toLowerCase() ) == false ){
                            flg = false ;
                            break ;
                        }
                    }
                }
                
                if( flg == false ){
                    
                    ret = new String[ len + param.length ] ;
                    System.arraycopy( tmp,0,ret,0,len ) ;
                    System.arraycopy( param,0,ret,len,param.length ) ;
                    
                }
                else{
                    ret = param ;
                }
            }
            else{
                ret = param ;
            }
            
            
        }
        // 単一コマンドの場合.
        else{
            
            switch( Os.getInstance().getOS() ){
                case Os.OS_WINNT :
                    tmp = WINNT_ENVCMD ;
                    break ;
                case Os.OS_DOS :
                case Os.OS_WIN9X :
                    tmp = WIN9X_ENVCMD ;
                    break ;
                case Os.OS_OS_2 :
                    tmp = OS_2_ENVCMD ;
                    break ;
                default :
                    tmp = null ;
            }
            
            if( tmp != null ){
                len = tmp.length ;
                ret = new String[ len + 1 ] ;
                System.arraycopy( tmp,0,ret,0,len ) ;
                ret[ len ] = cmd ;
            }
            else{
                ret = new String[ 1 ] ;
                ret[ 0 ] = cmd ;
            }
            
        }
        
        /*
        // ディレクトリ情報が指定されている場合.
        if( directory != null && directory.length() > 0 ){
            
            tmp = ret ;
            len = tmp.length ;
            ret = new String[ len+1 ] ;
            System.arraycopy( tmp,0,ret,0,len ) ;
            tmp = null ;
            ret[ len ] = directory ;
                
        }
        */
        
        return ret ;
    }
    
}
