/*
 * @(#)LocalManager.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.thread;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.util.CharTable;


/**
 * スレッドローカル情報管理.
 *
 * @version     1.00, 2004/01/31
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
class LocalManager
{
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( LocalManager.class ) ;
    
    
    
    /**
     * ローカルデータ管理.
     */
    private final ThreadLocal m_local = new ThreadLocal() ;
    
    /**
     * 格納テーブル.
     */
    private CharTable m_table = null ;
    
    /**
     * 同期オブジェクト.
     */
    private Synchronized m_sync = null ;
    
    /**
     * コンストラクタ.
     */
    private LocalManager()
    {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * テーブル情報をセットします.
     * <BR>
     * @param table 対象のテーブル情報をセットします.
     * @param sync テーブルに対する同期オブジェクトをセットします.
     */
    public LocalManager( CharTable table,Synchronized sync )
    {
        m_table = table ;
        m_sync = sync ;
    }
    
    /**
     * LocalManagerクローズ.
     * <BR><BR>
     * LocalManagerをクローズします.
     */
    protected final void closeManager()
    {
        int i ;
        int len ;
        
        String key = null ;
        String[] keys = null ;
        CharTable table = null ;
        
        table = m_table ;
        keys = table.getNames() ;
        
        len = table.size() ;
        for( i = 0 ; i < len ; i ++ ){
            
            try{
                
                key = keys[ i ] ;
                keys[ i ] = null ;
                
                ( ( ThreadState )table.get( key ) ).clear() ;
                
            }catch( Exception t ){
            }
        }
        
        key = null ;
        keys = null ;
        table = null ;
        
        m_table = null ;
        m_sync = null ;
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        this.closeManager() ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        
        try{
            
            ( ( ThreadStateLocal )m_local.get() ).clear() ;
            
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 対象の情報を取得します.
     * <BR>
     * @return ThreadState スレッド管理要素が返されます.
     */
    public final ThreadState get()
    {
        return this.getLocalThreadState() ;
    }
    
    /**
     * ローカルスレッドチェック.
     * <BR><BR>
     * ローカルスレッドチェックを行います.
     */
    protected final boolean chkThread()
    {
        return ( this.getLocalThreadState() == null ) ?
            false : true ;
    }
    
    /**
     * ローカルスレッド非情報存在時処理.
     */
    private final ThreadState getLocalThreadState()
    {
        
        Thread current = null ;
        ThreadLocal local = null ;
        ThreadState ret = null ;
        ThreadStateLocal manLo = null ;
        
        local = m_local ;
        
        try{
            
            manLo = ( ThreadStateLocal )local.get() ;
            
            if( manLo == null ){
                
                current = Thread.currentThread() ;
                
                synchronized( m_table ){
                    ret = ( ThreadState )m_table.get( current.getName() ) ;
                }
                
                if( ret != null ){
                    
                    manLo = new ThreadStateLocal( ret ) ;
                    local.set( manLo ) ;
                    
                }else{
                    
                    manLo = new ThreadStateLocal( current ) ;
                    local.set( manLo ) ;
                    
                    ret = manLo.get() ;
                    
                    synchronized( m_table ){
                        m_table.add( current.getName(),ret ) ;
                    }
                    
                }
                
            }else{
                
                ret = manLo.get() ;
                
            }
            
        }catch( Exception t ){
            
            LOG.error( "localThreadの取得に失敗しました",t ) ;
            
            manLo = null ;
            ret = null ;
            
            try{
                
                current = Thread.currentThread() ;
                
                synchronized( m_table ){
                    ret = ( ThreadState )m_table.get( current.getName() ) ;
                }
                
                if( ret != null ){
                    
                    manLo = new ThreadStateLocal( ret ) ;
                    local.set( manLo ) ;
                    
                }else{
                    
                    manLo = new ThreadStateLocal( current ) ;
                    local.set( manLo ) ;
                    
                    ret = manLo.get() ;
                    
                    synchronized( m_table ){
                        m_table.add( current.getName(),ret ) ;
                    }
                    
                }
            }catch( Exception tt ){
                LOG.fatal( "localThreadの再取得に失敗しました",tt ) ;
                ret = null ;
            }
            
        }finally{
            
            if(
                ret != null &&
                ret.getID() == ThreadManager.NOSET_ID
            )
            {
                ret.setID( ThreadManager.getID() ) ;
            }
            
            local = null ;
            manLo = null ;
            current = null ;
            
        }
        
        return ret ;
        
    }
}

