/*
 * @(#)CharTableSync.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

import java.io.Serializable;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.serialize.SerializeUtil;


/**
 * CharTableSyncオブジェクト.
 * <BR><BR>
 * String情報を同期モードで管理するオブジェクトです.<BR>
 * このオブジェクトは同期モードです.<BR>
 * このオブジェクトは、非同期モード[CharTable]オブジェクトに比べて
 * 約１５％遅く動作しますが、スレッド間アクセスを行った場合、内容は保証
 * されます.<BR>
 * 非同期モードのオブジェクトは[CharTable]オブジェクトを利用してください.
 *
 * @version 1.00, 2000/12/09
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class CharTableSync implements Serializable
{
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            CharTableSync.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * データ管理オブジェクト.
     */
    private CoreCharTable m_info = null ;
    
    /**
     * コンストラクタ.
     */
    public CharTableSync()
    {
        m_info = new CoreCharTable() ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 検索コードを指定して生成します.
     * <BR>
     * @param searchNo 検索コードを設定します.<BR>
     *                 設定可能な最小値は[0]です.<BR>
     *                 設定可能な最大値は[7]です.
     */
    //public CharTableSync( int searchNo )
    //{
    //  m_info = new CoreCharTable( searchNo ) ;
    //}
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        m_info.clear() ;
    }
    
    /**
     * 情報の追加.
     * <BR><BR>
     * 管理オブジェクトに文字列を追加します.
     * <BR>
     * @param name 追加対象の文字列情報を設定します.<BR>
     *             すでに同一文字列情報が存在する場合、上書きします.
     * @param value 追加対象の要素情報を設定します.
     * @exception InputException 入力例外.
     */
    public synchronized final void add(String name,Object value)
        throws InputException
    {
        m_info.add(name,value) ;
    }
    
    /**
     * 指定情報の削除.
     * <BR><BR>
     * 指定された情報を削除します.
     * <BR>
     * @param name 削除対象の文字列情報を指定します.
     * @return Object 削除された情報の要素が返されます.
     * @exception InputException 入力例外.
     */
    public synchronized final Object remove(String name)
        throws InputException
    {
        return m_info.remove(name) ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 指定文字列の情報を取得します.
     * <BR>
     * @param name 取得対象の文字列情報を指定します.
     * @return Object 取得された情報の要素が返されます.
     */
    public synchronized final Object get( String name )
    {
        return m_info.get( name ) ;
    }
    
    /**
     * 文字列に対する存在チェック.
     * <BR><BR>
     * 文字列に対する存在チェックを行います.
     * <BR>
     * @param name チェック対象の文字列を設定します.
     * @return boolean 存在結果が返されます.<BR>
     *                 [true]が返された場合、情報は存在します.<BR>
     *                 [false]が返された場合、情報は存在しません.
     */
    public synchronized final boolean isData( String name )
    {
        return m_info.isData( name ) ;
    }
    
    /**
     * 格納情報数の取得.
     * <BR><BR>
     * 格納情報数が返されます.
     * <BR>
     * @return int 格納情報数が返されます.
     */
    public synchronized final int size()
    {
        return m_info.size() ;
    }
    
    /**
     * 格納文字列配列の取得.
     * <BR><BR>
     * 格納されているキーとなる文字列をすべて取得します.
     * <BR>
     * @return String[] 格納文字列配列が返されます.<BR>
     *                  情報が存在しない場合[null]が返されます.
     */
    public synchronized final String[] getNames()
    {
        return m_info.getNames() ;
    }
}
