/*
 * @(#)Link.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

import org.maachang.commons.exception.AccessException;

/**
 * リンクインターフェイス.
 * <BR><BR>
 * リンクインターフェイスを定義します.
 * <BR>
 *  
 * @version 1.0.0 2004/07/14
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public interface Link
{
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 格納情報をクリアします.
     */
    public void clear() ;
    
    /**
     * 先頭位置に移動.
     * <BR><BR>
     * 先頭の位置に移動します.
     * @return Object 移動位置のオブジェクトが返されます.<BR>
     *                返された情報が[null]の場合、情報が設定されていません.
     */
    public Object first() ;
    
    /**
     * 最後の位置に移動.
     * <BR><BR>
     * 最後の位置に移動します.
     * @return Object 移動位置のオブジェクトが返されます.<BR>
     *                返された情報が[null]の場合、情報が設定されていません.
     */
    public Object end() ;
    
    /**
     * 次位置に移動.
     * <BR><BR>
     * 次の位置に移動します.
     * <BR>
     * @return Object 移動位置のオブジェクトが返されます.<BR>
     *                返された情報が[null]の場合、移動位置は、範囲外となります.
     */
    public Object next() ;
    
    /**
     * 前位置に移動.
     * <BR><BR>
     * 前の位置に移動します.
     * <BR>
     * @return Object 移動位置のオブジェクトが返されます.<BR>
     *                返された情報が[null]の場合、移動位置は、範囲外となります.
     */
    public Object before() ;
    
    /**
     * 現在位置の情報を取得.
     * <BR><BR>
     * 現在位置の情報を取得します.
     * <BR>
     * @return Object 現在位置のオブジェクトが返されます.
     * @exception AccessException アクセス例外.<BR>
     *            情報が存在しない場合、返されます.
     */
    public Object get() throws AccessException ;
    
    /**
     * 指定位置へジャンプ.
     * <BR><BR>
     * 指定された位置へジャンプします.
     * <BR>
     * @param no ジャンプ先の値を設定します.<BR>
     *           たとえば、現在の情報位置が[10]とした場合、この値に[3]を設定すると
     *           ジャンプ対象位置は[13]となります.
     * @exception AccessException アクセス例外.<BR>
     *            情報が存在しない場合、返されます.
     */
    public void jump(int no) throws AccessException ;
    
    /**
     * 情報長の取得.
     * <BR><BR>
     * 情報長を取得します.
     * <BR>
     * @return int 情報長が返されます.
     */
    public int size() ;
    
    /**
     * 現在位置の取得.
     * <BR><BR>
     * 現在位置を取得します.
     * <BR>
     * @return int 現在位置が返されます.
     */
    public int nowPoint() ;
    
    /**
     * 情報生成チェック.
     * <BR><BR>
     * 情報生成チェックを行います.
     * <BR>
     * @return boolean 生成チェック(利用可能状態)が返されます.<BR>
     *                 [true]が返された場合、利用可能です.<BR>
     *                 [false]が返された場合、利用不可能です.
     */
    public boolean isCreate() ;
    
}

