/*
 * @(#)PointInt.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;


/**
 * Intポイントオブジェクト.
 * <BR><BR>
 * Point情報をIntで格納するオブジェクトです.
 *
 * @version 1.00, 2005/03/10
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class PointInt implements Serializable,Comparable
{
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            PointInt.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    private int m_x = Integer.MIN_VALUE ;
    private int m_y = Integer.MIN_VALUE ;
    
    /**
     * コンストラクタ.
     */
    public PointInt()
    {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * ポイント情報を設定します.
     * <BR>
     * @param x X条件を設定します.
     * @param y Y条件を設定します.
     */
    public PointInt( int x,int y )
    {
        m_x = x ;
        m_y = y ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * ポイント情報を設定します.
     * <BR>
     * @param x X条件を設定します.
     * @param y Y条件を設定します.
     */
    public final void create( int x,int y )
    {
        m_x = x ;
        m_y = y ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        m_x = Integer.MIN_VALUE ;
        m_y = Integer.MIN_VALUE ;
    }
    
    /**
     * X条件を取得.
     * <BR><BR>
     * X条件を取得します.
     * <BR>
     * @return int X条件が返されます.
     */
    public final int getX()
    {
        return m_x ;
    }
    
    /**
     * Y条件を取得.
     * <BR><BR>
     * Y条件を取得します.
     * <BR>
     * @return int Y条件が返されます.
     */
    public final int getY()
    {
        return m_y ;
    }
    
    /**
     * 比較処理.
     * <BR><BR>
     * ソート条件などで利用します.
     * <BR>
     * @param o 比較対照オブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo( Object o )
    {
        if( o == null ){
            return -1 ;
        }
        
        return m_x - ( ( PointInt )o ).getX() ;
    }
    
    /**
     * 文字列に変換.
     * <BR><BR>
     * 格納条件を文字列に変換します.
     * <BR>
     * @return String 文字列が返されます.
     */
    public final String toString()
    {
        StringBuffer buf = null ;
        buf = new StringBuffer() ;
        
        buf.append( "x=" ) ;
        buf.append( ( ( m_x == Integer.MIN_VALUE ) ? "*" : String.valueOf( m_x ) ) ) ;
        buf.append( " y=" ) ;
        buf.append( ( ( m_y == Integer.MIN_VALUE ) ? "*" : String.valueOf( m_y ) ) ) ;
        
        return buf.toString() ;
    }
}
