/*
 * @(#)PositionInt.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;


/**
 * Intポジションオブジェクト.
 * <BR><BR>
 * ポジション情報をIntで格納するオブジェクトです.
 *
 * @version 1.00, 2005/06/07
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class PositionInt implements Serializable,Comparable
{
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            PositionInt.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    private int m_point = Integer.MIN_VALUE ;
    private int m_length = Integer.MIN_VALUE ;
    
    /**
     * コンストラクタ.
     */
    public PositionInt()
    {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * ポジション情報を設定します.
     * <BR>
     * @param point ポジション位置を設定します.
     * @param length ポジション位置からの長さを設定します.
     */
    public PositionInt( int point,int length )
    {
        m_point = point ;
        m_length = length ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * ポジション情報を設定します.
     * <BR>
     * @param point ポジション位置を設定します.
     * @param length ポジション位置からの長さを設定します.
     */
    public final void create( int point,int length )
    {
        m_point = point ;
        m_length = length ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        m_point = Integer.MIN_VALUE ;
        m_length = Integer.MIN_VALUE ;
    }
    
    /**
     * ポジション条件を取得.
     * <BR><BR>
     * ポジション条件を取得します.
     * <BR>
     * @return int ポジション条件が返されます.
     */
    public final int getPoint()
    {
        return m_point ;
    }
    
    /**
     * ポジションからの長さ条件を取得.
     * <BR><BR>
     * ポジションからの長さ条件を取得します.
     * <BR>
     * @return int ポジションからの長さ条件が返されます.
     */
    public final int getLength()
    {
        return m_length ;
    }
    
    /**
     * 比較処理.
     * <BR><BR>
     * ソート条件などで利用します.
     * <BR>
     * @param o 比較対照オブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo( Object o )
    {
        if( o == null ){
            return -1 ;
        }
        
        return m_point - ( ( PositionInt )o ).getPoint() ;
    }
    
    /**
     * 文字列に変換.
     * <BR><BR>
     * 格納条件を文字列に変換します.
     * <BR>
     * @return String 文字列が返されます.
     */
    public final String toString()
    {
        StringBuffer buf = null ;
        buf = new StringBuffer() ;
        
        buf.append( "point=" ) ;
        buf.append( ( ( m_point == Integer.MIN_VALUE ) ? "*" : String.valueOf( m_point ) ) ) ;
        buf.append( " length=" ) ;
        buf.append( ( ( m_length == Integer.MIN_VALUE ) ? "*" : String.valueOf( m_length ) ) ) ;
        
        return buf.toString() ;
    }
}
