/*
 * @(#)KeyInt.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util.array;

import org.maachang.commons.serialize.SerializeUtil;

/**
 * int型Keyによるソート要素.
 * <BR><BR>
 * int型Keyによるソート要素です.
 * 実際にソートする場合、このオブジェクトを生成し[ObjectArray.sort()]で
 * ソートします.
 *
 * @version     1.00, 2004/10/28
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class KeyInt implements Comparable,KeyCommon
{
	
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            KeyInt.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * キー情報.
     */
    private int m_key = -1 ;
    
    /**
     * 格納情報.
     */
    private Object m_value = null ;
    
    /**
     * コンストラクタ.
     */
    private KeyInt()
    {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 対象の情報を設定します.
     * <BR>
     * @param key 対象のキーコードを設定します.
     * @param value 対象の格納情報を設定します.
     */
    public KeyInt( int key,Object value )
    {
        m_key = key ;
        m_value = value ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        m_key = -1 ;
        m_value = null ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * キーコードに対する格納情報を取得します.
     * <BR>
     * @return Object 格納情報が返されます.
     */
    public final Object getValue()
    {
        return m_value ;
    }
    
    /**
     * キー情報取得.
     * <BR><BR>
     * 格納されているキー情報が返されます.
     * <BR>
     * @return int キー情報が返されます.
     */
    public final int getKey()
    {
        return m_key ;
    }
    
    /**
     * 比較処理.
     * <BR><BR>
     * 対象のオブジェクト情報と比較します.
     * <BR>
     * @param o 比較対照のオブジェクトを設定します.
     * @return int 比較結果が返されます.<BR>
     *             このオブジェクトが指定されたオブジェクトより
     *             小さい場合は負の整数、等しい場合はゼロ、
     *             大きい場合は正の整数.
     */
    public final int compareTo( Object o )
    {
        return ( ( ( KeyInt )o ).getKey() <= m_key ) ?
            ( ( ( ( KeyInt )o ).getKey() == m_key ) ? 0 : 1 ) : -1 ;
    }
    
    
    
}

