/*
 * @(#)ReadElement.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util.read;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.io.IODef;
import org.maachang.commons.util.UtilCom;
import org.maachang.commons.util.array.ObjectArray;
import org.maachang.commons.util.convert.ConvertToIndexNo;


/**
 * 要素情報オブジェクト.
 * <BR><BR>
 * 要素情報をサポートするオブジェクト.
 *
 * @version 1.00, 2004/05/23
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class ReadElement extends ConvertToIndexNo
{
    
    /**
     * 要素情報管理.
     */
    private final ObjectArray m_array = new ObjectArray() ;
    
    /**
     * コンストラクタ.
     */
    public ReadElement()
    {
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public final void clear()
    {
        m_array.clear() ;
    }
    
    /**
     * 情報の追加.
     * <BR><BR>
     * 指定情報を追加します.
     * <BR>
     * @param info 追加対象の情報を設定します.
     */
    public final void add( String info )
    {
        try{
            
            if( info == null || info.length() <= 0 ) {
                info = "" ;
            }
            else {
                info = IODef.convertEnvironmentByName( info ) ;
            }
            
            m_array.add( ( info == null ) ? "" : info ) ;
        }catch( Exception t ){
        }
    }
    
    /**
     * 設定情報数の取得.
     * <BR><BR>
     * 設定されている情報数が返されます.
     * <BR>
     * @return int 設定情報数が返されます.
     */
    public final int size()
    {
        return m_array.size() ;
    }
    
    /**
     * 格納状態のまま、情報を取得.
     * <BR><BR>
     * 格納されている状態のままで、情報を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 格納状態のままの情報が返されます.
     * @exception InputException 入力例外.
     */
    public final String getNativeString( int no )
        throws InputException
    {
        if( no < 0 || no >= m_array.size() ){
            throw new InputException( "引数は不正です" ) ;
        }
        
        return ( String )m_array.get( no ) ;
        
    }
    
    
    /**
     * 対象情報取得処理.
     * <BR><BR>
     * 取得対象の処理を実施します.
     * この処理は、取得対象の処理で渡される処理を
     * 定義します.
     * <BR>
     * @param no 取得対象の項番を指定します.
     * @return Object 取得対象の情報が返されます.
     * @exception InputException 入力例外.
     */
    protected final Object getStringByNumber( int no )
        throws InputException
    {
        if( no < 0 || no >= m_array.size() ){
            throw new InputException( "引数は不正です" ) ;
        }
        
        return UtilCom.trimPlus( ( String )m_array.get( no ) ) ;
        
    }
    
    /**
     * 対象情報設定処理.
     * <BR><BR>
     * 設定対象の処理を実施します.
     * この処理は、設定対象の処理で渡される処理を
     * 定義します.
     * <BR>
     * @param no 設定対象の項番を指定します.
     * @param stream 設定対象の内容を指定します.
     * @exception InputException 入力例外.
     */
    protected final void setStringByNumber( int no,String stream )
        throws InputException
    {
        
        if( no < 0 || no >= m_array.size() ){
            throw new InputException( "引数は不正です" ) ;
        }
        
        m_array.set( no,stream ) ;
        
    }
    
}

