/*
 * @(#)Cb32Bean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect ;

import java.io.Serializable;
import java.util.HashSet;

import org.maachang.commons.serialize.SerializeUtil;

/**
 * 暗号Bean.
 *
 * @version 2007/01/13
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class Cb32Bean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            Cb32Bean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * 暗号フラグ.
     */
    private boolean cb32 = false ;
    
    /**
     * 暗号プライベートワード群.
     */
    private HashSet privateWord = null ;
    
    /**
     * コンストラクタ.
     */
    public Cb32Bean() {
        
    }

    /**
     * 暗号フラグを取得.
     * <BR><BR>
     * @return boolean 暗号フラグが返されます.
     */
    public boolean isCb32() {
        return cb32;
    }

    /**
     * 暗号フラグを設定.
     * <BR><BR>
     * @param cb32 暗号フラグを設定します.
     */
    public void setCb32(boolean cb32) {
        this.cb32 = cb32;
    }
    
    /**
     * 暗号プライベートワード群を追加.
     * <BR><BR>
     * @param words 対象のワード群を追加します.
     */
    public void putWords( String[] words ) {
        if( words != null && words.length > 0 ) {
            int len = words.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                this.addWord( words[ i ] ) ;
            }
        }
    }
    
    /**
     * 暗号プライベートワードを追加.
     * <BR><BR>
     * @param word 対象のワードを追加します.
     */
    public void addWord( String word ) {
        if( word != null && word.length() > 0 ) {
            if( privateWord == null ) {
                privateWord = new HashSet() ;
            }
            privateWord.add( word ) ;
        }
    }
    
    /**
     * 暗号プライベートワード群を取得.
     * <BR><BR>
     * @return String[] 対象のワード群が返されます.
     */
    public String[] getWords() {
        if( privateWord != null && privateWord.size() > 0 ) {
            int len = privateWord.size() ;
            Object[] objs = privateWord.toArray() ;
            String[] ret = new String[ len ] ;
            System.arraycopy( objs,0,ret,0,len ) ;
            return ret ;
        }
        return null ;
    }
}

