/*
 * @(#)BaseTable.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.table ;

import org.maachang.commons.util.array.ObjectArray;

/**
 * 基本テーブル.
 *
 * @version 2006/12/22
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public abstract class BaseTable {
    
    /**
     * ID管理テーブル.
     */
    protected ObjectArray table = null ;
    
    /**
     * 指定IDに対する項番を取得.
     * <BR><BR>
     * 指定IDに対する項番を取得します.
     * <BR>
     * @param id 対象のIDを設定します.
     * @return int 対象項番が返されます.<BR>
     *              [-1]が返された場合、情報は存在しません.
     */
    protected int getNumber( long id ) {
        int i ;
        int len = table.size() ;
        BaseBean bean = null ;
        for( i = 0 ; i < len ; i ++ ) {
            bean = ( BaseBean )table.get( i ) ;
            if( bean != null && bean.getId() == id ) {
                return i ;
            }
        }
        
        return -1 ;
    }
    
}

