/*
 * @(#)CompletionBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.table ;

import java.net.InetAddress;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.resource.BinResource;

/**
 * １つの受信完了を示すデータBean.
 *
 * @version 2006/12/22
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class CompletionBean {
    
    /**
     * コネクションアドレス.
     */
    private InetAddress address = null ;
    
    /**
     * コネクションポート番号.
     */
    private int port = -1 ;
    
    /**
     * 暗号ワード.
     */
    private String cb32Word = null ;
    
    /**
     * 送信データ電文.
     */
    private BinResource receiveData = null ;
    
    /**
     * コンストラクタ.
     */
    private CompletionBean() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 生成IDを設定します.
     * <BR>
     * @param address 送信先コネクションアドレスを設定します.
     * @param port 送信先ポート番号を設定します.
     * @param cb32Word 暗号ワード情報を設定します.
     * @param receiveData 送信対象のデータを設定します.
     * @exception InputException 入力例外.
     */
    public CompletionBean( InetAddress address,int port,String cb32Word,BinResource receiveData )
        throws InputException {
        if( address == null || receiveData == null || receiveData.size() <= 0 ) {
            throw new InputException( "引数は不正です" ) ;
        }
        this.address = address ;
        this.port = port ;
        this.cb32Word = cb32Word ;
        this.receiveData = receiveData ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     */
    protected void finalize() throws Exception {
        address = null ;
        port = -1 ;
        cb32Word = null ;
        receiveData = null ;
    }

    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public InetAddress getAddress() {
        return address;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * cb32Word を取得.
     * <BR><BR>
     * @return cb32Word が返されます.
     */
    public String getCb32Word() {
        return cb32Word;
    }

    /**
     * receiveData を取得.
     * <BR><BR>
     * @return receiveData が返されます.
     */
    public BinResource getReceiveData() {
        return receiveData;
    }
    
}

