/*
 * @(#)CompletionTable.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.table ;

import org.maachang.commons.util.array.ObjectArray;

/**
 * 受信完了データを格納するテーブル.
 *
 * @version 2006/12/22
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class CompletionTable {
    
    /**
     * 受信完了データ格納テーブル.
     */
    private ObjectArray table = null ;
    
    /**
     * コンストラクタ.
     */
    public CompletionTable() {
        table = new ObjectArray() ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を実施.
     */
    protected void finalize() throws Exception {
        table = null ;
    }
    
    /**
     * 受信完了データ追加.
     * <BR><BR>
     * 受信完了データを追加します.
     * <BR>
     * @param bean 受信完了データを設定します.
     */
    public synchronized void add( CompletionBean bean ) {
        if( bean == null || bean.getAddress() == null || bean.getReceiveData() == null ) {
            return ;
        }
        
        table.add( bean ) ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 受信完了データを取得します.
     * <BR>
     * @return CompletionBean 受信完了データが返されます.<BR>
     *                         [null]が返された場合、情報は存在しません.
     */
    public synchronized CompletionBean get() {
        return ( CompletionBean )table.remove( 0 ) ;
    }
    
    /**
     * 情報サイズを取得.
     * <BR><BR>
     * 格納されている情報サイズが返されます.
     * <BR>
     * @return int 情報サイズが返されます.
     */
    public synchronized int size() {
        return table.size() ;
    }
    
}

