/*
 * @(#)MaachangConnectSync.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.table ;

import org.maachang.commons.thread.Synchronized;

/**
 * MaachangConnectプロトコル同期.
 *
 * @version 2006/12/23
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class MaachangConnectSync {
    
    /**
     * コネクション同期.
     */
    private final Synchronized connectSync = new Synchronized() ;
    
    /**
     * 送信同期.
     */
    private final Synchronized sendSync = new Synchronized() ;
    
    /**
     * 送信中同期.
     */
    private final Synchronized underReceiveSync = new Synchronized() ;
    
    /**
     * コンストラクタ.
     */
    public MaachangConnectSync() {
    }
    
    /**
     * オブジェクト生成.
     * <BR><BR>
     * オブジェクトを生成します.
     */
    public void create() {
        connectSync.create() ;
        sendSync.create() ;
        underReceiveSync.create() ;     
    }
    
    /**
     * オブジェクトクリア.
     * <BR><BR>
     * オブジェクトをクリアします.
     */
    public void clear() {
        connectSync.clear() ;
        sendSync.clear() ;
        underReceiveSync.clear() ;
    }

    /**
     * connectSync を取得.
     * <BR><BR>
     * @return connectSync が返されます.
     */
    public Synchronized getConnectSync() {
        return connectSync;
    }

    /**
     * sendSync を取得.
     * <BR><BR>
     * @return sendSync が返されます.
     */
    public Synchronized getSendSync() {
        return sendSync;
    }

    /**
     * underReceiveSync を取得.
     * <BR><BR>
     * @return underReceiveSync が返されます.
     */
    public Synchronized getUnderReceiveSync() {
        return underReceiveSync;
    }
    
}

