/*
 * @(#)SendReceiveTable.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.table ;

import java.net.InetAddress;

/**
 * 送受信データBean.
 *
 * @version 2006/12/23
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class SendReceiveBean {
    
    /**
     * デフォルト送信カウント.
     */
    private static final int DEF_SEND_COUNT = 1 ;
    
    /**
     * アドレス.
     */
    private InetAddress address = null ;
    
    /**
     * ポート番号.
     */
    private int port = -1 ;
    
    /**
     * データ電文.
     */
    private byte[] telegram = null ;
    
    /**
     * 送信回数.
     */
    private int sendCount = 0 ;
    
    /**
     * コンストラクタ.
     */
    public SendReceiveBean() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 指定条件を設定してオブジェクトを生成します.
     * <BR>
     * @param address 対象のアドレスを設定します.
     * @param port 対象のポート番号を設定します.
     * @param telegram 対象の電文情報を設定します.
     */
    public SendReceiveBean( InetAddress address,int port,byte[] telegram ) {
        this.address = address ;
        this.port = port ;
        this.telegram = telegram ;
        this.sendCount = DEF_SEND_COUNT ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 指定条件を設定してオブジェクトを生成します.
     * <BR>
     * @param address 対象のアドレスを設定します.
     * @param port 対象のポート番号を設定します.
     * @param telegram 対象の電文情報を設定します.
     */
    public SendReceiveBean( InetAddress address,int port,byte[] telegram,int sendCount ) {
        this.address = address ;
        this.port = port ;
        this.telegram = telegram ;
        this.sendCount = ( sendCount <= 0 ) ? DEF_SEND_COUNT : sendCount ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        address = null ;
        port = -1 ;
        telegram = null ;
        sendCount = 0 ;
    }

    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public InetAddress getAddress() {
        return address;
    }

    /**
     * address を設定.
     * <BR><BR>
     * @param address address を設定します.
     */
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * telegram を取得.
     * <BR><BR>
     * @return telegram が返されます.
     */
    public byte[] getTelegram() {
        return telegram;
    }

    /**
     * telegram を設定.
     * <BR><BR>
     * @param telegram telegram を設定します.
     */
    public void setTelegram(byte[] telegram) {
        this.telegram = telegram;
    }

    /**
     * sendCount を取得.
     * <BR><BR>
     * @return sendCount が返されます.
     */
    public int getSendCount() {
        return sendCount;
    }

    /**
     * sendCount を設定.
     * <BR><BR>
     * @param sendCount sendCount を設定します.
     */
    public void setSendCount(int sendCount) {
        this.sendCount = sendCount;
    }
    
}

