/*
 * @(#)MaachangConnectBaseExecution.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.thread ;

import org.maachang.connect.table.MaachangConnectSync;
import org.maachang.connect.table.MaachangConnectTableFactory;

import org.maachang.commons.net.BaseUdpProtocol;
import org.maachang.commons.net.ConnectAddress;

/**
 * MaachangConnectプロトコル基本実装インターフェイス.
 *
 * @version 2006/12/23
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public interface MaachangConnectBaseExecution {
    
    /**
     * 実行処理.
     * <BR><BR>
     * MaachangConnectプロトコル実行処理.
     * <BR>
     * @param threadNum スレッド項番を設定されます.
     * @param udp 対象のUDPプロトコルを設定されます.
     * @param tableFactory テーブルFactoryを設定されます.
     * @param sync 同期オブジェクトが設定されます.
     * @param connectAddress 受信処理などに利用するコネクションアドレス.
     * @param cb32Word 暗号解析結果の暗号ワードを格納する情報が設定されます.
     * @exception Exception 処理例外.
     */
    public void execution( int threadNum,BaseUdpProtocol udp,
        MaachangConnectTableFactory tableFactory,MaachangConnectSync sync,
        ConnectAddress connectAddress,String[] cb32Word ) throws Exception ;
    
}

