/*
 * @(#)ExecutionSend.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect.thread.execution ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.connect.table.MaachangConnectSync;
import org.maachang.connect.table.MaachangConnectTableFactory;
import org.maachang.connect.table.SendReceiveBean;
import org.maachang.connect.thread.MaachangConnectBaseExecution;

import org.maachang.commons.net.BaseUdpProtocol;
import org.maachang.commons.net.ConnectAddress;
import org.maachang.commons.net.UndefineBindException;
import org.maachang.commons.util.UtilCom;

/**
 * 送信電文実装処理.
 *
 * @version 2006/12/23
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class ExecutionSend implements MaachangConnectBaseExecution {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( ExecutionSend.class ) ;
    
    /**
     * コンストラクタ.
     */
    public ExecutionSend() {
        
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * MaachangConnectプロトコル実行処理.
     * <BR>
     * @param threadNum スレッド項番を設定されます.
     * @param udp 対象のUDPプロトコルを設定されます.
     * @param tableFactory テーブルFactoryを設定されます.
     * @param sync 同期オブジェクトが設定されます.
     * @param connectAddress 受信処理などに利用するコネクションアドレス.
     * @param cb32Word 暗号解析結果の暗号ワードを格納する情報が設定されます.
     * @exception Exception 処理例外.
     */
    public void execution( int threadNum,BaseUdpProtocol udp,
        MaachangConnectTableFactory tableFactory,MaachangConnectSync sync,
        ConnectAddress connectAddress,String[] cb32Word ) throws Exception {
        
        try {
            SendReceiveBean bean = tableFactory.getSendReceiveTable().getSend() ;
            if( bean != null ) {
                
//System.out.println( "(" + bean.getTelegram().length + ")" +
//UtilCom.convertBinaryTo16String( bean.getTelegram(),',',0,bean.getTelegram().length ) ) ;
                
                // 送信回数が設定されていない場合.
                if( bean.getSendCount() <= 1 ) {
                    udp.send( bean.getTelegram(),bean.getAddress(),bean.getPort() ) ;
                }
                // 送信回数が設定されている場合.
                else {
                    for( int i = 0 ; i < bean.getSendCount() ; i ++ ) {
                        udp.send( bean.getTelegram(),bean.getAddress(),bean.getPort() ) ;
                    }
                }
            }
            else {
                UtilCom.idleTime() ;
            }
        } catch( UndefineBindException ub ) {
            LOG.error( "UDPバインド例外",ub ) ;
            if( tableFactory != null ) {
                tableFactory.setExitThreadFlag( true ) ;
            }
        } catch( Exception e ) {
            LOG.warn( "電文送信処理で例外",e ) ;
        }
        
    }
    
}

