/*
 * @(#)MaachangQ.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.InitPackage;
import org.maachang.commons.util.UtilCom;
import org.maachang.queue.config.MqDefine;

/**
 * MaachangQ起動オブジェクト.
 *  
 * @version 2006/12/26
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class MaachangQ {
    
    private MaachangQ() {}
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( MaachangQ.class ) ;
    
    /**
     * MaachangQオブジェクト.
     */
    private static final MaachangQ maachangQ = new MaachangQ() ;
    
    /**
     * シャットダウンフラグ.
     */
    private boolean shutdown = false ;
    
    /**
     * MaachangQ起動メソッド.
     * <BR><BR>
     * @param args 外部パラメタ.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        
        LOG.info( "## [MaachangQ] -" + MqDefine.version() + " -開始します" ) ;
        
        new InitPackage().init() ;
        maachangQ.execution( args ) ;
        
        LOG.info( "## [MaachangQ] -" + MqDefine.version() + " -終了します" ) ;
        
    }
    
    /**
     * MaachangQシャットダウンメソッド.
     */
    public static final void shutdown() {
        
        maachangQ.setShutdown( true ) ;
        
    }
    
    /**
     * シャットダウンフラグを設定.
     * <BR><BR>
     * @param flag シャットダウンフラグを設定.
     */
    protected synchronized void setShutdown( boolean mode ) {
        shutdown = mode ;
    }
    
    /**
     * シャットダウンフラグを取得.
     * <BR><BR>
     * @return boolean シャットダウンフラグが返されます.
     */
    protected synchronized boolean isShutdown() {
        return shutdown ;
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args Javaパラメータが設定されます.
     * @exception Exception 例外.
     */
    protected void execution( String[] args )
        throws Exception {
        
        MaachangQStartup startup = new MaachangQStartup() ;
        
        String param = null ;
        if( args == null || args.length <= 0 ) {
            param = null ;
        }
        else if( args.length <= 1 ) {
            param = args[ 1 ] ;
        }
        
        // スタートアップ処理.
        startup.init( param ) ;
        
        // シャットダウンフック.
        MaachangQShutdownHook shutdownHook = new MaachangQShutdownHook(
            startup ) ;
        
        // シャットダウンフックを登録.
        Runtime.getRuntime().addShutdownHook( shutdownHook ) ;
        
        // メインスレッド待機.
        this.waitMaachangQ() ;
        
    }
    
    /**
     * 処理待機.
     */
    private void waitMaachangQ()
        throws Exception {
        
        LOG.info( "## [MaachangQ] - 処理待機処理 - start." ) ;
        
        try {
            
            for( ;; ) {
                
                UtilCom.idleTime() ;
                    
                if( this.isShutdown() == true ) {
                    LOG.info( "## [MaachangQ] - シャットダウン命令が呼び出されました" ) ;
                    break ;
                    
                }
                
            }
            
        } catch( Exception e ) {
            LOG.error( "## [MaachangQ] - 処理待機処理中にエラーが発生",e ) ;
        }
        
        LOG.info( "## [MaachangQ] - 処理待機処理 - end." ) ;
        
    }
    
}

