/*
 * @(#)MqDefine.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.config ;

import org.maachang.commons.resource.cache.CacheDef;
import org.maachang.commons.sys.user.UserManager;
import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * MaachangQ定義オブジェクト.
 *  
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class MqDefine {
    
    private MqDefine(){}
    
    //////////////////////////////
    // MaachangQ基本定義.
    //////////////////////////////
    
    /**
     * MaachangQバージョン情報.
     * <BR><BR>
     * MaachangQバージョン情報を取得します.
     * <BR>
     * @return String バージョン情報が返されます.
     */
    public static final String version() {
        return "1.00" ;
    }
    
    
    //////////////////////////////
    // MaachangQ - ディレクトリ関連.
    //////////////////////////////
    
    /**
     * MaachangQ環境変数.
     */
    public static final String EMV_NAME = "$(MAACHANGQ)/build/" ;
    
    /**
     * キャッシュディレクトリ名.
     */
    public static final String CACHE_DIR = "cache" ;
    
    /**
     * コンフィグディレクトリ名.
     */
    public static final String CONF_DIR = "conf" ;
    
    /**
     * ユーザ情報ディレクトリ名.
     */
    public static final String USER_DIR = "user" ;
    
    /**
     * 構成情報＆ユーザ情報管理格納ディレクトリ名.
     */
    public static final String SAVE_DIR = ".macchangq" ;
    
    
    //////////////////////////////
    // MaachangQ - チャネル関連.
    //////////////////////////////
    
    /**
     * デフォルトチャネル間ポート.
     */
    public static final int DEFAULT_CHANNEL_PORT = MaachangQAccessDefine.DEFAULT_CHANNEL_PORT ;
    
    /**
     * チャネル間圧縮条件.
     */
    public static final int CHANNEL_GZIP_LENGTH = 1024 ;
    
    
    //////////////////////////////
    // MaachangQ - キュー関連.
    //////////////////////////////
    
    /**
     * 送信キュー格納数.
     */
    public static final int DEFAULT_SEND_QUEUE_LENGTH = MaachangQAccessDefine.DEFAULT_QUEUE_SIZE ;
    
    /**
     * 受信キュー最大格納数.
     */
    public static final int MAX_RECEIVE_QUEUE_LENGTH = MaachangQAccessDefine.MAX_QUEUE_SIZE ;
    
    /**
     * 基本最大メッセージ数.
     */
    public static final int MAX_QUEUE_MESSAGE_LENGTH = 65536 ;
    
    /**
     * 電文リソース変換開始値.
     */
    public static final int CONVERT_RESOURCE_PAUSE_LENGTH = 2048 ;
    
    /**
     * 電文圧縮変換開始値.
     */
    public static final int CONVERT_GZIP_PAUSE_LENGTH = CacheDef.SECTOR_LENGTH ;
    
    
    //////////////////////////////
    // MaachangQ - キャッシュ関連.
    //////////////////////////////
    
    /**
     * キャッシュファイル拡張子.
     */
    public static final String CACHE_PLUS = ".csh" ;
    
    /**
     * デフォルトコネクションキャッシュ名.
     */
    public static final String DEFAULT_CONNECT_CACHE = "default" ;
    
    /**
     * コネクションキャッシュ名.
     */
    public static final String CONNECT_CHACHE = "cache-c_%CONNECT%" ;
    
    /**
     * マネージャ内キャッシュ名.
     */
    public static final String SEND_QUEUE_CACHE = "cache-m_%QMAN%" ;
    
    /**
     * 最小キャッシュセクター数.
     */
    public static final int DEFAULT_CACHE_SECTOR = MaachangQAccessDefine.DEFAULT_CACHE_SECTOR ;
    
    /**
     * 最小キャッシュセクター数.
     */
    public static final int MIN_CACHE_SECTOR = MaachangQAccessDefine.MIN_CACHE_SECTOR ;
    
    /**
     * 最大キャッシュセクター数.
     */
    public static final int MAX_CACHE_SECTOR = MaachangQAccessDefine.MAX_CACHE_SECTOR ;
    
    
    //////////////////////////////
    // MaachangQ - コンフィグ関連.
    //////////////////////////////
    
    /**
     * コンフィグファイル名.
     */
    public static final String CONF_FILE = "maachangq.conf" ;
    
    /**
     * サーバSSLコンフィグファイル名.
     */
    public static final String SSL_CONF_FILE = "ssl.conf" ;
    
    
    //////////////////////////////
    // MaachangQ - 構成情報保存関連.
    //////////////////////////////
    
    /**
     * 保存ファイル拡張子.
     */
    public static final String SAVE_PLUS = ".sv" ;
    
    /**
     * 構成情報名保存拡張子.
     */
    public static final String SAVE_MANAGE_PLUS = ".msv" ;
    
    
    //////////////////////////////
    // MaachangQ - ユーザ管理系.
    //////////////////////////////
    
    /**
     * ユーザ情報管理ファイル名.
     */
    public static final String USER_FILE_NAME = "user.man" ;
    
    /**
     * ルートユーザ名.
     */
    public static final String ROOT_USER = UserManager.ROOT_USER ;
    
    /**
     * ユーザ最大数.
     */
    public static final int MAX_USER = 255 ;
    
    
    //////////////////////////////
    // MaachangQ - 置き換え名前関連.
    //////////////////////////////
    
    /**
     * 置き換え名前 : 開始 or 終了値.
     */
    public static final String REPACE_START_OF_END = "%" ;
    
    /**
     * 置き換え名前 : キューマネージャ名.
     */
    public static final String REPLACE_NAME_QUEUE_MANAGER = "QMAN" ;
    
    /**
     * 置き換え名前 : キュー名.
     */
    public static final String REPLACE_NAME_QUEUE = "QUEUE" ;
    
    /**
     * 置き換え名前 : チャネル名.
     */
    public static final String REPLACE_NAME_CHANNEL = "CHANNEL" ;
    
    /**
     * 置き換え名前 : コネクション名.
     */
    public static final String REPLACE_NAME_CONNECT = "CONNECT" ;
    
    
    
}

