/*
 * @(#)SSLConfig.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.config ;

import org.maachang.commons.exception.InputException;

/**
 * サーバSSLコンフィグファイル読み込む処理.
 *
 * @version 2007/01/13
 * @author  Masahito Suzuki
 * @since   MaachangQ-1.00
 */
public interface SSLConfig {
    
    /**
     * SSLプロトコル利用条件を取得.
     * <BR><BR>
     * SSLプロトコル利用条件を取得します.<BR>
     * この情報はセクション名[ssl]以下に
     * 設定されている[ssl]情報を取得します.
     * <BR>
     * @return boolean SSLプロトコル利用条件が返されます.
     */
    public boolean isSSL() ;
    
    /**
     * SSLプロトコルを取得.
     * <BR><BR>
     * SSLプロトコルを取得します.<BR>
     * この情報はセクション名[ssl]以下に
     * 設定されている[protocol]情報を取得します.
     * <BR>
     * @return String SSLプロトコル名が返されます.
     */
    public String getSSlProtocol() ;
    
    /**
     * 乱数アルゴリズム(PRNG)を取得.
     * <BR><BR>
     * 乱数アルゴリズム(PRNG)を取得します.<BR>
     * この情報はセクション名[ssl]以下に
     * 設定されている[random-algorithm]情報を取得します.
     * <BR>
     * @return String 乱数アルゴリズム(PRNG)が返されます.
     */
    public String getRandomAlgorithm() ;
    
    /**
     * クライアント認証モードを取得.
     * <BR><BR>
     * クライアント認証モードを取得します.<BR>
     * この情報はセクション名[ssl]以下に
     * 設定されている[client-auth]情報を取得します.
     * <BR>
     * @return boolean クライアント認証モードが返されます.
     */
    public boolean isClientAuth() ;
    
    /**
     * キーストアタイプを取得.
     * <BR><BR>
     * キーストアタイプを取得します.<BR>
     * この情報はセクション名[keystore]以下に
     * 設定されている[key-store]情報を取得します.
     * <BR>
     * @return String キーストアタイプが返されます.
     */
    public String getKeyStore() ;
    
    /**
     * キーストアマネージャアルゴリズムを取得.
     * <BR><BR>
     * キーストアマネージャアルゴリズムを取得します.<BR>
     * この情報はセクション名[keystore]以下に
     * 設定されている[key-manager-algorithm]情報を取得します.
     * <BR>
     * @return String キーストアマネージャアルゴリズムが返されます.
     */
    public String getKeyManagerAlgorithm() ;
    
    /**
     * キーストアパスワードを取得.
     * <BR><BR>
     * キーストアパスワードを取得します.<BR>
     * この情報はセクション名[keystore]以下に
     * 設定されている[key-passwd]情報を取得します.
     * <BR>
     * @return String キーストアパスワードが返されます.
     */
    public String getKeyPasswd() ;
    
    /**
     * キーストアファイルを取得.
     * <BR><BR>
     * キーストアファイルを取得します.<BR>
     * この情報はセクション名[keystore]以下に
     * 設定されている[key-file]情報を取得します.
     * <BR>
     * @return String キーストアファイルが返されます.
     */
    public String getKeyFile() ;
    
    /**
     * トラストストア利用条件を取得.
     * <BR><BR>
     * トラストストア利用条件を取得します.<BR>
     * この情報はセクション名[truststore]以下に
     * 設定されている[trust]情報を取得します.
     * <BR>
     * @return boolean トラストストア利用条件が返されます.
     */
    public boolean isTrust() ;
    
    /**
     * トラストストアタイプを取得.
     * <BR><BR>
     * トラストストアタイプを取得します.<BR>
     * この情報はセクション名[truststore]以下に
     * 設定されている[trust-store]情報を取得します.
     * <BR>
     * @return String トラストストアタイプが返されます.
     */
    public String getTrustStore() ;
    
    /**
     * トラストストアマネージャアルゴリズムを取得.
     * <BR><BR>
     * トラストストアマネージャアルゴリズムを取得します.<BR>
     * この情報はセクション名[truststore]以下に
     * 設定されている[trust-manager-algorithm]情報を取得します.
     * <BR>
     * @return String トラストストアマネージャアルゴリズムが返されます.
     */
    public String getTrustManagerAlgorithm() ;
    
    /**
     * トラストストアパスワードを取得.
     * <BR><BR>
     * トラストストアパスワードを取得します.<BR>
     * この情報はセクション名[truststore]以下に
     * 設定されている[trust-passwd]情報を取得します.
     * <BR>
     * @return String トラストストアパスワードが返されます.
     */
    public String getTrustPasswd() ;
    
    /**
     * トラストストアファイルを取得.
     * <BR><BR>
     * トラストストアファイルを取得します.<BR>
     * この情報はセクション名[truststore]以下に
     * 設定されている[trust-file]情報を取得します.
     * <BR>
     * @return String トラストストアファイルが返されます.
     */
    public String getTrustFile() ;
    
    /**
     * 対象の情報を文字列で取得.
     * <BR><BR>
     * 対象の情報を文字列で取得します.
     * <BR>
     * @param section 対象のセクション名を設定します.
     * @param key 対象のキー名を設定します.
     * @param no 対象のキー名に対する項番を設定します.
     * @return String 対象の条件をStringで取得した結果が返されます.
     * @exception InputException 入力例外.
     */
    public String get( String section,String key,int no ) ;
    
    /**
     * 対象条件数を取得.
     * <BR><BR>
     * 対象の条件の定義数を取得します.
     * <BR>
     * @return int 定義数が返されます.
     */
    public int size( String section,String key ) ;
    
    /**
     * 定義ファイルで必要なセクション名群が有効であるかチェック.
     * <BR><BR>
     * 定義ファイルで必要なセクション名群が有効であるかチェックします.
     * <BR>
     * @return boolean 有効であるかチェックします.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、有効ではありません.
     */
    public boolean isUseSection() ;
    
    /**
     * 対象セクション名存在チェック.
     * <BR><BR>
     * 対象のセクション名が存在するかチェックします.
     * @param section 対象のセクション名を設定します.
     * @return boolean 存在結果が返されます.<BR>
     *                 [true]が返された場合、セクション名は存在します.<BR>
     *                 [false]が返された場合、セクション名は存在しません.
     */
    public boolean isSection( String section ) ;
    
}
